/*
 ****************************************************************************
 *
 *	File:	enhanced_cb.C
 *
 *	Functions(s):
 *
 *	Description:
 *		enhanced callback stubs, generated by the OI UIB.
 *
 *	RCSid = "$Id: enhanced_cb.C,v 1.2.1.1 1993/06/10 17:13:26 mth Exp $"
 *
 ****************************************************************************
 */
#include <OI/oi.H>
#include "enhanced.H"
#include "enhanced_bd.H"

/*
 *	The following definitions are generated and read by the user
 *	interface builder to simplify the process of generating prototype
 *	stubs.
 *
 *	The user interface builder will ONLY preserve prototype stubs placed
 *	above the dividing line (below).  If you need to include additional
 *	header files to ensure that your program compiles, please include 
 *	them in
 *		enhanced.H
 *
 *	CAVEAT
 *		These definitions ensure that a prototype stub is not
 *		regenerated.   PLEASE leave the definition here
 *		even if you move the stub to another file.
 *	
 */

extern OI_ef_entry_chk_status find_text (OI_entry_field *, void *);
extern void load_file (OI_menu_cell *, void *, OI_number);
extern void save_file (OI_menu_cell *, void *, OI_number);
extern void clear_viewer (OI_menu_cell *, void *, OI_number);


/* End of Function Declarations -- Protected User Code begins at next line */
#include <string.h>
/*
 ******************************************************************************
 *
 *	Function Name:	find_text
 *
 *	This function is called whenever entry is complete
 *	(return is pressed) on an entry field. This function
 *	returns a value of type OI_ef_entry_chk_status to
 *	indicate the validity of the entry.
 *		OI_EF_ENTRY_CHK_OK	: entry is ok
 *		OI_EF_ENTRY_CHK_BAD	: entry is invalid
 *	The bell is sounded when a return of OI_EF_ENTRY_CHK_BAD
 *	is made. The function may post error messages via
 *	push_help_str(), activate dialog boxes, or perform other
 *	actions.  If no error message is posted using
 *	push_help_str(), and a return of OI_EF_ENTRY_CHK_BAD is
 *	made, a generic message is displayed.
 *
 *	`efp' is a pointer to the object where the entry was
 *	just completed.  `argp' is the user supplied argument.
 *
 *	Returns:
 *		OI_ef_entry_chk_status : entry is valid or not
 *
 *	Side Effects:
 *		none.
 *
 *	Warnings:
 *		none.
 *
 ******************************************************************************
 */
OI_ef_entry_chk_status
find_text (
	OI_entry_field	*efp,		// (input) ptr to object clicked on
	void		*)		// (input) user supplied argument
{
 /*	External Variables */
 /*	External Procedures: */
 /*	Local Variables: */
		long		x, y ;
		OI_number	linp ;
		OI_number	chrp ;
		OI_ef_entry_chk_status	rtn ;
 /*
	Procedure:
 */
	rtn = OI_EF_ENTRY_CHK_OK ;
	if (efp->part_text() && strlen( efp->part_text() )) {
		chrp = scroll_text->cursor_column() + 1;
		linp = scroll_text->cursor_line();
fprintf( stderr, "(%d,%d) -> ", linp, chrp );
		if (scroll_text->find_string( &linp, &chrp, efp->part_text(), OI_YES )) {
fprintf( stderr, "(%d,%d)\n", linp, chrp );
			scroll_text->set_position( linp, chrp );
		}
		else {
			rtn = OI_EF_ENTRY_CHK_BAD ;
			efp->push_help_str( "String not found.", OI_YES );
		}
	}
	return( rtn );
}

/*
 ******************************************************************************
 *
 *	Function Name:	clear_viewer
 *
 *		Description: 
 *			The scroll text is cleared.
 *
 *		Returns:
 *			nothing
 * 
 *		Side Effects:
 *			none.
 *
 *		Warnings:
 *			We do not test to see if the contents of the scroll text
 *			are dirty and prompt the user accordingly.
 *
 ******************************************************************************
 */
void
clear_viewer (
	OI_menu_cell	*cellp,		// (input) ptr to cell which fired
	void		*,		// (input) ptr to user supplied argument
	OI_number )	// (input) mouse button used to fire cell
{
/*	External Variables */
/*	External Procedures: */
/*	Local Variables: */
/*
	Procedure:
*/
	if (cellp->selected()) {
		scroll_text->clear_text();
	}
	return ;
}

static int
file_actions( OI_menu_cell *cellp, void* argp, OI_number )
{
/*	External Variables */
/*	External Procedures: */
/*	Local Variables: */
		int			ok ;
		OI_file_dialog_box	*fdlg ;
/*
	Procedure:
*/

	ok = OI_YES ;
	if (!strcmp( cellp->name(), "OK" )) {
		fdlg = (OI_file_dialog_box*) cellp->ancestor_derived_from( OI_file_dialog_box::clsp );
		if (!fdlg->pathname())
			ok = OI_NO ;
		else {
			if ((OI_bool)argp) {		/* LOAD */
				scroll_text->set_text_to_file( fdlg->pathname() );
				cellp->app_window()->set_longterm( fdlg->pathname() );
			}
			else {				/* SAVE */
				scroll_text->output_text( fdlg->pathname() );
			}
		}
	}
	return( ok ) ;
}

/*
 ******************************************************************************
 *
 *	Function Name:	load_file
 *
 *		Description: 
 *			Invokes a file dialog for file selection.  If a file
 *			was selected, then the contents of the file is loaded
 *			into the scroll text.
 *
 *		Returns:
 *			nothing
 * 
 *		Side Effects:
 *			none.
 *
 *		Warnings:
 *			We do not test to see if the contents of the scroll text
 *			are dirty and prompt the user accordingly.
 *
 ******************************************************************************
 */
void
load_file (
	OI_menu_cell	*cellp,		// (input) ptr to cell which fired
	void		*,		// (input) ptr to user supplied argument
	OI_number )	// (input) mouse button used to fire cell
{
/*	External Variables */
/*	External Procedures: */
/*	Local Variables: */
		OI_file_dialog_box	*fdlg ;
/*
	Procedure:
*/
	if (cellp->selected()) {
		fdlg = (OI_file_dialog_box*) cellp->app_window()->descendant( "file_dialog" );
		fdlg->disallow_pushpin();
		fdlg->wait_button( OI_YES, file_actions, (void*) OI_YES );
	}

	return ;
}

/*
 ******************************************************************************
 *
 *	Function Name:	save_file
 *
 *		Description: 
 *			Invokes a file dialog for file selection.  If a file
 *			was selected, then the contents of the scroll text is
 *			flushed to the specified file.
 *
 *		Returns:
 *			nothing
 * 
 *		Side Effects:
 *			none.
 *
 *		Warnings:
 *			none.
 *
 ******************************************************************************
 */
void
save_file (
	OI_menu_cell	*cellp,		// (input) ptr to cell which fired
	void		*,		// (input) ptr to user supplied argument
	OI_number )	// (input) mouse button used to fire cell
{
/*	External Variables */
/*	External Procedures: */
/*	Local Variables: */
		OI_file_dialog_box	*fdlg ;
/*
	Procedure:
*/
	if (cellp->selected()) {
		fdlg = (OI_file_dialog_box*) cellp->app_window()->descendant( "file_dialog" );
		fdlg->disallow_pushpin();
		fdlg->wait_button( OI_YES, file_actions, (void*) OI_NO );
	}

	return ;
}

