#include <OI/oi.H>
#if defined(ultrix) || defined(SVR4) || defined(hpux)
#include <unistd.h>
#else
#include <sysent.h>
#endif
#include <sys/param.h>
#include <string.h>

/*
 *	Translations
 *	
 *	This program demostrates the use of translations to achieve filename
 *	completetion inside a file dialog box.
 *
 *	Suggested translations can be found in config.filec
 *      These translations need to be merged into the current X resource
 *      database for the demo to work correctly; use "xrdb -merge config.filec"
 *
 *	The reader should refer to the OI documentation for
 *	information on the following member functions.
 *		- OITrans (3O)
 *		- OI_d_tech (3O)
 *			layout_associated_object()
 *			set_associated_object()
 *			set_layout()
 *		- OI_app_window (3O)
 */

void complete_filename (OI_d_tech *, const XEvent *, char **, unsigned int *);
void update_filter (OI_d_tech *, const XEvent *, char **, unsigned int *);

void parse_path_in_ef (OI_entry_field *, char *, char *);
int entry_field_complete (OI_entry_field *);

static OI_actions_rec actions[] = {
	{"complete_filename", (OI_translation_fnp) &complete_filename},
	{"update_filter", (OI_translation_fnp) &update_filter}
};

/*
 *	update_filter
 *
 *	Updates the filter in the file dialog box that contains this entry field.  Note:
 *		There is a bug in this routine that clears the entry text field.
 */
void update_filter (OI_d_tech *objp, const XEvent *, char **, unsigned int *)
{
	char			dir[MAXPATHLEN];
	char			file[MAXPATHLEN];
	OI_file_dialog_box	*file_db;
	
	file_db = (OI_file_dialog_box *) objp -> parent();
	parse_path_in_ef ((OI_entry_field *) objp, dir, file);
	strcat (file, "*");
	file_db -> set_files (dir, file);
}

/*
 *	complete_filename
 *
 *	Translation routine that is to be bound to an entry field.  It will complete the partial file speicifcation.  It
 *	also understand file dialog boxes, so it can get the current directory from there.
 */
void complete_filename (OI_d_tech *objp, const XEvent *, char **, unsigned int *)
{
	OI_entry_field		*efp = (OI_entry_field *) objp;
	entry_field_complete (efp);
}

/*
 *	main
 *
 *	This program demonstrates
 *		- initializing OI, opening a connection to the server
 *		- fetching additional resources
 *		- create the file dialog box
 *		- add the callbacks to the 
 */
void
main (int argc, char **argv)
{
	OI_connection	*conp;			/* the connection to the server */
	OI_file_dialog_box *file_db;		/* File dialog box for example. */
	OI_entry_field	*efp;			/* Pointer to the file dialog box ef */
	OI_app_window	*awp;			/* Top level box */
	
	/*
	 *	Open a connection to the server.
	 */
	if ((conp = OI_init(&argc, argv, "filec_trans", "Complete"))) {

		/*
		 *	Create the outermost app window
		 */
		awp = oi_create_app_window ("topLevel", 1, 1,"Callback Demo");
		awp -> set_layout (OI_layout_row);
		
		/*
		 *	Create the file dialog box, with the default menu cells.
		 */
		file_db = oi_create_file_dialog_box ("fileBox", ".", "*");

		/*
		 *	Add an entry callback to the file dialog box's entry field.  Note that we do all of this here
		 *	before we associate the file dialog box to avoid warning message the user would normally get
		 *	when a translation didn't have an action.
		 */
		efp = file_db->entry_field ();
		efp->push_actions(actions, OI_count (actions));

		/*
		 *	display app window.  Put the file dialog box in the app window first, however.
		 */
		file_db->layout_associated_object (awp, 1, 1, OI_ACTIVE);
		awp->set_associated_object (awp -> root (), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE);
		OI_begin_interaction ();
	}

	/*
	 * Cleanup.  Make sure that we cleanup the library.
	 */
	OI_fini ();
}
