/**********************************************************************
 *
 *	This client demostrates how to use the drag and drop interface
 *	to drag a live object around on the screen.
 *
 **********************************************************************
 */

#include <stdio.h>
#include <stdlib.h>
#include <sysent.h>
#include <OI/oi.H>

// translations we'll put on objects to get things started
static char *dragTrans = "#override \n\
	<Btn1Down>:	drag_start()\n";

/**********************************************************************
 *
 *	drag_preview
 *
 *		Move the "DRAG ME" object around the screen
 *
 **********************************************************************
 */
void
drag_preview(
	OI_d_tech	*dtp,		// the object being dragged
	void		*,		// argp
	OI_dnd_operation op,		// the operation being previewed
	long		x,		// the X root coordinate of the pointer
	long		y)		// the Y root coordinate of the pointer
{
	static OI_d_tech	*orig_parent;
	static OI_number	orig_x;
	static OI_number	orig_y;
	OI_d_tech		*under_pointer;
	XEvent			fake;
	int			locx, locy;
	Window			child;

	switch (op) {
		case OI_dnd_start:
			orig_parent = dtp->parent();
			orig_x = (OI_number)dtp->loc_x();
			orig_y = (OI_number)dtp->loc_y();
			dtp->allow_override_redirect();
			dtp->set_associated_object(dtp->root(), x, y, OI_ACTIVE);
			break;
		case OI_dnd_done:
			// the drag operation is finished
			// move it someplace off screen so find_obj doesn't return the drag object
			dtp->set_loc(-100, -100);
			fake.xbutton.type = ButtonRelease;
			fake.xbutton.window = dtp->root()->X_window();
			fake.xbutton.subwindow = dtp->root()->X_window();
			fake.xbutton.root = dtp->root()->X_window();
			fake.xbutton.x = (int)x;
			fake.xbutton.y = (int)y;
			fake.xbutton.x_root = (int)x;
			fake.xbutton.y_root = (int)y;
			if ((under_pointer = dtp->connection()->find_obj(&fake))) {
				XTranslateCoordinates(dtp->display(), dtp->root()->X_window(),
					under_pointer->X_window(), (int)x, (int)y, &locx, &locy, &child);
				dtp->set_associated_object(under_pointer, locx, locy, OI_ACTIVE);
			}
			else {
				// move it back to where it started
				dtp->set_associated_object(orig_parent, orig_x, orig_y, OI_ACTIVE);
			}
			break;
		case OI_dnd_motion:
			// the pointer moved during the drag
			dtp->set_loc(x, y);
			break;
	}
}

main (int argc, char **argv)
{
	OI_connection	*conp;
	OI_app_window	*app;
	OI_static_text	*st;

	if ((conp = OI_init(&argc, argv, "Sender", "Sender")) == NULL) {
		fprintf(stderr, "%s: OI_init failed\n", argv[0]);
		exit(1);
	}

	// create the enclosing app_window
	app = oi_create_app_window("app1", 300, 300, "Sender");

	// create the "DRAG ME" static text object
	st = oi_create_static_text("st", "DRAG ME");

	// disallow_cut_paste so it doesn't grab our mouse button press
	st->disallow_cut_paste();

	// make the object draggable
	st->allow_drag();

	// put some drag translations on the object
	st->override_translations(dragTrans);

	// setup the drag preview callback
	st->set_drag_preview(drag_preview);

	// associate the object to the app_window
	st->set_associated_object(app, 20, 20, OI_ACTIVE);

	// put the app_window on the display
	app->set_associated_object(conp->root(), 50, 50, OI_ACTIVE);

	app = oi_create_app_window("app2", 300, 300, "Sender 2");
	app->set_associated_object(conp->root(), 400, 50, OI_ACTIVE);

	OI_begin_interaction();
	OI_fini();
}
