/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1991, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	wdtech.H
 *
 *	Description:
 *		OI_w_d_tech class header
 *		OI_w_d_tech is the base class for all displayable OI objects
 *		which have their own private X window.
 *
 *	RCSid = "$Id: wdtech.H,v 4.12.1.1 1993/06/01 22:57:17 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_wdtech_H
#define OI_wdtech_H

#ifndef OI_d_tech_H
#include <OI/d_tech.H>
#endif /* OI_d_tech_H */

#define	OI_w_d_tech_working		0x1			/* 1 => set_working is active */
#define	OI_w_d_tech_freeze		0x2			/* 1 => freeze is active */
#define	OI_w_d_tech_wm_protocols	0x4			/* 1 => wm_protocols event has been added */
#define	OI_w_d_tech_state_chg		0x8			/* 1 => state being changed */

	class	OI_w_d_tech : public OI_d_tech	{		/* display technique with private X window */
			unsigned long	ctl_bits ;		/* control bits */
			OI_xy		wm_prnt_off ;		/* offset in location due to wm decoration */
			OI_xy		wm_prnt_siz_adj ;	/* increase in size due to wm decoration */
	 protected:
			Window		X_window_id ;		/* X windows window id for object, NULL if none */
	 public:
		static	OI_class	*clsp ;							/* ptr to class record for this piece of object */

	 private:
			void		allow_freeze() ;
			void		allow_wm_protocols()		{ ctl_bits |= OI_w_d_tech_wm_protocols; }
			void		allow_working() ;
		virtual	void		clear_root_configure();					/* clear root configuration callback */
			void		disallow_freeze() ;
			void		disallow_working() ;
			void		disallow_wm_protocols()		{ ctl_bits &= ~OI_w_d_tech_wm_protocols; }
			void		freeze_destroy(const XEvent*, void*) ;
			OI_bool		is_wm_protocols()		{ return ((ctl_bits&OI_w_d_tech_wm_protocols)?OI_YES:OI_NO); }
		virtual	void		set_root_configure();					/* set root configuration callback */
	 protected:
					OI_w_d_tech(OI_class*, const char*) ;
					~OI_w_d_tech() ;
			OI_bool		is_state_chg()			{ return ((ctl_bits&OI_w_d_tech_state_chg)?OI_yes:OI_no); }
		virtual	void		new_connection(class OI_connection*) ;
		virtual	void		pre_configure(long, long, OI_number, OI_number) ;
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void		allow_focus_notify();
			void		allow_state_chg()		{ ctl_bits |= OI_w_d_tech_state_chg; }
 			void		and_wm_normal_hints(unsigned long);
 			void		and_wm_hints(unsigned long);
		virtual	OI_stat		create() ;
		virtual	void		destroy_x_window() ;
			void		disallow_state_chg()		{ ctl_bits &= ~OI_w_d_tech_state_chg; }
		virtual	void		do_clear_working();
		virtual	void		do_set_working(Cursor);
			void		generic_allow_wm_decoration(OI_wm_decoration, XrmQuark, XrmQuark, XrmQuark);
			void		generic_disallow_wm_decoration(OI_wm_decoration, XrmQuark, XrmQuark, XrmQuark);
		static	OI_bool		init(OI_connection*) ;
		virtual	OI_bool		is_frozen() ;
			OI_motif_wm_hints *motif_wm_hints(XrmQuark);
			OI_ol_win_attr	*ol_win_attr();
		virtual	void		or_wm_hints(XWMHints *);
		virtual	void		or_wm_normal_hints(XSizeHints *);			/* or wm_normal_hints on the window */
 		virtual	void		or_wm_normal_hints(unsigned long);
		virtual	void		private_allow_wm_decoration(OI_wm_decoration);
		virtual	void		private_disallow_wm_decoration(OI_wm_decoration);
			void		save_wm_props(XrmQuark, Atom*, XrmQuark, Atom*, XrmQuark, OI_motif_wm_hints*);
		virtual	void		set_model_info() ;					/* set properties related to model */
		virtual	void		set_wm_class(const char* = NULL, const char* = NULL);	/* set WM_CLASS */
		virtual	void		set_wm_hints(XWMHints *);
		virtual	void		set_wm_normal_hints(XSizeHints *);			/* set wm_normal_hints on the window */
			void		set_wm_protocols(Atom = 0);				/* set WM_PROTOCOLS */
			void		update_wm_props();
		virtual	Window		x_window_id() ;
		virtual	void		xlower() ;
		virtual	void		xmap() ;
		virtual	void		xmapraised() ;
		virtual	void		xraise() ;
		virtual	void		xunmap() ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void		allow_transient(Window);
		virtual	void		allow_wm_decoration(OI_wm_decoration);
		virtual	void		attach_X_window(Window) ;
		virtual	void		clear_working();
		virtual	void		configure(const XEvent*,void* =NULL) ;
		virtual	void		configure_descendant() ;
		virtual	OI_number	decoration_offset_x() ;
		virtual	OI_number	decoration_offset_y() ;
		virtual	OI_number	decoration_size_x() ;
		virtual	OI_number	decoration_size_y() ;
		virtual	void		disallow_transient();
		virtual	void		disallow_wm_decoration(OI_wm_decoration);
		virtual	void		freeze() ;
		virtual	OI_bool		has_private_window() ;
		virtual	OI_bool		is_working();
		virtual	void		repaint(OI_bool=OI_YES) ;
		virtual	OI_stat		set_state(OI_state) ;
		virtual	void		set_working();
		virtual void		set_working(Cursor) ;					/* make the object busy */
		virtual void		set_working(int) ;					/* make the object busy */
		virtual void		set_working(const char *, const char *) ;		/* make the object busy */
		virtual void		set_working(Pixmap, Pixmap, unsigned int, unsigned int);/* make the object busy */
		virtual	OI_number	space_x() ;
		virtual	OI_number	space_y() ;
		virtual	void		unfreeze() ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		


//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

#endif /* OI_wdtech_H */
