/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	pymnu.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_poly_menu class header
 *
 *	RCSid = "$Id: pymnu.H,v 4.6.1.1 1993/06/01 22:56:18 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_pymnu_H
#define OI_pymnu_H

#ifndef OI_basmnu_H
#include <OI/basmnu.H>
#endif /* OI_basmnu_H */

	// class forward reference declaration
	class OI_mdl_poly_menu;
	class OI_poly_check_menu;
	class OI_poly_rect_menu;

	class OI_poly_menu : public OI_basic_menu {
			OI_mdl_poly_menu	*mdl_dep ;
	 protected:
			OI_number		first_sel ;				/* number of first selected cell, 0-n, -1 => none */
			OI_number		n_sel ;					/* number of selected cells */
	 public:
		static	OI_class		*clsp ;					/* ptr to class record */
	 private:
			void			construct() ;
	 protected:
						OI_poly_menu(OI_class*, const char*, OI_orient=OI_VERTICAL, const char* =NULL) ;
						~OI_poly_menu() ;
			void			init_selections() ;			/* initialize preselected cells */
		virtual	void			new_model(OI_model_type) ;
         public:
	 /* public functions reserved for toolkit use */
		virtual	OI_menu_cell		*abbr_cell() ;
		virtual	void			cell_pre_unparent(OI_menu_cell*) ;
		virtual	OI_menu_cell		*cell_to_fire(OI_menu_cell*,OI_bool=OI_NO) ;
		virtual	void			clear_selected_cell(OI_menu_cell *);
		static	OI_bool			init(class OI_connection*) ;
		static	OI_poly_menu		*make_minimal(const char*,OI_minimal_type) ;
		virtual	OI_number		num_abbr_cell() ;
		virtual	OI_stat			num_set_abbr_cell(OI_number) ;
		virtual	OI_stat			set_abbr_cell(const char *) ;
		virtual	void			set_selected_cell(OI_menu_cell *);
		virtual	void			touch(OI_menu_cell*, OI_bool=OI_YES);
			void			touch_on(OI_menu_cell*, OI_bool=OI_YES) ;	/* touch a cell to turn on */
			void			touch_off(OI_menu_cell*, OI_bool=OI_YES) ;	/* touch a cell to turn off */
			void			fire_cell(OI_menu_cell *);
	 /* normal public functions */
		virtual	void			add_cell(OI_menu_cell*, OI_number, OI_bool=OI_YES) ;
		virtual	char			*alpha_value() ;
		virtual	OI_menu_cell		*next_selection(OI_menu_cell *) ;
		virtual	OI_menu_cell		**multi_selected(OI_number* =NULL) ;	/* get ptr to list of selected cells */
		virtual	OI_number		*num_multi_selected(OI_number*) ;	/* get ptr to list of numbers of selected cells */
		virtual	OI_menu_cell		*default_cell() ;
		virtual	OI_number		num_default_cell() ;
		virtual	OI_menu_cell		**multi_default_cell() ;
		virtual	OI_number		*num_multi_default_cell(OI_number*) ;
		virtual	OI_bool			is_unsel() ;
		virtual	void			allow_unsel() ;
		virtual	void			disallow_unsel() ;
		virtual	OI_bool			is_resel() ;
		virtual	void			allow_resel() ;
		virtual	void			disallow_resel() ;
		virtual	OI_stat			select_cell(OI_bool on_off, OI_menu_cell *cp, OI_bool=OI_NO, OI_bool=OI_YES) ;
		virtual	OI_stat			set_default_cell(const char*) ;
		virtual	OI_stat			num_set_default_cell(OI_number) ;
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	OBSOLETED FUNCTIONS	
//		Functions below this point were once documented in the programmer's manual under
//		this object, but are now obsolete and will be removed in a future release.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_poly_rect_menu	*oi_poly_rect_menu(const char *np, OI_number n, OI_menu_cell **cpp, OI_orient or=OI_VERTICAL,
					const char *ttl=NULL) ;
	OI_poly_check_menu	*oi_poly_check_menu(const char*, OI_number, OI_menu_cell**, OI_orient=OI_VERTICAL,const char* =NULL) ;
	OI_poly_menu		*oi_poly_menu(const char *np, OI_number nc, OI_menu_cell **cpp, OI_orient o=OI_VERTICAL,
					const char *t=NULL) ;

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_poly_rect_menu	*oi_create_poly_rect_menu(const char*, OI_number,OI_cell_spec*,OI_orient=OI_VERTICAL,const char* =NULL) ;
	OI_poly_rect_menu	*oi_create_poly_rect_menu(const char*, OI_number,OI_menu_cell**,OI_orient=OI_VERTICAL,const char* =NULL) ;

	OI_poly_check_menu	*oi_create_poly_check_menu(const char*, OI_number,OI_cell_spec*,OI_orient=OI_VERTICAL,const char* =NULL) ;
	OI_poly_check_menu	*oi_create_poly_check_menu(const char*, OI_number,OI_menu_cell**,OI_orient=OI_VERTICAL,const char* =NULL) ;

	OI_poly_menu		*oi_create_poly_menu(const char*, OI_number,OI_cell_spec*,OI_orient=OI_VERTICAL,const char* =NULL) ;
	OI_poly_menu		*oi_create_poly_menu(const char *np, OI_number nc, OI_menu_cell **cpp, OI_orient o=OI_VERTICAL,
						const char *t=NULL) ;

#endif /* OI_pymnu_H */
