/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1992, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	pngrip.H
 *
 *	Functions(s):
 *
 *	Description:
 *		Object Interface OI_pane_grip class header
 *
 *	RCSid = "$Id: pngrip.H,v 4.21.1.1 1993/06/01 22:56:10 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_pane_grip_H
#define OI_pane_grip_H

#ifndef OI_grip_H
#include <OI/grip.H>
#endif /* OI_grip_H */

#ifndef OI_sep_H
#include <OI/sep.H>
#endif /* OI_sep_H */

#ifndef OI_pane_H
#include <OI/pane.H>
#endif /* OI_pane_H */

	// class forward reference declarations
	class OI_pane_grip;

 /* private ctl_bits */
#define		OI_PANE_GRIP_IN_CONSTRUCTOR	0x01
#define		OI_PANE_GRIP_ALLOW_DRAG		0x02
#define		OI_PANE_GRIP_SHOW_SEP		0x04
//#define		OI_PANE_GRIP_NO_CHANGE		0x08

#define		OI_PANE_GRIP_DEF_FRAME_THICKNESS	-1
#define		OI_HANDLE_DEF_HEIGHT		6
#define		OI_HANDLE_DEF_WIDTH		6
#define		OI_HANDLE_DEF_INDENT		-10


	class OI_gr_line {
		private:
			long _p0x, _p0y, _p1x, _p1y;
		public:
			OI_gr_line(long x0, long y0, long x1, long y1)	{ _p0x = x0; _p0y = y0; _p1x = x1; _p1y = y1;}
			OI_gr_line()				{ _p0x = 0; _p0y = 0; _p1x = 0; _p1y = 0;}
			int	is_null()			{ if ( _p0x==0 && _p0y==0 && _p1x==0 && _p1y==0) return (1); else return (0); }
			double	length()			{ if ( _p0x == _p1x) return (OI_abs(_p1y - _p0y)); else return (OI_abs(_p1x - _p0x)); }
			void	p0(long *x, long *y)		{ *x = _p0x; *y = _p0y; }
			long	p0x()				{ return (_p0x) ; }
			long	p0y()				{ return (_p0y) ; }
			void	p1(long *x, long *y)		{ *x = _p1x; *y = _p1y; }
			long	p1x()				{ return (_p1x) ; }
			long	p1y()				{ return (_p1y) ; }
			void	set( long p0x, long p0y, long p1x, long p1y) 	{ _p0x = p0x; _p0y = p0y; _p1x = p1x; _p1y = p1y;}
			void	setp0( long x, long y) 		{ _p0x = x; _p0y = y; }
			void	setp0x( long x) 		{ _p0x = x; }
			void	setp0y( long y) 		{ _p0y = y; }
			void	setp1( long x, long y) 		{ _p1x = x; _p1y = y; }
			void	setp1x( long x) 		{ _p1x = x; }
			void	setp1y( long y) 		{ _p1y = y; }
			void	setx( long x) 			{ _p0x = x; _p1x = x; }
			void	sety( long y) 			{ _p0y = y; _p1y = y; }
	} ;


	class OI_pane_grip : public OI_grip {

	 friend class OI_pane;
	 friend class OI_paned_box;

	 private: // variables
			unsigned long	ctl_bits ;		/* object specific control bits */
			PIXEL		handle_bg;		/* handle's original background color */
			OI_gr_line	*ln_major;		/* major line to show new location of grip */
			OI_gr_line	*ln_minor;		/* minor line to show new location of grip */
			OI_pane		*_pane;			/* the pane for this grip (pane above or to the left) */
			OI_separator	*sp_major;		/* left/top separator */
			OI_separator	*sp_minor;		/* right/bottom separator */
			/**********************************************************************
			*  pane_grip resources
			**********************************************************************/
			OI_number	_indent ;		/* amount handle is indented from the edge */
			/**********************************************************************
			*  end of pane_grip resources
			**********************************************************************/

	 protected: // variables
	 public: // variables
		static	OI_class	*clsp ;								/* ptr to class record */

	 private: // functions
			void		allow_drag()					{ ctl_bits |= OI_PANE_GRIP_ALLOW_DRAG; }
			void		clear_in_my_constructor()			{ctl_bits&= ~OI_PANE_GRIP_IN_CONSTRUCTOR;}
			//void		clear_no_change_flag()				{ctl_bits&= ~OI_PANE_GRIP_NO_CHANGE;}
			void		construct(OI_number indent, OI_bool show_sep) ;
			void		disallow_drag()					{ ctl_bits &= ~OI_PANE_GRIP_ALLOW_DRAG; }
			OI_bool		in_my_constructor()				{return((ctl_bits&OI_PANE_GRIP_IN_CONSTRUCTOR) ? OI_YES : OI_NO);}
			OI_bool		is_drag()					{ return ((ctl_bits & OI_PANE_GRIP_ALLOW_DRAG) ? OI_YES : OI_NO); }
			void		null_sep_pointer(OI_d_tech*, void*);
			void		set_in_my_constructor()				{ctl_bits|=OI_PANE_GRIP_IN_CONSTRUCTOR;}
			//void		set_no_change_flag()				{ctl_bits|=OI_PANE_GRIP_NO_CHANGE;}
			void		set_last_size_of_panes_to_orig(OI_paned_box*);
			void		set_new_size_of_panes_to_orig(OI_paned_box*);
			void		set_orig_size_of_panes(OI_paned_box*);
			void		set_pane(OI_pane *pn)				{ _pane = pn;}
	 protected: // functions
					OI_pane_grip(OI_class *clsp, const char *usr_namp, OI_number width=OI_HANDLE_DEF_WIDTH, OI_number height=OI_HANDLE_DEF_HEIGHT, OI_number indent=OI_HANDLE_DEF_INDENT, OI_bool show_sep=OI_PANE_GRIP_DEF_SHOW_SEP);
	 public: // functions
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					OI_pane_grip(const char *usr_namp, OI_number width=OI_HANDLE_DEF_WIDTH, OI_number height=OI_HANDLE_DEF_HEIGHT, OI_number indent=OI_HANDLE_DEF_INDENT, OI_bool show_sep=OI_PANE_GRIP_DEF_SHOW_SEP) ;	/* constructor */
					~OI_pane_grip() ;
			void		clone_adjust(OI_d_tech*);
			void		create_lines();
			void		delete_lines();
		virtual	void		disable();
		virtual	void		enable();
		static	OI_bool		init(class OI_connection*) ;
		virtual	OI_bool		is_write_resq(XrmQuark);
			OI_gr_line	*line_major()				{ return (ln_major); }
			OI_gr_line	*line_minor()				{ return (ln_minor); }
			void		new_handle_indent(OI_number val);
			void		res_handle_indent(void*);
			void		res_show_sep(void*);
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void		focus_in(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void		focus_out(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void		drag(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		move(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		press(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		release(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		set_no_change(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void		allow_show_sep();
			void		disallow_show_sep();
			OI_number	handle_indent()		{ return (_indent);}
			OI_bool		is_show_sep()		{ return ((ctl_bits & OI_PANE_GRIP_SHOW_SEP) ? OI_YES : OI_NO); }
			OI_pane		*pane()			{ return (_pane); }
			OI_separator	*sep_major()		{ return (sp_major);}
			OI_separator	*sep_minor()		{ return (sp_minor);}
			void		set_handle_indent(OI_number val);
	} ;

 /* procedure declarations, used by everyone */
	OI_pane_grip	*oi_create_pane_grip(const char* usr_namep, OI_number width, OI_number height, OI_number indent, OI_bool show_sep) ;	/* create simple grip object */

#endif /* OI_pane_grip_H */
