/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	mnubox.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_menu_box class header
 *
 *	RCSid = "$Id: mnubox.H,v 1.9.1.1 1993/06/01 22:55:36 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_mnubox_H
#define OI_mnubox_H

#ifndef OI_mnu_H
#include <OI/mnu.H>
#endif /* OI_mnu_H */


 /* ctl_bits private bits */
#define		OI_MENU_BOX_IN_CONSTRUCTOR	0x1	/* 1 => in constructor for this object, not ancestor classes */

	class OI_menu_box : public OI_menu {	/* scrollable menu in a box */
			unsigned long		ctl_bits ;		/* object specific control bits */
	 public:
		static	OI_class		*clsp ;			/* ptr to class record */
	 private:
			void			clear_in_my_constructor()	{ctl_bits&= ~OI_MENU_BOX_IN_CONSTRUCTOR;}
			void			construct(const char *ttl);
			OI_bool			in_my_constructor()	{return((ctl_bits&OI_MENU_BOX_IN_CONSTRUCTOR) ? OI_YES : OI_NO);}
			void			set_in_my_constructor()	{ ctl_bits |= OI_MENU_BOX_IN_CONSTRUCTOR;}
	 protected:
						OI_menu_box(OI_class *clsp, const char *usr_namp, const char *ttl);
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_menu_box(const char*, const char*);
						~OI_menu_box() ;

  		virtual	void			activate(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
  		virtual	void			deactivate(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
			OI_d_tech		*interior()			{ return (*propp); }
		virtual	OI_bool			is_write_resq(XrmQuark);
		static	OI_menu_box		*make_minimal(const char*, OI_minimal_type) ;
		virtual	void			new_layout(OI_layout, OI_number= -1, OI_number= -1) ;
		virtual	void			new_title(const char *title, OI_char_encode_type);
		virtual	OI_d_tech		*val_assoc(OI_d_tech*) ;

		virtual	OI_d_tech		*descendant(const char *strp) ;
		virtual	OI_layout		layout();
		virtual	OI_d_tech		*next_child(OI_d_tech*);
		virtual	OI_number		num_props();
		virtual	OI_d_tech		*numbered_child(OI_number n) ;
		virtual	void			paint(const XEvent*, void* =NULL) ;
		virtual	OI_menu			*pin(OI_bool = OI_YES);					/* pin up menu */
		virtual	void			popup();
		virtual	void			resume_layout(OI_bool=OI_YES);
		virtual	void			stick();
		virtual	void			suspend_layout();
		virtual	OI_d_tech		*subobject(const char *strp) ;
		virtual	OI_d_tech		*subobject(XrmQuark) ;
		virtual	void			unpin(OI_d_tech* =NULL, const XEvent* =NULL, const char* const * =NULL, unsigned int* =NULL) ;	/* unpin menu */
		virtual	void			unpopup();
		virtual	OI_bool			user_layout_ok();

		//-------------------------------------------------------------------------------------------------		
		//	PURE VIRTUAL OVERRIDES
		//-------------------------------------------------------------------------------------------------		
                virtual OI_menu_cell		*abbr_cell() ;
                virtual void			allow_resel() ;
                virtual void			allow_unsel() ;
                virtual void			cell_paint(OI_menu_cell*) ;
                virtual OI_menu_cell		*cell_to_fire(OI_menu_cell*,OI_bool=OI_NO) ;
                virtual void			disallow_resel() ;
                virtual void			disallow_unsel() ;
		virtual void			fire_cell(OI_menu_cell *);
		virtual	OI_bool			has_submenu();
                virtual OI_number		inter_cell_x() ;
                virtual OI_number		inter_cell_y() ;
                virtual OI_bool			is_resel() ;
                virtual OI_bool			is_unsel() ;
                virtual OI_menu_cell		**multi_default_cell() ;
                virtual OI_number		num_abbr_cell() ;
                virtual OI_number		*num_multi_default_cell(OI_number*) ;
                virtual OI_stat			num_set_abbr_cell(OI_number) ;
                virtual OI_stat			select_cell(OI_bool,OI_menu_cell*, OI_bool=OI_NO, OI_bool=OI_YES) ;
                virtual OI_stat			set_abbr_cell(const char*) ;
                virtual void			add_cell(OI_menu_cell*, OI_number, OI_bool=OI_YES) ;
                virtual OI_number		cell_number(const char *) ;
                virtual OI_menu_cell		*default_cell() ;
                virtual OI_menu_cell		**multi_selected(OI_number* =NULL) ;
                virtual OI_menu_cell		*next_selection(OI_menu_cell*) ;
                virtual OI_number		num_cells() ;
                virtual OI_number		num_default_cell() ;
                virtual OI_number		*num_multi_selected(OI_number*) ;
                virtual OI_stat			num_select(OI_bool, OI_number, OI_bool=OI_YES) ;
                virtual OI_number		num_selected() ;
                virtual OI_stat			num_set_default_cell(OI_number) ;
                virtual OI_menu_cell		*numbered_cell(OI_number) ;
                virtual OI_stat			select(OI_bool, const char*, OI_bool=OI_YES) ;
                virtual OI_menu_cell		*selected() ;
                virtual OI_stat			set_default_cell(const char*) ;
		virtual OI_menu_cell		*start_current_cell();

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_bool		is_acceptable_child(OI_d_tech*) ;		/* chk if object is suitable as child */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	OBSOLETED FUNCTIONS	
//		Functions below this point were once documented in the programmer's manual under
//		this object, but are now obsolete and will be removed in a future release.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_menu_box	*oi_create_menu_box(const char*, const char * = NULL);

#endif /* OI_mnubox_H */
