/* dconn is the Decnet Connect program. The intention is that
** it will open a decnet socket (stream) and transfer stdin to that
** while everything from the connection goes to that.
**
** sendmail can then use that with an entry like
**
** MDsmtp, P=/usr/lib/mail/dconn, F=msDFMueXLR, S=13, R=24, E=\r\n,
**	A=dconn #130 $h
**
** because there is no $u in the arguments, sendmail will talk smtp to it.
*/
#include <stdio.h>
#include <signal.h>

#include <sys/syslog.h>
#include <netdnet/dn.h>
#include <sys/types.h>
#include <sys/socket.h>

#define DEBUG 1

extern int	errno;
int		me;

bye (str, i)
	int		i;
	char	       *str;
{
	if (DEBUG || i != 0)
		printf ("%d: why %s, exit %d, errno=%d\r\n",
			me, str, i, errno);
	exit (i);
}

main (argc, argv)
	int		argc;
	char	       *argv[];

{
	register int	dcr, i, j;
	char	       *pnt;
	static char	fromdn[512], todn[512];
	char	       *index ();

	if (argc != 3)
		bye ("not enuf args", 5);

	if ((pnt = index (argv[2], '.')) != (char *) NULL)
		*pnt = '\0';
	dcr = dnet_conn (argv[2], argv[1], SOCK_STREAM, 0, 0, 0, 0);

	if (dcr == -1)
		bye ("dnet_conn failed", 1);

	switch (me = fork ()) {
	    case 0:		/* kid */
		close (1);
		while ((i = read (0, todn, 512)) > 0) {
			if (i != write (dcr, todn, i))
				bye ("write failed", 2);
		}
		bye (i);
	    case -1:		/* Error */
		bye ("fork failed", 4);
	    default:		/* parent! */
		close (0);
		while ((j = read (dcr, fromdn, 512)) > 0) {
			if (j != write (1, fromdn, j))
				bye ("2nd write failed", 3);
		}
	}
}
