.TH HOST 1
.SH NAME
host \- look up host names using domain server
.SH SYNOPSIS 
host [-l] [-v] [-w] [-r] [-d] [-t querytype] [-a] [-s server ] host ...
.SH DESCRIPTION 
.I Host
looks for information about Internet hosts.  It gets this information
from a set of interconnected servers that are spread across the
country.  By default, it simply converts between host names and
Internet addresses.  However with the -t or -a options, it can be used
to find all of the information about this host that is maintained
by the domain server.
.PP
The arguments can be either host names or host numbers.  The program
first attempts to interpret them as host numbers.  If this fails,
it will treat them as host names.  A host number consists of
first decimal numbers separated by dots, e.g. 128.6.4.194
A host name
consists of names separated by dots, e.g. topaz.rutgers.edu.  
Unless the name ends in a dot, the local domain
is automatically tacked on the end.  Thus a Rutgers user can say
"host topaz", and it will actually look up "topaz.rutgers.edu".
If this fails, the name is tried unchanged (in this case, "topaz").
This same convention is used for mail and other network utilities.
The actual suffix to tack on the end is obtained
by looking at the results of a "hostname" call, and using everything
starting at the first dot.  (See below for a description of
how to customize the host name lookup.) 
.PP
The arguments are the host names you want to look up.
If any are host numbers, an "inverse query" is done, i.e. the domain
system looks in a separate set of databases used to convert numbers
to names.
.PP
If a name is specified, you may see output of three different kinds.
Here is an example that shows all of them:
.br
   % host sun4
.br
   sun4.rutgers.edu is a nickname for ATHOS.RUTGERS.EDU
.br
   ATHOS.RUTGERS.EDU has address 128.6.5.46
.br
   ATHOS.RUTGERS.EDU has address 128.6.4.4
.br
   ATHOS.RUTGERS.EDU mail is handled by ARAMIS.RUTGERS.EDU
.br
The user has typed the command "host sun4".  The first line indicates
that the name "sun4.rutgers.edu" is actually a nickname.  The official
host name is "ATHOS.RUTGERS.EDU'.  The next two lines show the
address.  If a system has more than one network interface, there
will be a separate address for each.  The last line indicates
that ATHOS.RUTGERS.EDU does not receive its own mail.  Mail for
it is taken by ARAMIS.RUTGERS.EDU.  There may be more than one
such line, since some systems have more than one other system
that will handle mail for them.  Technically, every system that
can receive mail is supposed to have an entry of this kind.  If
the system receives its own mail, there should be an entry
the mentions the system itself, for example
"XXX mail is handled by XXX".  However many systems that receive
their own mail do not bother to mention that fact.  If a system
has a "mail is handled by" entry, but no address, this indicates
that it is not really part of the Internet, but a system that is
on the network will forward mail to it.  Systems on Usenet, Bitnet,
and a number of other networks have entries of this kind.
.PP
There are a number of options that can be used before the
host name.  Most of these options are meaningful only to the
staff who have to maintain the domain database.
.PP
The option -w causes host to wait forever for a response.  Normally
it will time out after around a minute.
.PP
The option -v causes printout to be in a "verbose" format.  This
is the official domain master file format, which is documented 
in the man page for "named".  Without this option, output still follows
this format in general terms, but some attempt is made to make it
more intelligible to normal users.  Without -v,
"a", "mx", and "cname" records
are written out as "has address", "mail is handled by", and
"is a nickname for", and TTL and class fields are not shown.
.PP
The option -r causes recursion to be turned off in the request.
This means that the name server will return only data it has in
its own database.  It will not ask other servers for more 
information.
.PP
The option -d turns on debugging.  Network transactions are shown
in detail.
.PP
The option -t allows you to specify a particular type of information
to be looked up.  The arguments are defined in the man page for
"named".  Currently supported types are a, ns, md, mf, cname,
soa, mb, mg, mr, null, wks, ptr, hinfo, minfo, mx, uinfo,
uid, gid, unspec, and the wildcard, which may be written
as either "any" or "*".  Types must be given in lower case.
Note that the default is to look first for "a", and then "mx", except
that if the verbose option is turned on, the default is only "a".
.PP
The option -a (for "all") is equivalent to "-v -t any".
.PP
The option -l causes a listing of a complete domain.  E.g.
.br
   host -l rutgers.edu
.br
will give a listing of all hosts in the rutgers.edu domain.  The -t
option is used to filter what information is presented, as you 
would expect.  The default is address information, which also
include PTR and NS records.  The command
.br
   host -l -v -t any rutgers.edu
.br
will give a complete download of the zone data for rutgers.edu,
in the official master file format.  (However the SOA record is
listed twice, for arcane reasons.)  NOTE: -l is implemented by
doing a complete zone transfer and then filtering out the information
the you have asked for.  This command should be used only if it
is absolutely necessary.
.PP
The option -s allows you to specify a particular server to query.  If
you don't specify this argument, the default server (normally the
local machine) is used.
.PP
.SH CUSTOMIZING HOST NAME LOOKUP
In general, if the name supplied by the user does not
have any dots in it, a default domain is appended to the end.
This domain can be defined in /etc/resolv.conf, but is normally derived
by taking the local hostname after its first dot.  The user can override
this, and specify a different default domain, using the environment
variable
.IR LOCALDOMAIN .
In addition, the user can supply his own abbreviations for host names.
They should be in a file consisting of one line per abbreviation.
Each line contains an abbreviation, a space, and then the full
host name.  This file must be pointed to by an environment variable
.IR HOSTALIASES ,
which is the name of the file.
.SH "See Also"
named (8)
.SH BUGS
Unexpected effects can happen when you type a name that is not
part of the local domain.  Please always keep in mind the
fact that the local domain name is tacked onto the end of every
name, unless it ends in a dot.  Only if this fails is the name
used unchanged.
.PP
The -l option only tries the first name server listed for the
domain that you have requested.  If this server is dead, you
may need to specify a server manually. E.g. to get a listing
of foo.edu, you could try "host -t ns foo.edu" to get a list
of all the name servers for foo.edu, and then try "host -l foo.edu xxx"
for all xxx on the list of name servers, until you find one that
works.
