typedef struct {
	char **names;
	int (*f)();
	char *info;
	int flags;
} ss_request_entry;

typedef struct {
	int version;
	ss_request_entry *requests;
} ss_request_table;

static char *ssu00001[] = { "file", (char *)0 };
extern int set_file();
static char *ssu00002[] = { "cancel", (char *)0 };
extern int cancel_subs();
static char *ssu00003[] = { "load", "ld", (char *)0 };
extern int load_subs();
static char *ssu00004[] = { "unload", "unld", (char *)0 };
extern int load_subs();
static char *ssu00005[] = { "list", "ls", (char *)0 };
extern int load_subs();
static char *ssu00006[] = { "subscribe", "sub", (char *)0 };
extern int subscribe();
static char *ssu00007[] = { "unsubscribe", "unsub", (char *)0 };
extern int subscribe();
static char *ssu00008[] = { "add", (char *)0 };
extern int sub_file();
static char *ssu00009[] = { "add_unsubscription", "add_un", (char *)0 };
extern int sub_file();
static char *ssu00010[] = { "delete", "del", "dl", (char *)0 };
extern int sub_file();
static char *ssu00011[] = { "delete_unsubscription", "del_un", (char *)0 };
extern int sub_file();
static char *ssu00012[] = { "retrieve", "ret", (char *)0 };
extern int current();
static char *ssu00013[] = { "defaults", "defs", (char *)0 };
extern int current();
static char *ssu00014[] = { "save", (char *)0 };
extern int current();
static char *ssu00015[] = { "show", (char *)0 };
extern int show_var();
static char *ssu00016[] = { "set", (char *)0 };
extern int set_var();
static char *ssu00017[] = { "unset", (char *)0 };
extern int unset_var();
static char *ssu00018[] = { "wg_read", (char *)0 };
extern int wgc_control();
static char *ssu00019[] = { "wg_shutdown", (char *)0 };
extern int wgc_control();
static char *ssu00020[] = { "wg_startup", (char *)0 };
extern int wgc_control();
static char *ssu00021[] = { "hm_flush", (char *)0 };
extern int hm_control();
static char *ssu00022[] = { "new_server", (char *)0 };
extern int hm_control();
static char *ssu00023[] = { "flush_locs", (char *)0 };
extern int flush_locations();
static char *ssu00024[] = { "hide", (char *)0 };
extern int do_hide();
static char *ssu00025[] = { "unhide", (char *)0 };
extern int do_hide();
static char *ssu00026[] = { "list_requests", "lr", "?", (char *)0 };
extern int ss_list_requests();
static char *ssu00027[] = { "quit", "exit", "q", (char *)0 };
extern int ss_quit();
static ss_request_entry ssu00028[] = {
	{ ssu00001, set_file, "Set default subscriptions file.", 0 },
	{ ssu00002, cancel_subs, "Cancel all subscriptions.", 0 },
	{ ssu00003, load_subs, "Subscribe to a subscriptions file.", 0 },
	{ ssu00004, load_subs, "Unsubscribe to a subscriptions file.", 0 },
	{ ssu00005, load_subs, "List a subscriptions file.", 0 },
	{ ssu00006, subscribe, "Subscribe to a class/class instance.", 0 },
	{ ssu00007, subscribe, "Unsubscribe to a class/class instance.", 0 },
	{ ssu00008, sub_file, "Subscribe and add to subscriptions file.", 0 },
	{ ssu00009, sub_file, "Unsubscribe and add to subscriptions file\n                         as un-subscription.", 0 },
	{ ssu00010, sub_file, "Unsubscribe and delete subscription from\n                         subscriptions file.", 0 },
	{ ssu00011, sub_file, "Delete un-subscription from subscriptions file.", 0 },
	{ ssu00012, current, "Retrieve current subscriptions.", 0 },
	{ ssu00013, current, "Retrieve system-wide default subscriptions.", 0 },
	{ ssu00014, current, "Save current subscriptions (replacing existing file).", 0 },
	{ ssu00015, show_var, "Show a variable's value.", 0 },
	{ ssu00016, set_var, "Set a variable's value.", 0 },
	{ ssu00017, unset_var, "Delete a variable's value.", 0 },
	{ ssu00018, wgc_control, "Get the WindowGram to reread it's description file.", 0 },
	{ ssu00019, wgc_control, "Tell the WindowGram not to react to incoming notices.", 0 },
	{ ssu00020, wgc_control, "Tell the WindowGram to react to incoming notices.", 0 },
	{ ssu00021, hm_control, "Tell the server to flush information about this host.", 0 },
	{ ssu00022, hm_control, "Tell the HostManager to find a new server.", 0 },
	{ ssu00023, flush_locations, "Flush all location information.", 0 },
	{ ssu00024, do_hide, "Hide your location.", 0 },
	{ ssu00025, do_hide, "Show (un-hide) your location.", 0 },
	{ ssu00026, ss_list_requests, "List available commands.", 0 },
	{ ssu00027, ss_quit, "Quit.", 0 },
	{ (char **)0, (int(*)())0, (char *)0, 0 }
};

ss_request_table zctl_cmds = { 2, ssu00028 };
