/*-
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Chris Torek.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stddef.h>
#include <stdlib.h>

#define ATEXIT_SIZE   20

typedef void (*pfn) (void);

struct atexit
    {
    struct atexit *next;      /* Pointer to the next list        */
    int ind;                  /* Number of items in the list     */
    pfn fns [ATEXIT_SIZE];    /* List of functions for this list */
    };

static struct atexit *__atexit = NULL;  /* Pointer to the first list item */
static struct atexit __atexit0;         /* one guaranteed table */

/*
 * Register a function to be performed at exit.
 */

int atexit (pfn fn)
    {
    register struct atexit *p;
    int nAnswer = 0;

    p = __atexit;
    if (p == NULL)
        {
	__atexit =
	p        = &__atexit0;
        }
    else
        {
	if (p->ind >= ATEXIT_SIZE)
	    {
	    p = malloc (sizeof(*p));
	    if (p == NULL)
	        {
		nAnswer = -1;
	        }
	    else
	        {
		p->ind   = 0;
		p->next  = __atexit;
		__atexit = p;
	        }
	    }
        }

    if (p != NULL)
        {
        p->fns[p->ind++] = fn;
        }

    return (nAnswer);
    }

/*
 *  Cleanup processing for "atexit" routines.
 */

void atexit_cleanup (void)
    {
    register struct atexit *p;
    register int n;
    
    p = __atexit;
    while (p != NULL)
        {
	n = p->ind;
	while (--n >= 0)
	    {
	    (*p->fns[n]) ();
	    }
	p = p->next;
        }
    }



