#include <unistd.h>
#include <stdio.h>
#include "file2.h"
#include "internal.h"
#include <trace.h>

/*************************************************************************
 *
 * Function:   rewind
 *
 * Description:
 *   This routine will rewind the file to the starting point. In addition,
 *   the read/write mode is cleared and the access mode is undefined.
 *
 * Entry:
 *    stream    - pointer to the stream to be rewond
 *
 * Returns:
 *    The status of the seek operation. EOF will indicate an error.
 */

int rewind (FILE *stream)
    {
    int answer;
/*
 *  Flush the output stream and reset and pending error/eof condition
 */
    FUNC_ENTRY ("rewind");
    fflush (stream);
    _cerror (stream);
/*
 *  Reset the file mode to allow the next operation to be either a
 *  read or write operation.
 */
    if (stream->_flag & _IORW)
        {
	stream->_flag &= ~(_IOREAD | _IOWRT);
        }
/*
 *  Reset the file position to the start of the file.
 */
    answer = lseek (fileno (stream), 0L, SEEK_SET);
    FUNC_EXIT ("rewind");
    return (answer);
    }
