/************************************************************************
 *
 * File:    internal.h
 *
 * Description:
 *    This file lists the common data structures shared for the standard
 *    I/O package. It is ment to be used _only_ for the stdio package
 *    and should not be exported to any other subsystem or user.
 *
 *    It is assumed that <stdio.h> and "file2.h" have been included prior
 *    to this file. If not, you will get compile errors. Just fix the
 *    includes as I do not believe in making internal headers "idiot proof".
 */

extern FILE2 _iob2[];                /* Additional data about files not in   */
                                     /* the _iob[] structure.                */
extern int  _cflush;                 /* Number of buffers open to be flushed */
extern void (*_libc__cleanup)(void); /* Global pointer to cleanup vector     */
extern FILE * _lastiob;              /* Pointer to the _last_ file table     */

extern unsigned char _bufin  [];
extern unsigned char _bufout [];
extern unsigned char _buferr [];

extern unsigned long _tempoff;

/*
 *  Internal functions for the package.
 */

FILE *_getstream(void);
FILE *_openfile (const char *name, const char *mode, FILE *stream);
int _stbuf (FILE *stream);
void _ftbuf (int flag, FILE *stream);
int _doprnt (const char *pszFormat, va_list vaArg, FILE *fpStream);
void _cleanup(void);
void _freebuf (FILE *stream);
void _getbuf (FILE *stream);
int _xflsbuf (int ch, FILE *stream);
int _stbuf (FILE *stream);
void _ftbuf (int flag, FILE *stream);
int _input (FILE *stream, const char *pszFormat, va_list arglist);
