#ifndef	_CTYPE_H
#define _CTYPE_H

#define  _U      0001
#define  _L      0002
#define  _N      0004
#define  _S      0010
#define  _P      0020
#define  _C      0040
#define  _B      0100
#define  _X      0200


#ifdef ELF_LIBRARY
#define _ctype __ctype
#endif

extern unsigned char _ctype[];

#define __isalpha(c)      ((_ctype+1)[c]&(_U|_L))
#define __isupper(c)      ((_ctype+1)[c]&_U)
#define __islower(c)      ((_ctype+1)[c]&_L)
#define __isdigit(c)      ((_ctype+1)[c]&_N)
#define __isxdigit(c)     ((_ctype+1)[c]&_X)
#define __isalnum(c)      ((_ctype+1)[c]&(_U|_L|_N))
#define __isspace(c)      ((_ctype+1)[c]&_S)
#define __ispunct(c)      ((_ctype+1)[c]&_P)
#define __isprint(c)      ((_ctype+1)[c]&(_P|_U|_L|_N|_B))
#define __isgraph(c)      ((_ctype+1)[c]&(_P|_U|_L|_N))
#define __iscntrl(c)      ((_ctype+1)[c]&_C)
#define __isascii(c)      (!((c)&~0177))
#define ___toupper(c)     ((_ctype+258)[c])
#define ___tolower(c)     ((_ctype+258)[c])
#define __toascii(c)      ((c)&0177)
#define ___old_tolower(c) (islower(c)?(c):(c)|0400)
#define ___old_toupper(c) (isupper(c)?(c):(c)&(~0400))

#define isalpha(c)      __isalpha(c)
#define isupper(c)      __isupper(c)
#define islower(c)      __islower(c)
#define isdigit(c)      __isdigit(c)
#define isxdigit(c)     __isxdigit(c)
#define isalnum(c)      __isalnum(c)
#define isspace(c)      __isspace(c)
#define ispunct(c)      __ispunct(c)
#define isprint(c)      __isprint(c)
#define isgraph(c)      __isgraph(c)
#define iscntrl(c)      __iscntrl(c)
#define isascii(c)      __isascii(c)
#define _toupper(c)     ___toupper(c)
#define _tolower(c)     ___tolower(c)
#define _old_tolower(c) ___old_tolower(c)
#define _old_toupper(c) ___old_toupper(c)
#define toascii(c)      __toascii(c)

#endif
