// * This makes emacs happy -*-Mode: C++;-*-
#ifndef _CURSESP_H
#define _CURSESP_H

/*

    Written and
    Copyright (C) 1993 by Anatoly Ivasyuk

*/

#pragma interface

#include "cursesw.h"
extern "C" {
#include <panel.h>
}

class NCursesPanel : public NCursesWindow {
    protected:
	PANEL *p;

    public:
	NCursesPanel();		// make a full window size panel
	NCursesPanel(int lines, int cols, int begin_y, int begin_x);
	~NCursesPanel();

	// basic manipulation
	int hide() { return hide_panel(p); }
	int show() { return show_panel(p); }
	int top() { return top_panel(p); }
	int bottom() { return bottom_panel(p); }
	int mvpan(int y, int x) { return move_panel(p, y, x); }
	int mvwin(int y, int x) { return move_panel(p, y, x); }

	static void redraw();	// redraw all panels
	void refresh();

	// decorations
	int frame() { return box(); }
	int frame(char *title);
	int boldframe();
	int boldframe(char *title);
};

inline NCursesPanel::NCursesPanel()
	: NCursesWindow(0, 0, 0, 0)
{
    p = new_panel(w);
}

inline NCursesPanel::NCursesPanel(int lines, int cols,
				int begin_y, int begin_x)
	: NCursesWindow(lines, cols, begin_y, begin_x)
{
    p = new_panel(w);
}

inline NCursesPanel::~NCursesPanel()
{
    del_panel(p);
    update_panels();
    doupdate();
}

inline void NCursesPanel::refresh()
{
    update_panels();
    doupdate();
}

inline int NCursesPanel::boldframe()
{
    standout();
    box();
    return standend();
}

inline int NCursesPanel::boldframe(char *title)
{
    standout();
    box();
    mvwaddstr(w, 0,
		((p->wendx - p->wstartx + 1) - strlen(title)) / 2,
		title);
    return standend();
}

inline int NCursesPanel::frame(char *title)
{
    box();
    return mvwaddstr(w, 0,
		((p->wendx - p->wstartx + 1) - strlen(title)) / 2,
		title);
}


#endif // _CURSESP_H
