
FOREIGN MODULE msScan;

(*
 *  Scan Library for Modula-2*
 *
 *  allows for efficient scan operations on
 *  arbitrarily large and distributed arrays
 *
 *
 *  Modula-2* interface by Ernst A. Heinz
 *
 *  C/MPL implementation by Ernst A. Heinz
 *
 *  Last change: 16.10.1992
 *)

(*
 *  naming conventions:
 *  -------------------
 *
 *    <as>Scan<op><ts>( x: ARRAY ... OF <type>;
 *                      VAR y: ARRAY ... OF <type> );
 *
 *    <as> = "allocator shortcut",  <op> = "scan operator"
 *    <ts> = "type shortcut"
 *
 *  example:
 *  --------
 *
 *    SScanMaxI( x: ARRAY SPREAD OF LONGINT;
 *               VAR y: ARRAY SPREAD OF LONGINT );
 *
 *    <as> = S,  <op> = Max,  <ts> = I,  <type> = LONGINT
 *)

(*
 *  normal scan routines for 1-dimensional SPREAD arrays
 *
 *  necessary condition:  HIGH(x) = HIGH(y)
 *)

PROCEDURE SScanAddB ( x: ARRAY SPREAD OF BOOLEAN;
		      VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SScanAddCh( x: ARRAY SPREAD OF CHAR;
		      VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SScanAddSC( x: ARRAY SPREAD OF SHORTCARD;
		      VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SScanAddC ( x: ARRAY SPREAD OF LONGCARD;
		      VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SScanAddSI( x: ARRAY SPREAD OF SHORTINT;
		      VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SScanAddI ( x: ARRAY SPREAD OF LONGINT;
		      VAR y: ARRAY SPREAD OF LONGINT );
PROCEDURE SScanAddR ( x: ARRAY SPREAD OF REAL;
		      VAR y: ARRAY SPREAD OF REAL );
PROCEDURE SScanAddLR( x: ARRAY SPREAD OF LONGREAL;
		      VAR y: ARRAY SPREAD OF LONGREAL );

PROCEDURE SScanAndB ( x: ARRAY SPREAD OF BOOLEAN;
		      VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SScanAndCh( x: ARRAY SPREAD OF CHAR;
		      VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SScanAndSC( x: ARRAY SPREAD OF SHORTCARD;
		      VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SScanAndC ( x: ARRAY SPREAD OF LONGCARD;
		      VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SScanAndSI( x: ARRAY SPREAD OF SHORTINT;
		      VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SScanAndI ( x: ARRAY SPREAD OF LONGINT;
		      VAR y: ARRAY SPREAD OF LONGINT );

PROCEDURE SScanMaxB ( x: ARRAY SPREAD OF BOOLEAN;
		      VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SScanMaxCh( x: ARRAY SPREAD OF CHAR;
		      VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SScanMaxSC( x: ARRAY SPREAD OF SHORTCARD;
		      VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SScanMaxC ( x: ARRAY SPREAD OF LONGCARD;
		      VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SScanMaxSI( x: ARRAY SPREAD OF SHORTINT;
		      VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SScanMaxI ( x: ARRAY SPREAD OF LONGINT;
		      VAR y: ARRAY SPREAD OF LONGINT );
PROCEDURE SScanMaxR ( x: ARRAY SPREAD OF REAL;
		      VAR y: ARRAY SPREAD OF REAL );
PROCEDURE SScanMaxLR( x: ARRAY SPREAD OF LONGREAL;
		      VAR y: ARRAY SPREAD OF LONGREAL );

PROCEDURE SScanMinB ( x: ARRAY SPREAD OF BOOLEAN;
		      VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SScanMinCh( x: ARRAY SPREAD OF CHAR;
		      VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SScanMinSC( x: ARRAY SPREAD OF SHORTCARD;
		      VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SScanMinC ( x: ARRAY SPREAD OF LONGCARD;
		      VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SScanMinSI( x: ARRAY SPREAD OF SHORTINT;
		      VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SScanMinI ( x: ARRAY SPREAD OF LONGINT;
		      VAR y: ARRAY SPREAD OF LONGINT );
PROCEDURE SScanMinR ( x: ARRAY SPREAD OF REAL;
		      VAR y: ARRAY SPREAD OF REAL );
PROCEDURE SScanMinLR( x: ARRAY SPREAD OF LONGREAL;
		      VAR y: ARRAY SPREAD OF LONGREAL );

PROCEDURE SScanMulB ( x: ARRAY SPREAD OF BOOLEAN;
		      VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SScanMulCh( x: ARRAY SPREAD OF CHAR;
		      VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SScanMulSC( x: ARRAY SPREAD OF SHORTCARD;
		      VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SScanMulC ( x: ARRAY SPREAD OF LONGCARD;
		      VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SScanMulSI( x: ARRAY SPREAD OF SHORTINT;
		      VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SScanMulI ( x: ARRAY SPREAD OF LONGINT;
		      VAR y: ARRAY SPREAD OF LONGINT );
PROCEDURE SScanMulR ( x: ARRAY SPREAD OF REAL;
		      VAR y: ARRAY SPREAD OF REAL );
PROCEDURE SScanMulLR( x: ARRAY SPREAD OF LONGREAL;
		      VAR y: ARRAY SPREAD OF LONGREAL );

PROCEDURE SScanOrB  ( x: ARRAY SPREAD OF BOOLEAN;
		      VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SScanOrCh ( x: ARRAY SPREAD OF CHAR;
		      VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SScanOrSC ( x: ARRAY SPREAD OF SHORTCARD;
		      VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SScanOrC  ( x: ARRAY SPREAD OF LONGCARD;
		      VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SScanOrSI ( x: ARRAY SPREAD OF SHORTINT;
		      VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SScanOrI  ( x: ARRAY SPREAD OF LONGINT;
		      VAR y: ARRAY SPREAD OF LONGINT );

(*
 *  masked scan routines for 1-dimensional SPREAD arrays
 *
 *  necessary condition:  HIGH(mask) = HIGH(x) = HIGH(y)
 *)

PROCEDURE SMaskScanAddB ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF BOOLEAN;
			  VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SMaskScanAddCh( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF CHAR;
			  VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SMaskScanAddSC( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTCARD;
			  VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SMaskScanAddC ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGCARD;
			  VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SMaskScanAddSI( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTINT;
			  VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SMaskScanAddI ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGINT;
			  VAR y: ARRAY SPREAD OF LONGINT );
PROCEDURE SMaskScanAddR ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF REAL;
			  VAR y: ARRAY SPREAD OF REAL );
PROCEDURE SMaskScanAddLR( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGREAL;
			  VAR y: ARRAY SPREAD OF LONGREAL );

PROCEDURE SMaskScanAndB ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF BOOLEAN;
			  VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SMaskScanAndCh( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF CHAR;
			  VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SMaskScanAndSC( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTCARD;
			  VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SMaskScanAndC ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGCARD;
			  VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SMaskScanAndSI( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTINT;
			  VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SMaskScanAndI ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGINT;
			  VAR y: ARRAY SPREAD OF LONGINT );

PROCEDURE SMaskScanMaxB ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF BOOLEAN;
			  VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SMaskScanMaxCh( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF CHAR;
			  VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SMaskScanMaxSC( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTCARD;
			  VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SMaskScanMaxC ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGCARD;
			  VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SMaskScanMaxSI( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTINT;
			  VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SMaskScanMaxI ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGINT;
			  VAR y: ARRAY SPREAD OF LONGINT );
PROCEDURE SMaskScanMaxR ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF REAL;
			  VAR y: ARRAY SPREAD OF REAL );
PROCEDURE SMaskScanMaxLR( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGREAL;
			  VAR y: ARRAY SPREAD OF LONGREAL );

PROCEDURE SMaskScanMinB ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF BOOLEAN;
			  VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SMaskScanMinCh( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF CHAR;
			  VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SMaskScanMinSC( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTCARD;
			  VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SMaskScanMinC ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGCARD;
			  VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SMaskScanMinSI( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTINT;
			  VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SMaskScanMinI ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGINT;
			  VAR y: ARRAY SPREAD OF LONGINT );
PROCEDURE SMaskScanMinR ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF REAL;
			  VAR y: ARRAY SPREAD OF REAL );
PROCEDURE SMaskScanMinLR( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGREAL;
			  VAR y: ARRAY SPREAD OF LONGREAL );

PROCEDURE SMaskScanMulB ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF BOOLEAN;
			  VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SMaskScanMulCh( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF CHAR;
			  VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SMaskScanMulSC( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTCARD;
			  VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SMaskScanMulC ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGCARD;
			  VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SMaskScanMulSI( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTINT;
			  VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SMaskScanMulI ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGINT;
			  VAR y: ARRAY SPREAD OF LONGINT );
PROCEDURE SMaskScanMulR ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF REAL;
			  VAR y: ARRAY SPREAD OF REAL );
PROCEDURE SMaskScanMulLR( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGREAL;
			  VAR y: ARRAY SPREAD OF LONGREAL );

PROCEDURE SMaskScanOrB  ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF BOOLEAN;
			  VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SMaskScanOrCh ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF CHAR;
			  VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SMaskScanOrSC ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTCARD;
			  VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SMaskScanOrC  ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGCARD;
			  VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SMaskScanOrSI ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTINT;
			  VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SMaskScanOrI  ( mask: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGINT;
			  VAR y: ARRAY SPREAD OF LONGINT );

(*
 *  segmented scan routines for 1-dimensional SPREAD arrays
 *
 *  necessary condition:  HIGH(segs) = HIGH(x) = HIGH(y)
 *)

PROCEDURE SSegScanAddB ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF BOOLEAN;
			 VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SSegScanAddCh( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF CHAR;
			 VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SSegScanAddSC( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF SHORTCARD;
			 VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SSegScanAddC ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF LONGCARD;
			 VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SSegScanAddSI( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF SHORTINT;
			 VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SSegScanAddI ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF LONGINT;
			 VAR y: ARRAY SPREAD OF LONGINT );
PROCEDURE SSegScanAddR ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF REAL;
			 VAR y: ARRAY SPREAD OF REAL );
PROCEDURE SSegScanAddLR( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF LONGREAL;
			 VAR y: ARRAY SPREAD OF LONGREAL );

PROCEDURE SSegScanAndB ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF BOOLEAN;
			 VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SSegScanAndCh( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF CHAR;
			 VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SSegScanAndSC( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF SHORTCARD;
			 VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SSegScanAndC ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF LONGCARD;
			 VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SSegScanAndSI( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF SHORTINT;
			 VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SSegScanAndI ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF LONGINT;
			 VAR y: ARRAY SPREAD OF LONGINT );

PROCEDURE SSegScanMaxB ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF BOOLEAN;
			 VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SSegScanMaxCh( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF CHAR;
			 VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SSegScanMaxSC( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF SHORTCARD;
			 VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SSegScanMaxC ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF LONGCARD;
			 VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SSegScanMaxSI( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF SHORTINT;
			 VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SSegScanMaxI ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF LONGINT;
			 VAR y: ARRAY SPREAD OF LONGINT );
PROCEDURE SSegScanMaxR ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF REAL;
			 VAR y: ARRAY SPREAD OF REAL );
PROCEDURE SSegScanMaxLR( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF LONGREAL;
			 VAR y: ARRAY SPREAD OF LONGREAL );

PROCEDURE SSegScanMinB ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF BOOLEAN;
			 VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SSegScanMinCh( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF CHAR;
			 VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SSegScanMinSC( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF SHORTCARD;
			 VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SSegScanMinC ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF LONGCARD;
			 VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SSegScanMinSI( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF SHORTINT;
			 VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SSegScanMinI ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF LONGINT;
			 VAR y: ARRAY SPREAD OF LONGINT );
PROCEDURE SSegScanMinR ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF REAL;
			 VAR y: ARRAY SPREAD OF REAL );
PROCEDURE SSegScanMinLR( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF LONGREAL;
			 VAR y: ARRAY SPREAD OF LONGREAL );

PROCEDURE SSegScanMulB ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF BOOLEAN;
			 VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SSegScanMulCh( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF CHAR;
			 VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SSegScanMulSC( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF SHORTCARD;
			 VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SSegScanMulC ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF LONGCARD;
			 VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SSegScanMulSI( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF SHORTINT;
			 VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SSegScanMulI ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF LONGINT;
			 VAR y: ARRAY SPREAD OF LONGINT );
PROCEDURE SSegScanMulR ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF REAL;
			 VAR y: ARRAY SPREAD OF REAL );
PROCEDURE SSegScanMulLR( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF LONGREAL;
			 VAR y: ARRAY SPREAD OF LONGREAL );

PROCEDURE SSegScanOrB  ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF BOOLEAN;
			 VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SSegScanOrCh ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF CHAR;
			 VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SSegScanOrSC ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF SHORTCARD;
			 VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SSegScanOrC  ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF LONGCARD;
			 VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SSegScanOrSI ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF SHORTINT;
			 VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SSegScanOrI  ( segs: ARRAY SPREAD OF BOOLEAN;
			 x: ARRAY SPREAD OF LONGINT;
			 VAR y: ARRAY SPREAD OF LONGINT );

(*
 *  universal scan routines for 1-dimensional SPREAD arrays
 *
 *  necessary condition:  HIGH(mask) = HIGH(segs) = HIGH(x) = HIGH(y)
 *)

PROCEDURE SUnivScanAddB ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF BOOLEAN;
			  VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SUnivScanAddCh( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF CHAR;
			  VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SUnivScanAddSC( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTCARD;
			  VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SUnivScanAddC ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGCARD;
			  VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SUnivScanAddSI( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTINT;
			  VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SUnivScanAddI ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGINT;
			  VAR y: ARRAY SPREAD OF LONGINT );
PROCEDURE SUnivScanAddR ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF REAL;
			  VAR y: ARRAY SPREAD OF REAL );
PROCEDURE SUnivScanAddLR( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGREAL;
			  VAR y: ARRAY SPREAD OF LONGREAL );

PROCEDURE SUnivScanAndB ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF BOOLEAN;
			  VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SUnivScanAndCh( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF CHAR;
			  VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SUnivScanAndSC( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTCARD;
			  VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SUnivScanAndC ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGCARD;
			  VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SUnivScanAndSI( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTINT;
			  VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SUnivScanAndI ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGINT;
			  VAR y: ARRAY SPREAD OF LONGINT );

PROCEDURE SUnivScanMaxB ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF BOOLEAN;
			  VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SUnivScanMaxCh( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF CHAR;
			  VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SUnivScanMaxSC( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTCARD;
			  VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SUnivScanMaxC ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGCARD;
			  VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SUnivScanMaxSI( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTINT;
			  VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SUnivScanMaxI ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGINT;
			  VAR y: ARRAY SPREAD OF LONGINT );
PROCEDURE SUnivScanMaxR ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF REAL;
			  VAR y: ARRAY SPREAD OF REAL );
PROCEDURE SUnivScanMaxLR( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGREAL;
			  VAR y: ARRAY SPREAD OF LONGREAL );

PROCEDURE SUnivScanMinB ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF BOOLEAN;
			  VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SUnivScanMinCh( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF CHAR;
			  VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SUnivScanMinSC( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTCARD;
			  VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SUnivScanMinC ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGCARD;
			  VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SUnivScanMinSI( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTINT;
			  VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SUnivScanMinI ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGINT;
			  VAR y: ARRAY SPREAD OF LONGINT );
PROCEDURE SUnivScanMinR ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF REAL;
			  VAR y: ARRAY SPREAD OF REAL );
PROCEDURE SUnivScanMinLR( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGREAL;
			  VAR y: ARRAY SPREAD OF LONGREAL );

PROCEDURE SUnivScanMulB ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF BOOLEAN;
			  VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SUnivScanMulCh( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF CHAR;
			  VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SUnivScanMulSC( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTCARD;
			  VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SUnivScanMulC ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGCARD;
			  VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SUnivScanMulSI( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTINT;
			  VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SUnivScanMulI ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGINT;
			  VAR y: ARRAY SPREAD OF LONGINT );
PROCEDURE SUnivScanMulR ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF REAL;
			  VAR y: ARRAY SPREAD OF REAL );
PROCEDURE SUnivScanMulLR( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGREAL;
			  VAR y: ARRAY SPREAD OF LONGREAL );

PROCEDURE SUnivScanOrB  ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF BOOLEAN;
			  VAR y: ARRAY SPREAD OF BOOLEAN );
PROCEDURE SUnivScanOrCh ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF CHAR;
			  VAR y: ARRAY SPREAD OF CHAR );
PROCEDURE SUnivScanOrSC ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTCARD;
			  VAR y: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SUnivScanOrC  ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGCARD;
			  VAR y: ARRAY SPREAD OF LONGCARD );
PROCEDURE SUnivScanOrSI ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF SHORTINT;
			  VAR y: ARRAY SPREAD OF SHORTINT );
PROCEDURE SUnivScanOrI  ( mask, segs: ARRAY SPREAD OF BOOLEAN;
			  x: ARRAY SPREAD OF LONGINT;
			  VAR y: ARRAY SPREAD OF LONGINT );

END msScan.
