#include "stdwdefi.h"
#include "stdwin.h"
#include "style.h"

static TEXTATTR wattr;

extern int      vdi_handle ;

static void
setattr ()
{
        int     effect = 0 ;

        if (wattr.style & BOLD)
                effect |= 0x01 ;
        if (wattr.style & ITALIC)
                effect |= 0x04 ;
        if (wattr.style & UNDERLINE)
                effect |= 0x08 ;
        if (wattr.style & HILITE)
                effect |= 0x01 ;
        if (wattr.style == PLAIN)
                effect = 0x00 ;

        vst_effects (vdi_handle, effect) ;
}

void
wsetplain()
{
        wattr.style = PLAIN ;
        setattr () ;
}

void
wsethilite()
{
        wattr.style |= HILITE ;
        setattr () ;
}

void
wsetinverse()
{
        wattr.style |= INVERSE ;
        setattr () ;
}

void
wsetitalic()
{
        wattr.style |= ITALIC ;
        setattr () ;
}

void
wsetbold()
{
        wattr.style |= BOLD ;
        setattr () ;
}

void
wsetbolditalic()
{
        wattr.style |= BOLD | ITALIC ;
        setattr () ;
}

void
wsetunderline()
{
        wattr.style |= UNDERLINE ;
        setattr () ;
}

void
wgettextattr(attr)
        TEXTATTR *attr ;
{
        *attr= wattr ;
}

void
wsettextattr(attr)
        TEXTATTR *attr ;
{
        wattr= *attr ;
        setattr () ;
}
