/* Interactive Printer Queue Viewer -- Common Definitions */

#include "stdwdefi.h"
#include "stdwin.h"

extern char *spool;             /* Spool dir, normally /usr/spool */
extern char *printer;           /* Printer name, e.g., psc */

extern char *lock;              /* Message from lock file */
extern char *status;            /* Message from status file */

struct qitem {
        char *name;             /* Name of control file */
        unsigned long mtime;    /* Creation time */
        unsigned long size;     /* Total size of data file */
        int uid;                /* Used id */
        short ndata;            /* Number of data files */
        tbool active;           /* Set if this is the active file */
};

extern int nfiles;              /* Number of queue items */
extern struct qitem *filelist;  /* Queue */

/* qexec.c */
extern bool do_delete _ARGS((int which));
extern bool do_topqueue _ARGS((int which));
extern bool do_restart _ARGS((void));
/* qinfo.c */
extern void gotospooldir _ARGS((void));
extern bool queuerefresh _ARGS((void));
extern bool readqueue _ARGS((void));
extern void countdata _ARGS((char *name, struct qitem *ip));
extern char *username _ARGS((int uid));        /* Return user name from uid */
/* qview.c */
extern nonreturning void panic _ARGS((char *message));

