/*
 * @(#)resource.c	1.5 91/09/05
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#ifdef linux
#include <linux/kernel.h>
#endif
#ifndef linux
#include <ufs/quota.h>
#endif

#include "defs.h"

static Xlat resources[] = {
	RLIMIT_CPU,	"CPU",
	RLIMIT_FSIZE,	"FSIZE",
	RLIMIT_DATA,	"DATA",
	RLIMIT_STACK,	"STACK",
	RLIMIT_CORE,	"CORE",
	RLIMIT_RSS,	"RSS",
#ifndef linux
	RLIMIT_NOFILE,	"NOFILE",
#endif
	0,		NULL,
};

int
sys_getrlimit(tcp)
struct tcb *tcp;
{
	struct rlimit rlim;

	if (entering(tcp)) {
		printxval(resources, tcp->u_args[0], "RLIMIT_???");
	} else {
		if (syserror(tcp) || umove(tcp->pid, tcp->u_args[1],
					sizeof rlim, (char *)&rlim) < 0) {
			fprintf(outf, ", %#x", tcp->u_args[1]);
		} else {
			fprintf(outf, ", {cur: %u, max: %u}",
					rlim.rlim_cur, rlim.rlim_max);
		}
	}
	return 0;
}

int
sys_setrlimit(tcp)
struct tcb *tcp;
{
	struct rlimit rlim;

	if (entering(tcp)) {
		printxval(resources, tcp->u_args[0], "RLIMIT_???");
		if (umove(tcp->pid, tcp->u_args[1],
					sizeof rlim, (char *)&rlim) < 0)
			fprintf(outf, ", %#x", tcp->u_args[1]);
		else
			fprintf(outf, ", {cur: %u, max: %u}",
					rlim.rlim_cur, rlim.rlim_max);
	}
	return 0;
}

static Xlat usagewho[] = {
	RUSAGE_SELF,		"RUSAGE_SELF",
	RUSAGE_CHILDREN,	"RUSAGE_CHILDREN",
	0,			NULL,
};

int
sys_getrusage(tcp)
struct tcb *tcp;
{
	struct rusage ru;

	if (entering(tcp)) {
		printxval(usagewho, tcp->u_args[0], "RUSAGE_???");
	} else {
		if (syserror(tcp) || umove(tcp->pid, tcp->u_args[1],
					sizeof ru, (char *)&ru) < 0) {
			fprintf(outf, ", %#x", tcp->u_args[1]);
		} else {
			fprintf(outf, ", {utime {%u, %u} stime {%u, %u} ...}",
					ru.ru_utime.tv_sec,
					ru.ru_utime.tv_usec,
					ru.ru_stime.tv_sec,
					ru.ru_stime.tv_usec);
		}
	}
	return 0;
}

int
sys_sysinfo(tcp)
struct tcb *tcp;
{
	struct sysinfo si;

	if (exiting(tcp)) {
		umove(tcp->pid, tcp->u_args[0], sizeof si, (char *)&si);
		fprintf(outf, "{up:%lu, load:[%lu,%lu,%lu], mem:[%lu,%lu,%lu,%lu], \
swap:[%lu,%lu], proc:%hu}",
			si.uptime, si.loads[0], si.loads[1], si.loads[2],
			si.totalram, si.freeram, si.sharedram, si.bufferram,	
			si.totalswap, si.freeswap, si.procs);
	}
	return 0;
}


static Xlat priorities[] = {
	PRIO_PROCESS, 	"PRIO_PROCESS",
	PRIO_PGRP,	"PRIO_PGRP",
	PRIO_USER,	"PRIO_USER",
	0,		NULL,
};

int
sys_getpriority(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		printxval(priorities, tcp->u_args[0], "PRIO_???");
		fprintf(outf, ", %u", tcp->u_args[1]);
	}
	return 0;
}

int
sys_setpriority(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		printxval(priorities, tcp->u_args[0], "PRIO_???");
		fprintf(outf, ", %u, %d", tcp->u_args[1], tcp->u_args[2]);
	}
	return 0;
}

#ifndef linux
static Xlat quotacmds[] = {
	Q_QUOTAON,	"Q_QUOTAON",
	Q_QUOTAOFF,	"Q_QUOTAOFF",
	Q_GETQUOTA,	"Q_GETQUOTA",
	Q_SETQUOTA,	"Q_SETQUOTA",
	Q_SETQLIM,	"Q_SETQLIM",
	Q_SYNC,		"Q_SYNC",
	0,		NULL,
};

int
sys_quotactl(tcp)
struct tcb *tcp;
{
	/* fourth arg (addr) not interpreted here */
	if (entering(tcp)) {
		printxval(quotacmds, tcp->u_args[0], "Q_???");
		fprintf(outf, ", ");
		printstr(tcp->pid, tcp->u_args[1], -1);
		fprintf(outf, ", %u, %#x", tcp->u_args[2], tcp->u_args[3]);
	}
	return 0;
}
#endif
