/*
 * @(#)syscall.h	1.5 91/09/05	- syscall declarations
 *		from @(#)init_sysent.c 2.64 89/10/04 SMI; from UCB 6.1 83/08/17
 */
#include "dummy.h"

int	sys_nosys();
int	sys_nullsys();
int	sys_errsys();

/* 1.1 processes and protection */
int	sys_gethostid(),sys_sethostname(),sys_gethostname(),sys_getpid();
int	sys_setdomainname(),sys_getdomainname();
int	sys_fork(),sys_rexit(),sys_execv(),sys_execve(),sys_wait4();
int	sys_getuid(),sys_setreuid(),sys_getgid(),sys_getgroups(),sys_setregid(),sys_setgroups();
int	sys_getpgrp(),sys_setpgrp();
int	sys_sys_setsid(), sys_setpgid();
int	sys_uname();

/* 1.2 memory management */
int	sys_brk(),sys_sbrk(),sys_sstk();
int	sys_getpagesize(),sys_smmap(),sys_mctl(),sys_munmap(),sys_mprotect(),sys_mincore();
int	sys_omsync(),sys_omadvise();

/* 1.3 signals */
int	sys_sigvec(),sys_sigblock(),sys_sigsetmask(),sys_sigpause(),sys_sigstack(),sys_sigcleanup();
int	sys_kill(), sys_killpg(), sys_sigpending();

/* 1.4 timing and statistics */
int	sys_gettimeofday(),sys_settimeofday();
int	sys_adjtime();
int	sys_getitimer(),sys_setitimer();

/* 1.5 descriptors */
int	sys_getdtablesize(),sys_dup(),sys_dup2(),sys_close();
int	sys_select(),sys_getdopt(),sys_setdopt(),sys_fcntl(),sys_flock();

/* 1.6 resource controls */
int	sys_getpriority(),sys_setpriority(),sys_getrusage(),sys_getrlimit(),sys_setrlimit();
int	sys_oldquota(), sys_quotactl();
int	sys_rtschedule();

/* 1.7 system operation support */
int	sys_mount(),sys_unmount(),sys_swapon();
int	sys_sync(),sys_reboot();
int	sys_sysacct();
int	sys_auditsys();

/* 2.1 generic operations */
int	sys_read(),sys_write(),sys_readv(),sys_writev(),sys_ioctl();

/* 2.1.1 asynch operations */
int	sys_aioread(), sys_aiowrite(), sys_aiowait(), sys_aiocancel();

/* 2.2 file system */
int	sys_chdir(),sys_chroot();
int	sys_fchdir(),sys_fchroot();
int	sys_mkdir(),sys_rmdir(),sys_getdirentries(), sys_getdents();
int	sys_creat(),sys_open(),sys_mknod(),sys_unlink(),sys_stat(),sys_fstat(),sys_lstat();
int	sys_chown(),sys_fchown(),sys_chmod(),sys_fchmod(),sys_utimes();
int	sys_link(),sys_symlink(),sys_readlink(),sys_rename();
int	sys_lseek(),sys_truncate(),sys_ftruncate(),sys_access(),sys_fsync();
int	sys_statfs(),sys_fstatfs();

/* 2.3 communications */
int	sys_socket(),sys_bind(),sys_listen(),sys_accept(),sys_connect();
int	sys_socketpair(),sys_sendto(),sys_send(),sys_recvfrom(),sys_recv();
int	sys_sendmsg(),sys_recvmsg(),sys_shutdown(),sys_setsockopt(),sys_getsockopt();
int	sys_getsockname(),sys_getpeername(),sys_pipe();

int	sys_umask();		/* XXX */

/* 2.3.1 SystemV-compatible IPC */
int	sys_semsys();
int	sys_msgsys();
int	sys_shmsys();

/* 2.4 processes */
int	sys_ptrace();

/* 2.5 terminals */

/* emulations for backwards compatibility */
int	sys_otime();		/* now use gettimeofday */
int	sys_ostime();		/* now use settimeofday */
int	sys_oalarm();		/* now use setitimer */
int	sys_outime();		/* now use utimes */
int	sys_opause();		/* now use sigpause */
int	sys_onice();		/* now use setpriority,getpriority */
int	sys_oftime();		/* now use gettimeofday */
int	sys_osetpgrp();		/* ??? */
int	sys_otimes();		/* now use getrusage */
int	sys_ossig();		/* now use sigvec, etc */
int	sys_ovlimit();		/* now use setrlimit,getrlimit */
int	sys_ovtimes();		/* now use getrusage */
int	sys_osetuid();		/* now use setreuid */
int	sys_osetgid();		/* now use setregid */
int	sys_ostat();		/* now use stat */
int	sys_ofstat();		/* now use fstat */

/* BEGIN JUNK */
int	sys_profil();		/* 'cuz sys calls are interruptible */
int	sys_vhangup();		/* should just do in sys_exit() */
int	sys_vfork();		/* XXX - was awaiting fork w/ copy on write */
int	sys_ovadvise();		/* awaiting new madvise */
int	sys_indir();		/* indirect system call */
int	sys_ustat();		/* System V compatibility */
int	sys_owait();		/* should use wait4 interface */
int	sys_owait3();		/* should use wait4 interface */
int	sys_umount();		/* still more Sys V (and 4.2?) compatibility */
int	sys_pathconf();		/* posix */
int	sys_fpathconf();		/* posix */
int	sys_sysconf();		/* posix */

int sys_debug();
/* END JUNK */

int	sys_vtrace();		/* kernel event tracing */

/* nfs */
int	sys_async_daemon();		/* client async daemon */
int	sys_nfs_svc();		/* run nfs server */
int	sys_nfs_getfh();		/* get file handle */
int	sys_exportfs();		/* export file systems */

int  	sys_rfssys();		/* RFS-related calls */

int	sys_getmsg();
int	sys_putmsg();
int	sys_poll();

int	sys_vpixsys();		/* VP/ix system calls */

