/*
 * @(#)ioctlsort.c	1.5 91/09/05	- sort IOCTL codes
 */
#define KERNEL
#include <stdio.h>
#include <strings.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/des.h>
#include <sys/mtio.h>
#include <sys/stropts.h>

#include <net/if.h>
#include <net/if_arp.h>
#include <net/route.h>
#include <net/nit.h>
#include <net/nit_if.h>
#include <net/nit_pf.h>
#include <net/packetfilt.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <netinet/if_ether.h>

#include <scsi/impl/uscsi.h>
#include <scsi/scsi.h>
#include <scsi/targets/srdef.h>
#include <scsi/targets/stdef.h>
#if 0
#include <scsi/targets/sddef.h>
#endif

#include <sun/audioio.h>
#include <sun/fbio.h>
#include <sun/gpio.h>
#include <sun/ndio.h>
#include <sun/tvio.h>
#include <sun/mem.h>
#include <sun/sqz.h>
#include <sun/vddrv.h>

#include <machine/reg.h>

#include <sundev/kbio.h>
#include <sundev/msio.h>
#include <sundev/fdreg.h>

#include <sunwindow/window_hs.h>
#include <sunwindow/win_enum.h>
#include <sunwindow/win_ioctl.h>

#define AUDIO_CHIP
#include <sbusdev/audio_79C30.h>

#if 1
#include <sys/termio.h>
#endif

struct ioctlent {
	char *doth;
	char *symbol;
	long code;
} ioctlent[] = {
#include "ioctlent.h"
};

int nioctlent = sizeof ioctlent / sizeof ioctlent[0];

int
compare(a,b)
struct ioctlent *a, *b;
{
	return (a->code - b->code);
}

main()
{
	int i;

	qsort(ioctlent, nioctlent, sizeof ioctlent[0], compare);
	for (i = 0; i < nioctlent; i++) {
		printf("{\"%s\",\t\"%s\",\t%#x},\n",
			ioctlent[i].doth, ioctlent[i].symbol, ioctlent[i].code);
	}
	return 0;
}
