/*
 * METALBASE 5.1
 *
 * Released January 1st, 1993 by Huan-Ti [ t-richj@microsoft.com ]
 *
 */

#ifndef INPUT_H
#define INPUT_H


/*
 * OPTIONS --------------------------------------------------------------------
 *
 * If you want the field to be accepted (as with a down arrow) automatically
 * when the user has filled it completely, define ADVANCE_AT_END as below.
 * This makes DE feel a bit more natural to some.  Otherwise, comment out this
 * line.
 *
 */

#define ADVANCE_AT_END

/*
 * If you have usleep(), and your arrows act up (don't respond or give
 * garbage), define TROUBLE when you compile this module.
 *
 */

/* #define TROUBLE */

/*
 * Choose a default editor for multi-length character fields.  By default,
 * MB will choose "edit" for MS-DOS systems, and "vi" for anything else.
 * Just replace this whole thing...
 *
 */

#ifdef MSDOS
#define DEFAULT_EDITOR "edit"
#else
#define DEFAULT_EDITOR "vi"
#endif


/*
 * CURSES DECLARATIONS --------------------------------------------------------
 *
 */

#include <curses.h>

#ifdef MSDOS          /*                                                     */
#ifdef KEY_RIGHT      /* If this is defined in curses.h, the curses package  */
#define USE_CURKEY    /* supports keypad mode, and can trap our keys itself. */
#endif                /* Otherwise, we have to use our own esc-sequences.    */
#endif                /*                                                     */

#define movech(c,y,x)  move(y,x);  refresh();  c=getarr();

#define AR_UP    (char)129  /* Arrows for input.c */
#define AR_DOWN  (char)130
#define AR_LEFT  (char)131
#define AR_RIGHT (char)132
#define AR_INS   (char)133  /* Insert, Delete, Home, End, PgUp, PgDn */
#define AR_DEL   (char)134
#define AR_HOME  (char)135
#define AR_END   (char)136
#define AR_PGUP  (char)137
#define AR_PGDN  (char)138

extern WINDOW *win;
extern char    editorname[128];

/*
 * FUNCTION PROTOTYPES --------------------------------------------------------
 *
 * Most curses packages include a typedef for bool; if so, strip ours out.
 * Note that, if your curses package uses 'int' for booleans instead of
 * 'char' (as MetalBase would usually do), you'll need to modify "mbase.h"
 * to use 'int' for booleans, and recompile your library.
 *
 */

#ifndef NO_BOOL
#define NO_BOOL
#endif

#ifndef MBASE_H
#include <mbase.h>
#endif

   void       init_curses    XARGS( (void) );
   void       exit_curses    XARGS( (void) );
   void       display        XARGS( (dataptr, int, int) );
   char       getarr         XARGS( (void) );
   char       input          XARGS( (dataptr, int, int) );

#endif  /* INPUT_H */

