------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                                A T R E E                                 --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.68 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Alloc;  use Alloc;
with Sinfo;  use Sinfo;
with Einfo;  use Einfo;
with Types;  use Types;
with System; use System;
with Table;

package Atree is

--  This package defines the format of the tree used to represent the Ada
--  program internally. Syntactic and semantic information is combined in
--  this tree. There is no separate symbol table structure.

--  WARNING: There is a C version of this package. Any changes to this
--  source file must be properly reflected in the C header file tree.h

--  Package Atree defines the basic structure of the tree and its nodes and
--  provides the basic abstract interface for manipulating the tree. Two
--  other packages use this interface to define the representation of Ada
--  programs using this tree format. The package Sinfo defines the basic
--  representation of the syntactic structure of the program, as output
--  by the parser. The package Entity_Info defines the semantic information
--  which is added to the tree nodes that represent declared entities (i.e.
--  the information which might typically be described in a separate symbol
--  table structure.

--  The front end of the compiler first parses the program and generates a
--  tree that is simply a syntactic representation of the program in abstract
--  syntax tree format. Subsequent processing in the front end traverses the
--  tree, transforming it in various ways and adding semantic information.

   ----------------------------------------
   -- Definitions of Fields in Tree Node --
   ----------------------------------------

   --  The representation of the tree is completely hidden, using a functional
   --  interface for accessing and modifying the contents of nodes. Logically
   --  a node contains a number of fields, much as though the nodes were
   --  defined as a record type. The fields in a node are as follows:

   --   Nkind            Indicates the kind of the node. This field is present
   --                    in all nodes. The type is Node_Kind, which is declared
   --                    in the package Sinfo.

   --   Sloc             Location (Source_Ptr) of the corresponding token
   --                    in the Source buffer. The individual node definitions
   --                    show which token is referenced by this pointer.

   --   In_List          A flag used to indicate if the node is a member
   --                    of a node list.

   --   Rewrite_Sub      A flag set if the node has been rewritten using
   --                    the Rewrite_Substitute_Tree procedure. The original
   --                    value of the node is retrievable with Original_Node.

   --   Rewrite_Ins      A flag set if a node is marked as a rewrite inserted
   --                    node as a result of a call to Mark_Rewrite_Insertion.

   --   Paren_Count      A 2-bit count used on expression nodes to indicate
   --                    the level of parentheses. Up to 3 levels can be
   --                    accomodated. Anything more than 3 levels is treated
   --                    as 3 levels (conformance tests that complain about
   --                    this are hereby deemed pathalogical!) Set to zero
   --                    for non-subexpression nodes.

   --   Field1           A Union_Id value stored in the tree

   --   Node1            Synonym for Field1 typed as Node_Id
   --   List1            Synonym for Field1 typed as List_Id
   --   Elist1           Synonym for Field1 typed as Elist_Id
   --   Name1            Synonym for Field1 typed as Name_Id
   --   Char_Code1       Synonym for Field1 typed as Char_Code
   --   Uint1            Synonym for Field1 typed as Uint

   --   Note: the actual usage of Field1 (i.e. whether it contains a Node_Id,
   --   List_Id, Elist_Id, Name_Id, Char_Code or Uint), depends on the value
   --   in Nkind (and, for entities, the value in Ekind). Generally the access
   --   to this field is always via the functional interface, so the field
   --   names Field1, Node1, List1, Elist1, Name1, Char_Code1 and Uint1 are
   --   used only in the bodies of the access functions (i.e. in the bodies
   --   of Sinfo and Einfo). These access functions contain debugging code
   --   that checks that the usage is consistent with Nkind and Ekind.

   --   However, in specialized circumstances (examples are the circuit in
   --   generic instantiation to copy trees, and in the tree dump routine),
   --   it is useful to be able to do untyped traversals, and an internal
   --   package in Atree allows for direct untyped accesses in such cases.

   --   Similar definitions for Field2, Field3, Field4, Field5 (and also
   --   Node2-5, List2-5, Elist2-5, Name2-5, Char_Code2-5, Uint2-5)

   --   Flag1            Eighteen Boolean flags (use depends on Nkind and
   --   Flag2            Ekind, as described for Fieldn). Again the access
   --   Flag3            is usually via subprograms in Sinfo and Einfo which
   --   Flag4            provide high-level synonyms for these flags, and
   --   Flag5            contain debugging code that checks that the values
   --   Flag6            in Nkind and Ekind are appropriate for the access.
   --   Flag7
   --   Flag8
   --   Flag9
   --   Flag10
   --   Flag11
   --   Flag12
   --   Flag13
   --   Flag14
   --   Flag15
   --   Flag16
   --   Flag17
   --   Flag18

   --   Parent           Pointer to parent node, i.e. node which points to
   --                    the node which references this field. The parent
   --                    field can only be set in a node which is not in
   --                    a list, or in a list header. The parent field of
   --                    nodes that are in a list is automatically set to
   --                    the parent of the list header, and cannot be
   --                    explicitly set. This field is considered private
   --                    to Atree.

   --  The following additional fields are present in extended nodes used
   --  for entities (Nkind in N_Entity).

   --   Ekind            Entity type. This field indicates the type of the
   --                    entity, it is of type Entity_Kind which is defined
   --                    in package Einfo.

   --   Flag19           Forty-two additional flags
   --   ...
   --   Flag60

   --   Field6           Additional Union_Id value stored in tree

   --   Node6            Synonym for Field6 typed as Node_Id
   --   Elist6           Synonym for Field6 typed as Elist_Id
   --   Uint6            Synonym for Field6 typed as Uint

   --   Similar definitions for Field7 to Field17 (and Node7-Node17,
   --   Elist7-Elist17, Uint7-Uint17).

   type Paren_Count_Type is mod 4;
   for Paren_Count_Type'Size use 2;
   --  Type used for Paren_Count field

   function Last_Node_Id return Node_Id;
   pragma Inline (Last_Node_Id);
   --  Returns Id of last allocated node Id

   function Nodes_Address return System.Address;
   --  Return address of Nodes table (used in Back_End for Gigi call)

   function Num_Nodes return Nat;
   --  Total number of nodes allocated, where an entity counts as a single
   --  node. This count is incremented every time a node or entity is
   --  allocated, and decremented every time a node or entity is deleted.

   -----------------------
   -- Use of Empty Node --
   -----------------------

   --  The special Node_Id Empty is used to mark missing fields. Whenever the
   --  syntax has an optional component, then the corresponding field will be
   --  set to Empty if the component is missing.

   --  Note: Empty is not used to describe an empty list. Instead in this
   --  case the node field contains a list which is empty, and these cases
   --  should be distinguished (essentially from a type point of view, Empty
   --  is a Node, and is thus not a list).

   --  Note: Empty does in fact correspond to an allocated node. Only the
   --  Nkind field of this node may be referenced. It contains N_Empty, which
   --  uniquely identifies the empty case. This allows the Nkind field to be
   --  dereferenced before the check for Empty which is sometimes useful.

   -------------------------------
   -- Default Setting of Fields --
   -------------------------------

   --  Nkind is set to N_Unused_At_Start

   --  Ekind is set to E_Void

   --  Sloc is always set, there is no default value

   --  Field1-5 fields are set to Empty

   --  Field6-17 fields in extended nodes are set to Empty

   --  Parent is set to Empty

   --  All Boolean flag fields are set to False

   --  Note: the value Empty is used in Field1-Field17 to indicate a null node.
   --  The usage varies. The common uses are to indicate absence of an
   --  optional clause or a completely unused Field1-17 field.

   -------------------------------------
   -- Use of Synonyms for Node Fields --
   -------------------------------------

   --  A subpackage Atree.Unchecked_Access provides routines for reading and
   --  writing the fields defined above (Field1-17, Node1-17, Flag1-60 etc).
   --  These unchecked access routines can be used for untyped traversals. In
   --  In addition they are used in the implementations of the Sinfo and
   --  Einfo packages. These packages both provide logical synonyms for
   --  the generic fields, together with an appropriate set of access routines.
   --  Normally access to information within tree nodes uses these synonyms,
   --  providing a high level typed interface to the tree information.

   --------------------------------------------------
   -- Node Allocation and Modification Subprograms --
   --------------------------------------------------

   --  Generally the parser builds the tree amd then it is further decorated
   --  (e.g. by setting the entity fields), but not fundamentally modified.
   --  However, there are cases in which the tree must be restructured by
   --  adding and rearranging nodes, as a result of disambiguating cases
   --  which the parser could not parse correctly, and adding additional
   --  semantic information (e.g. making constraint checks explicit). The
   --  following subprograms are used for constructing the tree in the first
   --  place, and then for subsequent modifications as required

   procedure Initialize;
   --  Called at the start of compilation to initialize the allocation of
   --  the node and list tables and make the standard entries for Empty,
   --  Error and Error_List.

   function New_Node
     (New_Node_Kind : Node_Kind;
      New_Sloc      : Source_Ptr)
      return          Node_Id;
   --  Allocates a completely new node with the given node type and source
   --  location values. All other fields are set to their standard defaults:
   --
   --    Empty for all Fieldn fields
   --    False for all Flagn fields
   --
   --  The usual approach is to build a new node using this function and
   --  then, using the value returned, use the Set_xxx functions to set
   --  fields of the node as required. New_Node can only be used for
   --  non-entity nodes, i.e. it never generates an extended node.

   function New_Entity
     (New_Node_Kind : Node_Kind;
      New_Sloc      : Source_Ptr)
      return          Entity_Id;
   --  Similar to New_Node, except that it is used only for entity nodes
   --  and returns an extended node.

   function Has_Extension (N : Node_Id) return Boolean;
   pragma Inline (Has_Extension);
   --  Returns True if the given node has an extension (i.e. was created by
   --  a call to New_Entity rather than New_Node, and Nkind is in N_Entity)

   procedure Change_Node (N : Node_Id; New_Node_Kind : Node_Kind);
   --  This procedure replaces the given node by setting its Nkind field to
   --  the indicated value and resetting all other fields to their default
   --  values except for Sloc, which is unchanged, and the Parent pointer
   --  and list links, which are also unchanged. All other information in
   --  the original node is lost. The new node has an extension if the
   --  original node had an extension.

   procedure Copy_Node (Source : Node_Id; Destination : Node_Id);
   --  Copy the entire contents of the source node to the destination node.
   --  The contents of the source node is not affected. If the source node
   --  has an extension, then the destination must have an extension also.
   --  The parent pointer of the destination and its list link, if any, are
   --  not affected by the copy. Note that parent pointers of descendents
   --  are not adjusted, so the descendents of the destination node after
   --  the Copy_Node is completed have dubious parent pointers.

   function New_Copy (Source : Node_Id) return Node_Id;
   --  This function allocates a completely new node, and then initializes
   --  it by copying the contents of the source node into it. The contents
   --  of the source node is not affected. The target node is always marked
   --  as not being in a list (even if the source is a list member). The
   --  new node will have an extension if the source has an extension.
   --  New_Copy (Empty) returns Empty and New_Copy (Error) returns Error.
   --  Note that, unlike New_Copy_Tree, New_Copy does not recursively copy any
   --  descendents, so in general parent pointers are not set correctly for
   --  the descendents of the copied node. Both normal and extended nodes
   --  (entities) may be copied using New_Copy.

   function Relocate_Node (Source : Node_Id) return Node_Id;
   --  Source is a non-entity node that is to be relocated. A new node is
   --  allocated and the contents of Source are copied to this node using
   --  Copy_Node. The parent pointers of descendents of the node are then
   --  adjusted to point to the relocated copy. The original node is not
   --  modified, but the parent pointers of its descendents are no longer
   --  valid. This routine is used in conjunction with the tree rewrite
   --  routines (see descriptions of Replace/Rewrite_Substitute_Tree)

   function New_Copy_Tree (Source : Node_Id) return Node_Id;
   --  Given a node that is the root of a subtree, Copy_Tree copies the entire
   --  syntactic subtree, including recursively any descendents whose parent
   --  field references a copied node (descendents not linked to a copied node
   --  by the parent field are not copied, instead the copied tree references
   --  the same descendent as the original in this case, which is appropriate
   --  for non-syntactic fields such as Etype). The parent pointers in the
   --  copy are properly set. Copy_Tree (Empty/Error) returns Empty/Error.
   --  The one exception to the rule of not copying semantic fields is that
   --  any implicit types attached to the subtree are duplicated, so that
   --  the copy contains a distinct set of implicit type entities.

   procedure Exchange_Entities (E1 : Entity_Id; E2 : Entity_Id);
   --  Exchange the contents of two entities. The parent pointers are switched
   --  as well as the Defining_Identifier fields in the parents, so that the
   --  entities point correctly to their original parents. The effect is thus
   --  to leave the tree completely unchanged in structure, except that the
   --  entity ID values of the two entities are interchanged. Neither of the
   --  two entities may be list members.

   procedure Delete_Node (Node : Node_Id);
   --  The node, which must not be a list member, is deleted from the tree
   --  an its type is set to N_Void. It is an error (not necessarily detected)
   --  to reference this node after it has been deleted. The implementation of
   --  the body of Atree is free to reuse the node to satisfy future node
   --  allocation requests, but is not required to do so.

   function Extend_Node (Node : Node_Id) return Node_Id;
   --  This function returns a copy of its input node with an extension
   --  added. The fields of the extension are set to Empty. Due to the way
   --  extensions are handled (as two consecutive array elements), it may
   --  be necessary to reallocate the node, so that the returned value is
   --  not the same as the input value, but where possible the returned
   --  value will be the same as the input value (i.e. the extension will
   --  occur in place). It is the caller's responsibility to ensure that
   --  any pointers to the original node are appropriately updated. This
   --  function is used only by Sinfo.CN to change nodes into their
   --  corresponding entities, which is why it is in Unchecked_Access.

   ---------------------------
   -- Node Access Functions --
   ---------------------------

   --  The following functions return the contents of the indicated field of
   --  the node referenced by the argument, which is a Node_Id.

   function Nkind (N : Node_Id) return Node_Kind;
   pragma Inline (Nkind);

   function Ekind (N : Node_Id) return Entity_Kind;
   pragma Inline (Ekind);

   function Sloc  (N : Node_Id) return Source_Ptr;
   pragma Inline (Sloc);

   function Paren_Count (N : Node_Id) return Paren_Count_Type;
   pragma Inline (Paren_Count);

   function Parent (N : Node_Id)  return Node_Id;
   pragma Inline (Parent);

   function No (N : Node_Id) return Boolean;
   pragma Inline (No);
   --  Tests given Id for equality with the Empty node. This allows notations
   --  like "if No (Variant_Part)" as opposed to "if Variant_Part = Empty".

   function Present (N : Node_Id) return Boolean;
   pragma Inline (Present);
   --  Tests given Id for inequality with the Empty node. This allows notations
   --  like "if Present (Statement)" as opposed to "if Statement /= Empty".

   ----------------------------
   -- Node Update Procedures --
   ----------------------------

   --  The following functions set a specified field in the node whose Id is
   --  passed as the first argument. The second parameter is the new value
   --  to be set in the specified field. Note that Set_Nkind is in the next
   --  section, since its use is restricted.

   procedure Set_Ekind (N : Node_Id; Val : Entity_Kind);
   pragma Inline (Set_Ekind);

   procedure Set_Sloc (N : Node_Id; Val : Source_Ptr);
   pragma Inline (Set_Sloc);

   procedure Set_Paren_Count (N : Node_Id; Val : Paren_Count_Type);
   pragma Inline (Set_Paren_Count);

   procedure Set_Parent (N : Node_Id;  Val : Node_Id);
   pragma Inline (Set_Parent);

   ---------------------------
   -- Tree Rewrite Routines --
   ---------------------------

   --  During the compilation process it is necessary in a number of situations
   --  to rewrite the tree. In some cases, such rewrites do not affect the
   --  structure of the tree, for example, when an indexed component node is
   --  replaced by the corresponding call node (the parser cannot distinguish
   --  between these two cases).

   --  In other situations, the rewrite does affect the structure of the
   --  tree. Examples are the replacement of a generic instantiation by the
   --  instantiated spec and body, and the static evaluation of expressions.

   --  If such structural modifications are done by the expander, there are
   --  no difficulties, since the form of the tree after the expander has no
   --  special significance, except as input to the backend of the compiler.
   --  However, if these modifications are done by the semantic phase, then
   --  it is important that they be done in a manner which allows the original
   --  tree to be preserved. This is because tools like pretty printers need
   --  to have this original tree structure available.

   --  The subprograms in this section allow rewriting of the tree by either
   --  insertion of new nodes in an existing list, or complete replacement of
   --  a subtree. The resulting tree for most purposes looks as though it has
   --  been really changed, and there is no trace of the original. However,
   --  special subprograms, also defined in this section, allow the original
   --  tree to be reconstructed if necessary.

   --  For tree modifications done in the expander, it is permissible to
   --  destroy the original tree, although it is also allowable to use the
   --  tree rewrite routines where it is convenient to do so.

   procedure Mark_Rewrite_Insertion (New_Node : Node_Id);
   pragma Inline (Mark_Rewrite_Insertion);
   --  This procedure marks the given node as an insertion made during a tree
   --  rewriting operation. Only the root needs to be marked. The call does
   --  not do the actual insertion, which must be done using one of the normal
   --  list insertion routines. The node is treated normally in all respects
   --  except for its response to Is_Rewrite_Insertion.

   function Is_Rewrite_Insertion (Node : Node_Id) return Boolean;
   pragma Inline (Is_Rewrite_Insertion);
   --  Tests whether the given node was marked using Set_Rewrite_Insert. This
   --  is used in reconstructing the original tree (where such nodes are to
   --  be eliminated from the reconstructed tree).

   procedure Rewrite_Substitute_Tree (Old_Node, New_Node : Node_Id);
   --  This is used when a complete subtree is to be replaced. Old_Node is the
   --  root of the old subtree to be replaced, and New_Node is the root of the
   --  newly constructed replacement subtree. The actual mechanism is to swap
   --  the contents of these two nodes fixing up the parent pointers of the
   --  replaced node (we do not attempt to preserve parent pointers for the
   --  original node). Neither Old_Node nor New_Node can be extended nodes.
   --
   --  Note, New_Node may not contain references to Old_Node, for example as
   --  descendents, since the rewrite would make such references invalid. If
   --  New_Node does need to refernce Old_Node, then these references should
   --  be to a relocated copy of Old_Node (see Relocate_Node procedure).

   procedure Replace_Substitute_Tree (Old_Node, New_Node : Node_Id);
   --  This is similar to Rewrite_Substitute_Tree, except that the old value
   --  of Old_Node is not saved, and the New_Node is deleted after the replace
   --  since it is assumed that it can no longer be legitimately needed. The
   --  Is_Rewrite_Susbtitute flag will be False for the resulting node, unless
   --  it was already true on entry, and Original_Node will not return the
   --  original contents of the Old_Node, but rather the New_Node value (unless
   --  Old_Node had already been rewritten using Rewrite_Substitute_Tree).
   --
   --  Note, New_Node may not contain references to Old_Node, for example as
   --  descendents, since the rewrite would make such references invalid. If
   --  New_Node does need to refernce Old_Node, then these references should
   --  be to a relocated copy of Old_Node (see Relocate_Node procedure).

   function Is_Rewrite_Substitution (Node : Node_Id) return Boolean;
   pragma Inline (Is_Rewrite_Substitution);
   --  Return True iff Node has been rewritten (i.e. if Node is the root
   --  or a subtree which was installed using Rewrite_Substitute_Tree)

   function Original_Node (Node : Node_Id) return Node_Id;
   --  If Node has not been rewritten, then returns its input argument
   --  unchanged, else returns the Node for the original subtree. If
   --  applied to a node marked by Set_Rewrite_Insert, returns Empty.
   --  Note that parents are not preserved in original tree nodes that
   --  are retrieved in this way (i.e. their children may have parent
   --  pointers which reference some other node).

   --  Note: there is no direct mechanism for deleting an original node (in
   --  a manner that can be reversed later). One possible approach is to use
   --  Rewrite_Substitute_Tree to substitute a null statement for the node
   --  to be deleted.

   -----------------------------------
   -- Generic Field Access Routines --
   -----------------------------------

   --  This subpackage provides the functions for accessing and procedures
   --  for setting fields that are normally referenced by their logical
   --  synonyms defined in packages Sinfo and Einfo. As previously
   --  described the implementations of these packages use the package
   --  Atree.Unchecked_Access.

   package Unchecked_Access is

      --  Functions to fetch contents of indicated field. It is an error
      --  to attempt to read the value of a field which is not present.

      function Field1 (N : Node_Id) return Union_Id;
      pragma Inline (Field1);

      function Field2 (N : Node_Id) return Union_Id;
      pragma Inline (Field2);

      function Field3 (N : Node_Id) return Union_Id;
      pragma Inline (Field3);

      function Field4 (N : Node_Id) return Union_Id;
      pragma Inline (Field4);

      function Field5 (N : Node_Id) return Union_Id;
      pragma Inline (Field5);

      function Field6 (N : Node_Id) return Union_Id;
      pragma Inline (Field6);

      function Field7 (N : Node_Id) return Union_Id;
      pragma Inline (Field7);

      function Field8 (N : Node_Id) return Union_Id;
      pragma Inline (Field8);

      function Field9 (N : Node_Id) return Union_Id;
      pragma Inline (Field9);

      function Field10 (N : Node_Id) return Union_Id;
      pragma Inline (Field10);

      function Field11 (N : Node_Id) return Union_Id;
      pragma Inline (Field11);

      function Field12 (N : Node_Id) return Union_Id;
      pragma Inline (Field12);

      function Field13 (N : Node_Id) return Union_Id;
      pragma Inline (Field13);

      function Field14 (N : Node_Id) return Union_Id;
      pragma Inline (Field14);

      function Field15 (N : Node_Id) return Union_Id;
      pragma Inline (Field15);

      function Field16 (N : Node_Id) return Union_Id;
      pragma Inline (Field16);

      function Field17 (N : Node_Id) return Union_Id;
      pragma Inline (Field17);

      function Node1 (N : Node_Id) return Node_Id;
      pragma Inline (Node1);

      function Node2 (N : Node_Id) return Node_Id;
      pragma Inline (Node2);

      function Node3 (N : Node_Id) return Node_Id;
      pragma Inline (Node3);

      function Node4 (N : Node_Id) return Node_Id;
      pragma Inline (Node4);

      function Node5 (N : Node_Id) return Node_Id;
      pragma Inline (Node5);

      function Node6 (N : Node_Id) return Node_Id;
      pragma Inline (Node6);

      function Node7 (N : Node_Id) return Node_Id;
      pragma Inline (Node7);

      function Node8 (N : Node_Id) return Node_Id;
      pragma Inline (Node8);

      function Node9 (N : Node_Id) return Node_Id;
      pragma Inline (Node9);

      function Node10 (N : Node_Id) return Node_Id;
      pragma Inline (Node10);

      function Node11 (N : Node_Id) return Node_Id;
      pragma Inline (Node11);

      function Node12 (N : Node_Id) return Node_Id;
      pragma Inline (Node12);

      function Node13 (N : Node_Id) return Node_Id;
      pragma Inline (Node13);

      function Node14 (N : Node_Id) return Node_Id;
      pragma Inline (Node14);

      function Node15 (N : Node_Id) return Node_Id;
      pragma Inline (Node15);

      function Node16 (N : Node_Id) return Node_Id;
      pragma Inline (Node16);

      function Node17 (N : Node_Id) return Node_Id;
      pragma Inline (Node17);

      function List1 (N : Node_Id) return List_Id;
      pragma Inline (List1);

      function List2 (N : Node_Id) return List_Id;
      pragma Inline (List2);

      function List3 (N : Node_Id) return List_Id;
      pragma Inline (List3);

      function List4 (N : Node_Id) return List_Id;
      pragma Inline (List4);

      function List5 (N : Node_Id) return List_Id;
      pragma Inline (List5);

      function Elist1 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist1);

      function Elist2 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist2);

      function Elist3 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist3);

      function Elist4 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist4);

      function Elist5 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist5);

      function Elist6 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist6);

      function Elist7 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist7);

      function Elist8 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist8);

      function Elist9 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist9);

      function Elist10 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist10);

      function Elist11 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist11);

      function Elist12 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist12);

      function Elist13 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist13);

      function Elist14 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist14);

      function Elist15 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist15);

      function Elist16 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist16);

      function Elist17 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist17);

      function Name1 (N : Node_Id) return Name_Id;
      pragma Inline (Name1);

      function Name2 (N : Node_Id) return Name_Id;
      pragma Inline (Name2);

      function Name3 (N : Node_Id) return Name_Id;
      pragma Inline (Name3);

      function Name4 (N : Node_Id) return Name_Id;
      pragma Inline (Name4);

      function Name5 (N : Node_Id) return Name_Id;
      pragma Inline (Name5);

      function Char_Code1 (N : Node_Id) return Char_Code;
      pragma Inline (Char_Code1);

      function Char_Code2 (N : Node_Id) return Char_Code;
      pragma Inline (Char_Code2);

      function Char_Code3 (N : Node_Id) return Char_Code;
      pragma Inline (Char_Code3);

      function Char_Code4 (N : Node_Id) return Char_Code;
      pragma Inline (Char_Code4);

      function Char_Code5 (N : Node_Id) return Char_Code;
      pragma Inline (Char_Code5);

      function Str1 (N : Node_Id) return String_Id;
      pragma Inline (Str1);

      function Str2 (N : Node_Id) return String_Id;
      pragma Inline (Str2);

      function Str3 (N : Node_Id) return String_Id;
      pragma Inline (Str3);

      function Str4 (N : Node_Id) return String_Id;
      pragma Inline (Str4);

      function Str5 (N : Node_Id) return String_Id;
      pragma Inline (Str5);

      function Uint1 (N : Node_Id) return Uint;
      pragma Inline (Uint1);

      function Uint2 (N : Node_Id) return Uint;
      pragma Inline (Uint2);

      function Uint3 (N : Node_Id) return Uint;
      pragma Inline (Uint3);

      function Uint4 (N : Node_Id) return Uint;
      pragma Inline (Uint4);

      function Uint5 (N : Node_Id) return Uint;
      pragma Inline (Uint5);

      function Uint6 (N : Node_Id) return Uint;
      pragma Inline (Uint6);

      function Uint7 (N : Node_Id) return Uint;
      pragma Inline (Uint7);

      function Uint8 (N : Node_Id) return Uint;
      pragma Inline (Uint8);

      function Uint9 (N : Node_Id) return Uint;
      pragma Inline (Uint9);

      function Uint10 (N : Node_Id) return Uint;
      pragma Inline (Uint10);

      function Uint11 (N : Node_Id) return Uint;
      pragma Inline (Uint11);

      function Uint12 (N : Node_Id) return Uint;
      pragma Inline (Uint12);

      function Uint13 (N : Node_Id) return Uint;
      pragma Inline (Uint13);

      function Uint14 (N : Node_Id) return Uint;
      pragma Inline (Uint14);

      function Uint15 (N : Node_Id) return Uint;
      pragma Inline (Uint15);

      function Uint16 (N : Node_Id) return Uint;
      pragma Inline (Uint16);

      function Uint17 (N : Node_Id) return Uint;
      pragma Inline (Uint17);

      function Flag1 (N : Node_Id) return Boolean;
      pragma Inline (Flag1);

      function Flag2 (N : Node_Id) return Boolean;
      pragma Inline (Flag2);

      function Flag3 (N : Node_Id) return Boolean;
      pragma Inline (Flag3);

      function Flag4 (N : Node_Id) return Boolean;
      pragma Inline (Flag4);

      function Flag5 (N : Node_Id) return Boolean;
      pragma Inline (Flag5);

      function Flag6 (N : Node_Id) return Boolean;
      pragma Inline (Flag6);

      function Flag7 (N : Node_Id) return Boolean;
      pragma Inline (Flag7);

      function Flag8 (N : Node_Id) return Boolean;
      pragma Inline (Flag8);

      function Flag9 (N : Node_Id) return Boolean;
      pragma Inline (Flag9);

      function Flag10 (N : Node_Id) return Boolean;
      pragma Inline (Flag10);

      function Flag11 (N : Node_Id) return Boolean;
      pragma Inline (Flag11);

      function Flag12 (N : Node_Id) return Boolean;
      pragma Inline (Flag12);

      function Flag13 (N : Node_Id) return Boolean;
      pragma Inline (Flag13);

      function Flag14 (N : Node_Id) return Boolean;
      pragma Inline (Flag14);

      function Flag15 (N : Node_Id) return Boolean;
      pragma Inline (Flag15);

      function Flag16 (N : Node_Id) return Boolean;
      pragma Inline (Flag16);

      function Flag17 (N : Node_Id) return Boolean;
      pragma Inline (Flag17);

      function Flag18 (N : Node_Id) return Boolean;
      pragma Inline (Flag18);

      function Flag19 (N : Node_Id) return Boolean;
      pragma Inline (Flag19);

      function Flag20 (N : Node_Id) return Boolean;
      pragma Inline (Flag20);

      function Flag21 (N : Node_Id) return Boolean;
      pragma Inline (Flag21);

      function Flag22 (N : Node_Id) return Boolean;
      pragma Inline (Flag22);

      function Flag23 (N : Node_Id) return Boolean;
      pragma Inline (Flag23);

      function Flag24 (N : Node_Id) return Boolean;
      pragma Inline (Flag24);

      function Flag25 (N : Node_Id) return Boolean;
      pragma Inline (Flag25);

      function Flag26 (N : Node_Id) return Boolean;
      pragma Inline (Flag26);

      function Flag27 (N : Node_Id) return Boolean;
      pragma Inline (Flag27);

      function Flag28 (N : Node_Id) return Boolean;
      pragma Inline (Flag28);

      function Flag29 (N : Node_Id) return Boolean;
      pragma Inline (Flag29);

      function Flag30 (N : Node_Id) return Boolean;
      pragma Inline (Flag30);

      function Flag31 (N : Node_Id) return Boolean;
      pragma Inline (Flag31);

      function Flag32 (N : Node_Id) return Boolean;
      pragma Inline (Flag32);

      function Flag33 (N : Node_Id) return Boolean;
      pragma Inline (Flag33);

      function Flag34 (N : Node_Id) return Boolean;
      pragma Inline (Flag34);

      function Flag35 (N : Node_Id) return Boolean;
      pragma Inline (Flag35);

      function Flag36 (N : Node_Id) return Boolean;
      pragma Inline (Flag36);

      function Flag37 (N : Node_Id) return Boolean;
      pragma Inline (Flag37);

      function Flag38 (N : Node_Id) return Boolean;
      pragma Inline (Flag38);

      function Flag39 (N : Node_Id) return Boolean;
      pragma Inline (Flag39);

      function Flag40 (N : Node_Id) return Boolean;
      pragma Inline (Flag40);

      function Flag41 (N : Node_Id) return Boolean;
      pragma Inline (Flag41);

      function Flag42 (N : Node_Id) return Boolean;
      pragma Inline (Flag42);

      function Flag43 (N : Node_Id) return Boolean;
      pragma Inline (Flag43);

      function Flag44 (N : Node_Id) return Boolean;
      pragma Inline (Flag44);

      function Flag45 (N : Node_Id) return Boolean;
      pragma Inline (Flag45);

      function Flag46 (N : Node_Id) return Boolean;
      pragma Inline (Flag46);

      function Flag47 (N : Node_Id) return Boolean;
      pragma Inline (Flag47);

      function Flag48 (N : Node_Id) return Boolean;
      pragma Inline (Flag48);

      function Flag49 (N : Node_Id) return Boolean;
      pragma Inline (Flag49);

      function Flag50 (N : Node_Id) return Boolean;
      pragma Inline (Flag50);

      function Flag51 (N : Node_Id) return Boolean;
      pragma Inline (Flag51);

      function Flag52 (N : Node_Id) return Boolean;
      pragma Inline (Flag52);

      function Flag53 (N : Node_Id) return Boolean;
      pragma Inline (Flag53);

      function Flag54 (N : Node_Id) return Boolean;
      pragma Inline (Flag54);

      function Flag55 (N : Node_Id) return Boolean;
      pragma Inline (Flag55);

      function Flag56 (N : Node_Id) return Boolean;
      pragma Inline (Flag56);

      function Flag57 (N : Node_Id) return Boolean;
      pragma Inline (Flag57);

      function Flag58 (N : Node_Id) return Boolean;
      pragma Inline (Flag58);

      function Flag59 (N : Node_Id) return Boolean;
      pragma Inline (Flag59);

      function Flag60 (N : Node_Id) return Boolean;
      pragma Inline (Flag60);

      function Flag61 (N : Node_Id) return Boolean;
      pragma Inline (Flag61);

      function Flag62 (N : Node_Id) return Boolean;
      pragma Inline (Flag62);

      function Flag63 (N : Node_Id) return Boolean;
      pragma Inline (Flag63);

      function Flag64 (N : Node_Id) return Boolean;
      pragma Inline (Flag64);

      --  Procedures to set value of indicated field

      procedure Set_Nkind (N : Node_Id; Val : Node_Kind);
      pragma Inline (Set_Nkind);

      procedure Set_Field1 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field1);

      procedure Set_Field2 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field2);

      procedure Set_Field3 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field3);

      procedure Set_Field4 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field4);

      procedure Set_Field5 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field5);

      procedure Set_Field6 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field6);

      procedure Set_Field7 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field7);

      procedure Set_Field8 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field8);

      procedure Set_Field9 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field9);

      procedure Set_Field10 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field10);

      procedure Set_Field11 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field11);

      procedure Set_Field12 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field12);

      procedure Set_Field13 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field13);

      procedure Set_Field14 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field14);

      procedure Set_Field15 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field15);

      procedure Set_Field16 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field16);

      procedure Set_Field17 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field17);

      procedure Set_Node1 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node1);

      procedure Set_Node2 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node2);

      procedure Set_Node3 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node3);

      procedure Set_Node4 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node4);

      procedure Set_Node5 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node5);

      procedure Set_Node6 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node6);

      procedure Set_Node7 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node7);

      procedure Set_Node8 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node8);

      procedure Set_Node9 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node9);

      procedure Set_Node10 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node10);

      procedure Set_Node11 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node11);

      procedure Set_Node12 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node12);

      procedure Set_Node13 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node13);

      procedure Set_Node14 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node14);

      procedure Set_Node15 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node15);

      procedure Set_Node16 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node16);

      procedure Set_Node17 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node17);

      procedure Set_List1 (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List1);

      procedure Set_List2 (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List2);

      procedure Set_List3 (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List3);

      procedure Set_List4 (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List4);

      procedure Set_List5 (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List5);

      procedure Set_Elist1 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist1);

      procedure Set_Elist2 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist2);

      procedure Set_Elist3 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist3);

      procedure Set_Elist4 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist4);

      procedure Set_Elist5 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist5);

      procedure Set_Elist6 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist6);

      procedure Set_Elist7 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist7);

      procedure Set_Elist8 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist8);

      procedure Set_Elist9 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist9);

      procedure Set_Elist10 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist10);

      procedure Set_Elist11 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist11);

      procedure Set_Elist12 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist12);

      procedure Set_Elist13 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist13);

      procedure Set_Elist14 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist14);

      procedure Set_Elist15 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist15);

      procedure Set_Elist16 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist16);

      procedure Set_Elist17 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist17);

      procedure Set_Name1 (N : Node_Id; Val : Name_Id);
      pragma Inline (Set_Name1);

      procedure Set_Name2 (N : Node_Id; Val : Name_Id);
      pragma Inline (Set_Name2);

      procedure Set_Name3 (N : Node_Id; Val : Name_Id);
      pragma Inline (Set_Name3);

      procedure Set_Name4 (N : Node_Id; Val : Name_Id);
      pragma Inline (Set_Name4);

      procedure Set_Name5 (N : Node_Id; Val : Name_Id);
      pragma Inline (Set_Name5);

      procedure Set_Char_Code1 (N : Node_Id; Val : Char_Code);
      pragma Inline (Set_Char_Code1);

      procedure Set_Char_Code2 (N : Node_Id; Val : Char_Code);
      pragma Inline (Set_Char_Code2);

      procedure Set_Char_Code3 (N : Node_Id; Val : Char_Code);
      pragma Inline (Set_Char_Code3);

      procedure Set_Char_Code4 (N : Node_Id; Val : Char_Code);
      pragma Inline (Set_Char_Code4);

      procedure Set_Char_Code5 (N : Node_Id; Val : Char_Code);
      pragma Inline (Set_Char_Code5);

      procedure Set_Str1 (N : Node_Id; Val : String_Id);
      pragma Inline (Set_Str1);

      procedure Set_Str2 (N : Node_Id; Val : String_Id);
      pragma Inline (Set_Str2);

      procedure Set_Str3 (N : Node_Id; Val : String_Id);
      pragma Inline (Set_Str3);

      procedure Set_Str4 (N : Node_Id; Val : String_Id);
      pragma Inline (Set_Str4);

      procedure Set_Str5 (N : Node_Id; Val : String_Id);
      pragma Inline (Set_Str5);

      procedure Set_Uint1 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint1);

      procedure Set_Uint2 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint2);

      procedure Set_Uint3 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint3);

      procedure Set_Uint4 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint4);

      procedure Set_Uint5 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint5);

      procedure Set_Uint6 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint5);

      procedure Set_Uint7 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint7);

      procedure Set_Uint8 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint8);

      procedure Set_Uint9 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint9);

      procedure Set_Uint10 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint10);

      procedure Set_Uint11 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint11);

      procedure Set_Uint12 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint12);

      procedure Set_Uint13 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint13);

      procedure Set_Uint14 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint14);

      procedure Set_Uint15 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint15);

      procedure Set_Uint16 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint16);

      procedure Set_Uint17 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint17);

      procedure Set_Flag1 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag1);

      procedure Set_Flag2 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag2);

      procedure Set_Flag3 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag3);

      procedure Set_Flag4 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag4);

      procedure Set_Flag5 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag5);

      procedure Set_Flag6 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag6);

      procedure Set_Flag7 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag7);

      procedure Set_Flag8 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag8);

      procedure Set_Flag9 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag9);

      procedure Set_Flag10 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag10);

      procedure Set_Flag11 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag11);

      procedure Set_Flag12 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag12);

      procedure Set_Flag13 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag13);

      procedure Set_Flag14 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag14);

      procedure Set_Flag15 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag15);

      procedure Set_Flag16 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag16);

      procedure Set_Flag17 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag17);

      procedure Set_Flag18 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag18);

      procedure Set_Flag19 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag19);

      procedure Set_Flag20 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag20);

      procedure Set_Flag21 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag21);

      procedure Set_Flag22 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag22);

      procedure Set_Flag23 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag23);

      procedure Set_Flag24 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag24);

      procedure Set_Flag25 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag25);

      procedure Set_Flag26 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag26);

      procedure Set_Flag27 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag27);

      procedure Set_Flag28 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag28);

      procedure Set_Flag29 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag29);

      procedure Set_Flag30 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag30);

      procedure Set_Flag31 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag31);

      procedure Set_Flag32 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag32);

      procedure Set_Flag33 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag33);

      procedure Set_Flag34 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag34);

      procedure Set_Flag35 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag35);

      procedure Set_Flag36 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag36);

      procedure Set_Flag37 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag37);

      procedure Set_Flag38 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag38);

      procedure Set_Flag39 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag39);

      procedure Set_Flag40 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag40);

      procedure Set_Flag41 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag41);

      procedure Set_Flag42 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag42);

      procedure Set_Flag43 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag43);

      procedure Set_Flag44 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag44);

      procedure Set_Flag45 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag45);

      procedure Set_Flag46 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag46);

      procedure Set_Flag47 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag47);

      procedure Set_Flag48 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag48);

      procedure Set_Flag49 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag49);

      procedure Set_Flag50 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag50);

      procedure Set_Flag51 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag51);

      procedure Set_Flag52 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag52);

      procedure Set_Flag53 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag53);

      procedure Set_Flag54 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag54);

      procedure Set_Flag55 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag55);

      procedure Set_Flag56 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag56);

      procedure Set_Flag57 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag57);

      procedure Set_Flag58 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag58);

      procedure Set_Flag59 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag59);

      procedure Set_Flag60 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag60);

      procedure Set_Flag61 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag61);

      procedure Set_Flag62 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag62);

      procedure Set_Flag63 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag63);

      procedure Set_Flag64 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag64);

      --  The following versions of Set_Noden also set the parent
      --  pointer of the referenced node if it is non_Empty

      procedure Set_Node1_With_Parent (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node1);

      procedure Set_Node2_With_Parent (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node2);

      procedure Set_Node3_With_Parent (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node3);

      procedure Set_Node4_With_Parent (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node4);

      procedure Set_Node5_With_Parent (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node5);

      --  The following versions of Set_Listn also set the parent pointer of
      --  the referenced node if it is non_Empty. The procedures for List6
      --  to List12 can only be applied to nodes which have an extension.

      procedure Set_List1_With_Parent (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List1_With_Parent);

      procedure Set_List2_With_Parent (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List2_With_Parent);

      procedure Set_List3_With_Parent (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List3_With_Parent);

      procedure Set_List4_With_Parent (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List4_With_Parent);

      procedure Set_List5_With_Parent (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List5_With_Parent);

   end Unchecked_Access;

   -----------------------------
   -- Private Part Subpackage --
   -----------------------------

   --  The following package contains the definition of the data structure
   --  used by the implementation of the Atree package. Logically it really
   --  corresponds to the private part, hence the name. The reason that it
   --  is defined as a sub-package is to allow special access from clients
   --  that need to see the internals of the data structures.

   package Atree_Private_Part is

      -------------------------
      -- Tree Representation --
      -------------------------

      --  The nodes of the tree are stored in a table (i.e. an array). In the
      --  case of extended nodes three consecutive components in the array are
      --  used. There are thus two formats for array components. One is used
      --  for non-extended nodes, and for the first component of extended
      --  nodes. The other is used for the extension parts (second and third
      --  component) of an extended node. A variant record structure is used
      --  to distinguish the two formats.

      type Node_Record (Is_Extension : Boolean := False) is record

         --  Logically, the only field in the common part is the above
         --  Is_Extension discriminant (a single bit). However, Gigi cannot
         --  yet handle such a structure, so we fill out the common part of
         --  the record with fields that are used in different ways for
         --  normal nodes and node extensions.

         Pflag1, Pflag2 : Boolean;
         --  The Paren_Count field is represented using two boolean flags,
         --  where Pflag1 is worth 1, and Pflag2 is worth 2. This is done
         --  because we need to be easily able to reuse this field for
         --  extra flags in the extended node case.

         In_List : Boolean;
         --  Flag used to indicate if node is a member of a list.
         --  This field is considered private to the Atree package.

         Rewrite_Sub : Boolean;
         --  Flag set if this node was result of Rewrite_Substitute_Tree.
         --  This field is considered private to the Atree package.

         Rewrite_Ins : Boolean;
         --  Flag set by Mark_Rewrite_Insertion procedure.
         --  This field is considered private to the Atree package.

         Flag1  : Boolean;
         Flag2  : Boolean;
         Flag3  : Boolean;
         Flag4  : Boolean;
         Flag5  : Boolean;
         Flag6  : Boolean;
         Flag7  : Boolean;
         Flag8  : Boolean;
         Flag9  : Boolean;
         Flag10 : Boolean;
         Flag11 : Boolean;
         Flag12 : Boolean;
         Flag13 : Boolean;
         Flag14 : Boolean;
         Flag15 : Boolean;
         Flag16 : Boolean;
         Flag17 : Boolean;
         Flag18 : Boolean;
         --  The eighteen flags for a normal node

         --  The above fields are used as follows in a the two extra
         --  nodes of an extended nod entry:

         --    In_List     used as  Flag19, Flag40  in extension
         --    Rewrite_Sub used as  Flag20, Flag41  in extension
         --    Rewrite_Ins used as  Flag21, Flag42  in extension
         --    Flag1       used as  Flag22, Flag43  in extension
         --    Flag2       used as  Flag23, Flag44  in extension
         --    Flag3       used as  Flag24, Flag45  in extension
         --    Flag4       used as  Flag25, Flag46  in extension
         --    Flag5       used as  Flag26, Flag47  in extension
         --    Flag6       used as  Flag27, Flag48  in extension
         --    Flag7       used as  Flag28, Flag49  in extension
         --    Flag8       used as  Flag29, Flag50  in extension
         --    Flag9       used as  Flag30, Flag51  in extension
         --    Flag10      used as  Flag31, Flag52  in extension
         --    Flag11      used as  Flag32, Flag53  in extension
         --    Flag12      used as  Flag33, Flag54  in extension
         --    Flag13      used as  Flag34, Flag55  in extension
         --    Flag14      used as  Flag35, Flag56  in extension
         --    Flag15      used as  Flag36, Flag57  in extension
         --    Flag16      used as  Flag37, Flag58  in extension
         --    Flag17      used as  Flag38, Flag59  in extension
         --    Flag18      used as  Flag39, Flag60  in extension
         --    Pflag1      used as  Flag61, Flag62  in extension
         --    Pflag2      used as  Flag63, Flag64  in extension

         Nkind : Node_Kind;
         --  For a non-extended node, or the initial section of an extended
         --  node, this field holds the Node_Kind value. For an extended node,
         --  this field is used (by means of unchecked conversion) to hold
         --  the Ekind field of the entity.

         --  Now finally (on an 32-bit boundary!) comes the variant part

         case Is_Extension is

            --  Non-extended node, or first component of extended node

            when False =>

               Sloc : Source_Ptr;
               --  Source location for this node

               Link : Union_Id;
               --  This field is used either as the Parent pointer (if In_List
               --  is False), or as the list link pointer (if In_List is True)
               --  This field is considered private to the Atree package.

               Field1 : Union_Id;
               Field2 : Union_Id;
               Field3 : Union_Id;
               Field4 : Union_Id;
               Field5 : Union_Id;
               --  Five general use fields, which can contain Node_Id, List_Id,
               --  Elist_Id, String_Id, Name_Id, or Char_Code values depending
               --  on the values in Nkind and (for extended nodes), in Ekind.
               --  See packages Sinfo and Einfo for details of their use.

            --  Extension (second component) of extended node

            when True =>
               Field6  : Union_Id;
               Field7  : Union_Id;
               Field8  : Union_Id;
               Field9  : Union_Id;
               Field10 : Union_Id;
               Field11 : Union_Id;
               Field12 : Union_Id;
               --  Seven additional general fields available only for entities
               --  See package Einfo for details of their use (which depends
               --  on the value in the Ekind field). Field6-Field10 are used
               --  as Field13-Field17 in the third component. The remaining
               --  fields (Field11, Field12) are currently not used in the
               --  the third component.

         end case;
      end record;

      pragma Pack (Node_Record);
      for Node_Record'Size use 8*32;

      --  The following defines the extendible array used for the nodes table
      --  Nodes with extensions use two consecutive entries in the array

      package Nodes is new Table (
        Table_Component_Type => Node_Record,
        Table_Index_Type     => Node_Id,
        Table_Low_Bound      => First_Node_Id,
        Table_Initial        => Alloc_Nodes_Initial,
        Table_Increment      => Alloc_Nodes_Increment,
        Table_Name           => "Nodes");

   end Atree_Private_Part;

end Atree;
