/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                             A - A D A I N T                              */
/*                                                                          */
/*                            $Revision: 1.20 $                             */
/*                                                                          */
/*                          C Implementation File                           */
/*                                                                          */
/*           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/

/*  This file contains those routines named by "pragma interface_name"      */
/*  statements in the package unix_Library, which are not simply system     */
/*  or standard library calls.                                              */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "config.h"  /* this may define OS2 */

#ifndef O_BINARY
#define O_BINARY 0
#endif

/* Return nonzero if target operating system shares the MS-DOS conventions
   of line termination and switch character. */

int
Is_MS_DOS (void)
{
#if defined (MSDOS) || defined (OS2)
  return 1;
#else
  return 0;
#endif
}

int open_read(char *path)
{
    return open(path, O_RDONLY | O_BINARY);
}

int open_create(char *path)
{
    return open(path, O_WRONLY | O_CREAT | O_TRUNC,
                S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH);
}

long file_length(int fd)
{
    /* Return the number of bytes in the named file. */
    int ret;
    struct stat statbuf;

    ret = fstat(fd, &statbuf);
    if (ret || !S_ISREG(statbuf.st_mode)) return 0L;
    return (statbuf.st_size);
}

int is_regular_file (char *name)
{
  int ret;
  struct stat statbuf;

  ret = stat(name, &statbuf);
  return (!ret && S_ISREG(statbuf.st_mode));
}

void file_time (int fd, char *stamp)
{
    int ret;
    struct stat statbuf;
    char buf[13];

#ifndef OS2
    ret = fstat (fd, &statbuf);
    /* Not doing anything with errors here! */
    strftime (buf, 13, "%y%m%d%H%M%S", gmtime (&statbuf.st_mtime));
#else
    unsigned long Dos32QueryFileInfo () asm ("Dos32QueryFileInfo");

    typedef struct _FDATE {
	       unsigned short day   : 5;
	       unsigned short month : 4;
	       unsigned short year  : 7;
			  } FDATE;

    typedef struct _FTIME {
	       unsigned short twosecs : 5;
	       unsigned short minutes : 6;
	       unsigned short hours   : 5;
			  } FTIME;

    struct FILESTATUS {
	       FDATE fdateCreation;
	       FTIME ftimeCreation;
	       FDATE fdateLastAccess;
	       FTIME ftimeLastAccess;
	       FDATE fdateLastWrite;
	       FTIME ftimeLastWrite;
	       unsigned long cbFile;
	       unsigned long cbFileAlloc;
	       unsigned short attrFile;
		      } fs;

    ret = Dos32QueryFileInfo (fd, 1, (unsigned char *) &fs,
		 sizeof (struct FILESTATUS));

    sprintf (buf, "%2d%02d%02d%02d%02d%02d",
		fs.fdateLastWrite.year + 80,
		fs.fdateLastWrite.month,
		fs.fdateLastWrite.day,
		fs.ftimeLastWrite.hours,
		fs.ftimeLastWrite.minutes,
		fs.ftimeLastWrite.twosecs * 2);
#endif

    strncpy (stamp, buf, 12);
}

void
get_env_value_ptr (char *name, int *len, char **value)
{
  char * getenv (char *);
  *value = getenv (name);
  if (!*value)
    *len = 0;
  else
    *len = strlen (*value);
  return;
}
