#ifndef _FTAPE_IO_H
#define _FTAPE_IO_H

/*
 * Copyright (C) 1993,1994 Bas Laarhoven.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 $Source: /usr/src/distr/ftape-1.12/RCS/ftape-io.h,v $
 $Author: bas $
 *
 $Revision: 1.22 $
 $Date: 1994/05/26 23:43:45 $
 $State: Beta $
 *
 *      This file contains definitions for the glue part
 *      of the QIC-40/80 floppy-tape driver for Linux.
 */

struct error_info {
  int used;                     /* any reading or writing done */
  /* isr statistics */
  unsigned int id_am_errors;    /* id address mark not found */
  unsigned int id_crc_errors;   /* crc error in id address mark */
  unsigned int data_am_errors;  /* data address mark not found */
  unsigned int data_crc_errors; /* crc error in data field */
  unsigned int overrun_errors;  /* fdc access timing problem */
  unsigned int no_data_errors;  /* sector not found */
  unsigned int retries;         /* number of tape retries */
  /* ecc statistics */
  unsigned int crc_errors;      /* crc error in data */
  unsigned int crc_failures;    /* bad data without crc error */
  unsigned int ecc_failures;    /* failed to correct */
  unsigned int corrected;       /* total sectors corrected */
  /* general statistics */
  unsigned int rewinds;         /* number of tape rewinds */
};

/*
 *      ftape-io.c defined global vars.
 */
extern int ftape_failure;
extern int ftape_track;
extern int segments_per_track;
extern int segments_per_head;
extern int segments_per_cylinder;
extern int sectors_per_segment;
extern int tracks_per_tape;
extern int ftape_seg_pos;
extern int first_data_segment;
extern int ftape_state;
extern struct _fdt_id location;
extern int unknown_drive_config;
extern struct error_info history;
extern int write_protected;

/*
 *      ftape-io.c defined global functions.
 */
extern int ftape_command( int command);
extern int ftape_command_wait( int command, int timeout, int* status);
extern int ftape_report_drive_status( int *status);
extern int ftape_report_status( int* status);
extern int ftape_interrupt_wait( int time);
extern int _ftape_open( void);
extern int _ftape_close( void);
extern int _ftape_ioctl( unsigned int command, void * arg);
extern int ftape_ready_wait( int timeout, int* status);
extern int ftape_seek_head_to_track( int track);
extern void ftape_sleep( unsigned int time);
extern int ftape_parameter( int command);
extern int ftape_new_cartridge( void);
extern int ftape_abort_operation( int* location);
extern void ftape_reset_position( void);
extern void udelay( int usecs);
extern int udelay_calibrate( void);
extern int ftape_seek_to_bot( void);

#endif
