


CRYPT(3)               C LIBRARY FUNCTIONS               CRYPT(3)



NAME
     crypt, _crypt, setkey, encrypt - password and  data  encryp-
     tion

SYNOPSIS
     char *crypt(key, salt)
     char *key, *salt;

     char *_crypt(key, salt)
     char *key, *salt;

     setkey(key)
     char *key;

     encrypt(block, edflag)
     char *block;

DESCRIPTION
     crypt() is the password encryption routine, based on the NBS
     Data  Encryption  Standard,  with variations intended (among
     other things) to frustrate use of  hardware  implementations
     of the DES for key search.

     The first argument to crypt() is  normally  a  user's  typed
     password.   The  second  is a 2-character string chosen from
     the set [a-zA-Z0-9./].  Unless it starts with `##' or  `#$',
     the  _s_a_l_t string is used to perturb the DES algorithm in one
     of 4096 different ways, after which the password is used  as
     the  key  to  encrypt  repeatedly  a  constant  string.  The
     returned value points to the encrypted password, in the same
     alphabet as the salt.  The first two characters are the salt
     itself.

     If the _s_a_l_t string starts with `##', pwdauth(3)  is  called.
     If  _p_w_d_a_u_t_h  returns  TRUE, the salt is returned from crypt.
     Otherwise, NULL is returned.  If the _s_a_l_t string starts with
     `#$',  grpauth  (see  pwdauth(3))  is  called.   If  grpauth
     returns TRUE, the salt is returned from  crypt.   Otherwise,
     NULL  is  returned.   If there is a valid reason not to have
     this authentication happen, calling __c_r_y_p_t avoids  authenti-
     cation.

     The _s_e_t_k_e_y and _e_n_c_r_y_p_t entries  provide  (rather  primitive)
     access  to  the  DES algorithm.  The argument of _s_e_t_k_e_y is a
     character array of length 64 containing only the  characters
     with  numerical  value  0  and 1.  If this string is divided
     into groups of  8,  the  low-order  bit  in  each  group  is
     ignored;  this  gives  a  56-bit  key  which is set into the
     machine.  This is the key that will be used with  the  above
     mentioned  algorithm  to encrypt or decrypt the string _b_l_o_c_k
     with the function _e_n_c_r_y_p_t.




Sun Release 4.1    Last change: 6 October 1987                  1






CRYPT(3)               C LIBRARY FUNCTIONS               CRYPT(3)



     The argument to the _e_n_c_r_y_p_t entry is a  character  array  of
     length  64  containing  only  the  characters with numerical
     value 0 and 1.  The argument array is modified in place to a
     similar  array  representing  the bits of the argument after
     having been subjected to the DES algorithm using the key set
     by  _s_e_t_k_e_y. If _e_d_f_l_a_g is zero, the argument is encrypted; if
     non-zero, it is decrypted.

SEE ALSO
     login(1), passwd(1), getpass(3V), pwdauth(3), passwd(5)

BUGS
     The return value points to  static  data  whose  content  is
     overwritten by each call.









































Sun Release 4.1    Last change: 6 October 1987                  2



