<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Guide de rcriture des URLs - Serveur Apache HTTP</title>
<link href="/style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="/style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="/style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="/images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="/mod/">Modules</a> | <a href="/mod/directives.html">Directives</a> | <a href="/faq/">FAQ</a> | <a href="/glossary.html">Glossaire</a> | <a href="/sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="/images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="/images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="/">Version 2.3</a> &gt; <a href="./">Rewrite</a></div><div id="page-content"><div id="preamble"><h1>Guide de rcriture des URLs</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span></p>
</div>


    <p>Ce document complte la <a href="../mod/mod_rewrite.html">documentation de rfrence</a> du
    module <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code>. Il dcrit de quelle manire on
    peut utiliser le module Apache <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code> pour
    rsoudre les problmes typiques relatifs aux URLs auxquels les
    webmasters sont souvent confronts. La rsolution de chaque problme
    par la configuration des jeux de rgles de rcriture d'URLs fait
    l'objet d'une description dtaille.</p>

    <div class="warning">ATTENTION : l'adaptation des exemples  votre
    situation en fonction de la configuration de votre serveur pourra
    s'avrer ncessaire, par exemple l'ajout du drapeau
    <code>[PT]</code> si vous utilisez les modules
    <code class="module"><a href="/mod/mod_alias.html">mod_alias</a></code>, <code class="module"><a href="/mod/mod_userdir.html">mod_userdir</a></code>, etc... Un
    jeu de rgles dfini dans le contexte du serveur devra aussi tre
    adapt pour tre utilis dans un contexte <code>.htaccess</code>.
    Efforcez-vous toujours de bien comprendre l'effet produit par un jeu
    de rgles avant de l'utiliser, ce qui pourra vous viter bien des
    problmes.</div>

  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="/images/down.gif" /> <a href="#canonicalurl">URLs canoniques</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#canonicalhost">Noms d'htes canoniques</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#moveddocroot"><code>DocumentRoot</code>dplac</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#trailingslash">Problme du slash de fin</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#movehomedirs">Dplacement des rpertoires home vers un autre serveur</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#multipledirs">Recherche de pages dans plus d'un rpertoire</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#setenvvars">Dfinir des variables d'environnement en fonction de
      certaines parties de l'URL</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#uservhosts">Htes virtuels bass sur l'utilisateur</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#redirecthome">Redirection des rpertoires d'accueil pour les trangers</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#redirectanchors">Redirection des ancrages</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#time-dependent">Rcriture dpendant de l'heure</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#backward-compatibility">Compatibilit ascendante pour une migration de YYYY vers
      XXXX</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#old-to-new">De l'ancien au nouveau (en interne)</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#old-to-new-extern">De l'ancien au nouveau (en externe)</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#static-to-dynamic">De statique  dynamique</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#blocking-of-robots">Blocage des robots</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#blocked-inline-images">Blocage du rfrencement  chaud (Hotlinking) d'images</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#proxy-deny">Interdiction du mandataire</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#external-rewriting">Moteur de rcriture externe</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="../mod/mod_rewrite.html">Documentation du module</a></li><li><a href="intro.html">Introduction  mod_rewrite</a></li><li><a href="rewrite_guide_advanced.html">Guide de rcriture
avanc - exemples utiles avancs</a></li><li><a href="tech.html">Dtails techniques</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="canonicalurl" id="canonicalurl">URLs canoniques</a></h2>



<dl>
 <dt>Description :</dt>

   <dd>
     <p>Sur certains serveurs web, une ressource peut tre accessible
     depuis plusieurs URLs. On trouve en gnral des URLs canoniques
     (qui sont rellement utilisables et distribuables), mais aussi des
     URLs  usage interne, ou celles qui ne sont que des raccourcis,
     etc... On souhaite que, quelle que soit l'URL que l'utilisateur
     a fournie avec sa requte, il ne doit en voir en fin de compte
     que la forme canonique.</p>
   </dd>

   <dt>Solution :</dt>

     <dd>
       <p>On effectue une redirection HTTP externe pour toutes les URLs
       non canoniques afin de les rendre comprhensibles au navigateur
       et ceci pour toutes les requtes sous-jacentes. Dans l'exemple de
       jeux de rgles ci-dessous, <code>/~user</code> est remplac par
       l'expression canonique <code>/u/user</code>, et une ventuelle
       absence du slash  la fin de <code>/u/user</code> est corrige.</p>

<div class="example"><pre>
RewriteRule   ^/<strong>~</strong>([^/]+)/?(.*)    /<strong>u</strong>/$1/$2  [<strong>R</strong>]
RewriteRule   ^/u/(<strong>[^/]+</strong>)$  /$1/$2<strong>/</strong>   [<strong>R</strong>]
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="canonicalhost" id="canonicalhost">Noms d'htes canoniques</a></h2>

      <dl>
        <dt>Description :</dt>

        <dd>Le but de cette rgle est de prfrer l'utilisation d'un nom
	d'hte particulier par rapport  d'autres noms d'hte utilisables
	pour atteindre le mme site. Par exemple, si vous voulez
	utiliser <strong>www.example.com</strong>  la place de
	<strong>example.com</strong>, vous devez utiliser une solution
	de ce style.</dd>

        <dt>Solution :</dt>

        <dd>
<p>Pour les sites coutant sur un port autre que 80:</p>
<div class="example"><pre>
RewriteCond %{HTTP_HOST}   !^www\.exemple\.com [NC]
RewriteCond %{HTTP_HOST}   !^$
RewriteCond %{SERVER_PORT} !^80$
RewriteRule ^/?(.*)         http://www.example.com:%{SERVER_PORT}/$1
[L,R,NE]
</pre></div>

<p>Et pour un site coutant sur le port 80</p>
<div class="example"><pre>
RewriteCond %{HTTP_HOST}   !^www\.exemple\.com [NC]
RewriteCond %{HTTP_HOST}   !^$
RewriteRule ^/?(.*)         http://www.example.com/$1 [L,R,NE]
</pre></div>
	<p>
	Si vous souhaitez que cette rgle s'applique  tous les noms de
	domaine - en d'autres termes, si vous voulez rediriger
	<strong>example.com</strong> vers
	<strong>www.example.com</strong> pour toutes les valeurs
	possibles de <strong>example.com</strong>, vous pouvez utiliser
	le jeu de rgles suivants :</p>

<div class="example"><pre>
RewriteCond %{HTTP_HOST} !^www\. [NC]
RewriteCond %{HTTP_HOST} !^$
RewriteRule ^/?(.*) http://www.%{HTTP_HOST}/$1 [L,R,NE]
</pre></div>
	<p>
	Vous pouvez utiliser ce jeu de rgles aussi bien dans le fichier
	de configuration de votre serveur principal que dans un fichier
	<code>.htaccess</code> plac dans le rpertoire dfini par la
	directive <code class="directive"><a href="/mod/core.html#documentroot">DocumentRoot</a></code> du serveur.</p>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="moveddocroot" id="moveddocroot"><code>DocumentRoot</code>dplac</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
<p>En gnral, la directive <code class="directive"><a href="/mod/core.html#documentroot">DocumentRoot</a></code> correspond directement  l'URL
"<code>/</code>" du serveur web. Mais souvent, les donnes qui s'y
trouvent ne sont pas de la premire priorit. Par exemple, il peut tre
intressant, pour les visiteurs qui entrent sur le site pour la premire
fois, d'tre redirigs vers un sous-rpertoire particulier
<code>/a-propos-de/</code>. Pour ce faire, on peut utiliser le jeu de
rgles suivant :</p>
</dd>

        <dt>Solution :</dt>

        <dd>
          <p>On redirige l'URL <code>/</code> vers
          <code>/a-propos-de/</code>:
          </p>

<div class="example"><pre>
RewriteEngine on
RewriteRule   <strong>^/$</strong>  /a-propos-de/  [<strong>R</strong>]
</pre></div>

    <p>Notez que le mme effet peut tre obtenu  l'aide de la directive
    <code class="directive"><a href="/mod/mod_alias.html#redirectmatch">RedirectMatch</a></code> :</p>

<div class="example"><p><code>
RedirectMatch ^/$ http://example.com/apropos/
</code></p></div>
<p>Notez aussi que cet exemple ne rcrit que l'URL racine. En d'autres
termes, il rcrit une requte pour <code>http://example.com/</code>,
mais ne rcrira pas une requte pour
<code>http://example.com/page.html</code>. En fait, si vous avez modifi
la racine de vos documents - c'est  dire si tous vos contenus se
trouvent dans ce sous-rpertoire, il vaut mieux simplement modifier
votre directive <code class="directive"><a href="/mod/core.html#documentroot">DocumentRoot</a></code> que de
procder  une rcriture d'URLs.</p>
</dd>
</dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="trailingslash" id="trailingslash">Problme du slash de fin</a></h2>

      

      <dl>
        <dt>Description :</dt>

    <dd><p>La plupart des problmes de "slash de fin" peuvent tre
    rsolus grce aux techniques dcrites dans ce <a href="http://httpd.apache.org/docs/misc/FAQ-E.html#set-servername">sujet
    de la FAQ</a>. Cependant, dans certaines situations o l'absence de slash de fin
    peut rendre une URL inoprante, l'utilisation de
    mod_rewrite s'avre ncessaire. Le cas peut se prsenter, par exemple,
    aprs une srie complexe de rgles de rcriture.</p>
    </dd>

        <dt>Solution :</dt>

        <dd>
          <p>La solution  ce problme subtil consiste  laisser le
	  serveur ajouter le slash de fin automatiquement. Pour y
	  parvenir, il faut utiliser une redirection externe, afin que
	  le navigateur demande correctement les images sous-jacentes,
	  etc... Une rcriture en interne ne fonctionnerait que pour la
	  page du rpertoire, mais chouerait pour toute image incluse
	  dans cette page via des liens relatifs, car le navigateur
	  demanderait un objet insr. Par exemple, une requte pour
	  <code>image.gif</code> dans <code>/~quux/foo/index.html</code>
	  deviendrait <code>/~quux/image.gif</code> sans la redirection
	  externe !</p>

          <p>Pour y parvenir, on peut utiliser des rgles de ce style :</p>

<div class="example"><pre>
RewriteEngine  on
RewriteBase    /~quux/
RewriteRule    ^foo<strong>$</strong>  foo<strong>/</strong>  [<strong>R</strong>]
</pre></div>

   <p>Vous pouvez aussi ajouter ce qui suit dans un fichier
   <code>.htaccess</code> situ dans le rpertoire contenant la
   ressource. Notez cependant que cela augmente la charge du processeur.</p>

<div class="example"><pre>
RewriteEngine  on
RewriteBase    /~quux/
RewriteCond    %{REQUEST_FILENAME}  <strong>-d</strong>
RewriteRule    ^(.+<strong>[^/]</strong>)$           $1<strong>/</strong>  [R]
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="movehomedirs" id="movehomedirs">Dplacement des rpertoires home vers un autre serveur</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>De nombreux webmasters ont demand comment rsoudre le
	  problme suivant : ils voudraient tout simplement rediriger
	  les rpertoires home d'un serveur web vers un autre serveur
	  web. Cette situation se prsente en gnral lorsqu'on installe
	  un nouveau serveur web destin  terme  en remplacer un autre
	  plus ancien.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Avec <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code>, la solution est
	  vidente. Sur l'ancien serveur web, on redirige simplement
	  toutes les URLs du style <code>/~user/chemin</code> vers
	  <code>http://nouveau-serveur/~user/chemin</code>.</p>

<div class="example"><pre>
RewriteEngine on
RewriteRule   ^/~(.+)  http://<strong>nouveau-serveur</strong>/~$1  [R,L]
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="multipledirs" id="multipledirs">Recherche de pages dans plus d'un rpertoire</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Le serveur web doit parfois rechercher des pages dans plus
	  d'un rpertoire. Dans ce cas, les vues multiples ou autres
	  techniques similaires ne sont d'aucun secours.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On dfinit explicitement un jeu de rgles qui recherche les
	  fichiers dans les rpertoires.</p>

<div class="example"><pre>
RewriteEngine on

#   on cherche tout d'abord dans dir1/...
#   ... et si on trouve, on est content et on arrte :
RewriteCond         %{DOCUMENT_ROOT}/<strong>dir1</strong>/%{REQUEST_URI}  -f
RewriteRule  ^(.+)  %{DOCUMENT_ROOT}/<strong>dir1</strong>/$1  [L]

#   on cherche ensuite dans dir2/...
#   ... et si on trouve, on est content et on arrte :
RewriteCond         %{DOCUMENT_ROOT}/<strong>dir2</strong>/%{REQUEST_URI}  -f
RewriteRule  ^(.+)  %{DOCUMENT_ROOT}/<strong>dir2</strong>/$1  [L]

#   sinon, on continue la recherche avec d'autres directives Alias
#   ou ScriptAlias, etc...
RewriteRule   ^(.+)  -  [PT]
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="setenvvars" id="setenvvars">Dfinir des variables d'environnement en fonction de
      certaines parties de l'URL</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Comment conserver des informations
	  d'tat d'une requte  l'autre et utiliser l'URL pour les
	  encoder, sans utiliser d'encapsulateur CGI
	  pour toutes les pages pour seulement supprimer ces
	  informations.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On utilise une rgle de rcriture pour supprimer
	  l'information d'tat et l'enregistrer dans une variable
	  d'environnement dont on pourra plus tard extraire la valeur
	  dans XSSI ou CGI. De cette faon, une URL telle que
	  <code>/foo/S=java/bar/</code> sera traduite en
	  <code>/foo/bar/</code> et la variable d'environnement
	  <code>STATUS</code> aura pour valeur "java".</p>

<div class="example"><pre>
RewriteEngine on
RewriteRule   ^(.*)/<strong>S=([^/]+)</strong>/(.*)    $1/$3 [E=<strong>STATUS:$2</strong>]
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="uservhosts" id="uservhosts">Htes virtuels bass sur l'utilisateur</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Supposons que vous vouliez atteindre la page d'accueil des
	  utilisateurs sur une mme machine au moyen de l'URL
	  <code>www.<strong>nom-utilisateur</strong>.hte.domaine.com</code>,
	  en vous basant
	  seulement sur les enregistrements DNS de type A, et ceci sans qu'aucun
	  hte virtuel ne soit install sur cette machine.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Dans le cas des requtes HTTP/1.0, il n'y a pas de solution
	  ; par contre, avec une requte HTTP/1.1 qui contient un
	  en-tte HTTP Host:, on peut utiliser le jeu de rgles suivant
	  pour rcrire en interne
	  <code>http://www.nom-utilisateur.hte.com/chemin</code> vers
	  <code>/home/nom-utilisateur/chemin</code> :</p>

<div class="example"><pre>
RewriteEngine on
RewriteCond   %{<strong>HTTP_HOST</strong>}                 ^www\.<strong>([^.]+)</strong>\.host\.com$
RewriteRule   ^(.*) /home/<strong>%1</strong>$1
</pre></div>
<p>Les parenthses utilises dans une directive <code class="directive"><a href="/mod/mod_rewrite.html#rewritecond">RewriteCond</a></code> sont captures dans les
rfrences arrires <code>%1</code>, <code>%2</code>, etc..., alors que
les parenthses utilises dans une directive <code class="directive"><a href="/mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> sont captures dans les
rfrences arrires <code>$1</code>, <code>$2</code>, etc...</p>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="redirecthome" id="redirecthome">Redirection des rpertoires d'accueil pour les trangers</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>On veut rediriger les URLs des rpertoires d'accueil vers
	  un autre serveur <code>www.quelque-part.com</code> lorsque
	  l'utilisateur demandeur n'appartient pas au domaine local
	  <code>notre-domaine.com</code>. On rencontre parfois cette
	  situation dans un contexte d'htes virtuels.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Juste une condition de rcriture :</p>

<div class="example"><pre>
RewriteEngine on
RewriteCond   %{REMOTE_HOST}  <strong>!^.+\.notre-domaine\.com$</strong>
RewriteRule   ^(/~.+)         http://www.quelque-part.com/$1 [R,L]
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="redirectanchors" id="redirectanchors">Redirection des ancrages</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
        <p>Par dfaut, la redirection vers un ancrage HTML ne fonctionne
	pas, car mod_rewrite chappe le caractre <code>#</code> en le
	transformant en <code>%23</code>, ce qui rend la redirection
	inoprante.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On utilise le drapeau <code>[NE]</code> dans la rgle
	  <code>RewriteRule</code>. NE signifie "No Escape".
          </p>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="time-dependent" id="time-dependent">Rcriture dpendant de l'heure</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Lorsqu'il s'agit de distribuer des contenus dont la nature
	  dpend de l'heure, de nombreux webmasters utilisent encore des
	  scripts CGI qui redirigent par exemple vers des pages
	  spcifiques. Comment peut-on y parvenir  tenir compte de
	  l'heure  l'aide de <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code> ?</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Il existe de nombreuses variables nommes
	  <code>TIME_xxx</code> utilisables dans les conditions de
	  rcriture. Utilises en conjonction avec les modles de
	  comparaison lexicographique spciaux <code>&lt;STRING</code>,
	  <code>&gt;STRING</code> et <code>=STRING</code>, elles
	  permettent d'effectuer des redirections dpendant de
	  l'heure :</p>

<div class="example"><pre>
RewriteEngine on
RewriteCond   %{TIME_HOUR}%{TIME_MIN} &gt;0700
RewriteCond   %{TIME_HOUR}%{TIME_MIN} &lt;1900
RewriteRule   ^foo\.html$             foo.jour.html
RewriteRule   ^foo\.html$             foo.nuit.html
</pre></div>

          <p>Avec cet exemple, l'URL <code>foo.html</code> renvoie
	  le contenu de <code>foo.jour.html</code> durant le
	  crneau horaire <code>07:00-19:00</code>, et le contenu de
	  <code>foo.nuit.html</code> le reste du temps. Agrable
	  fonctionnalit pour une page d'accueil...</p>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="backward-compatibility" id="backward-compatibility">Compatibilit ascendante pour une migration de YYYY vers
      XXXX</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Comment confrer une compatibilit ascendante aux URLs
	  (existant encore virtuellement) aprs avoir migr
	  <code>document.YYYY</code> vers <code>document.XXXX</code>,
	  c'est  dire aprs avoir par exemple traduit un lot de
	  fichiers <code>.html</code> en fichiers <code>.phtml</code>
	  ?</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On rcrit simplement le nom du fichier en son nom
	  de base et vrifie s'il existe aussi avec la nouvelle
	  extension. Si c'est le cas, on utilise ce nom, sinon on
	  rcrit l'URL sous sa forme originale.</p>


<div class="example"><pre>
#   jeu de rgles assurant une compatibilit ascendante en rcrivant
#   document.html en document.phtml si et seulement si document.phtml
#   existe et document.html n'existe plus
RewriteEngine on
RewriteBase   /~quux/
#   rcriture du fichier en son nom de base,
#   mais garde en mmoire le fait qu'il s'agit
#   d'un fichier html
RewriteRule   ^(.*)\.html$              $1      [C,E=WasHTML:yes]
#   rcrit vers document.phtml s'il existe
#   Note : il s'agit d'un exemple de niveau rpertoire, si bien que
#   %{REQUEST_FILENAME} contient le chemin complet du systme de fichier
#   tel qu'il a t construit par le serveur.
RewriteCond   %{REQUEST_FILENAME}.phtml -f
RewriteRule   ^(.*)$ $1.phtml                   [S=1]
#   sinon, restauration du nom de fichier complet original
RewriteCond   %{ENV:WasHTML}            ^yes$
RewriteRule   ^(.*)$ $1.html
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="old-to-new" id="old-to-new">De l'ancien au nouveau (en interne)</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Supposons que nous ayons rcemment renomm la page
	  <code>foo.html</code> en <code>bar.html</code>, et voulions
	  maintenant que l'ancienne URL soit toujours valide  des fins
	  de compatibilit ascendante. En fait, on voudrait que le
	  changement de nom soit transparent aux utilisateurs de
	  l'ancienne URL.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On rcrit l'ancienne URL en interne vers la nouvelle via
	  la rgle suivante :</p>

<div class="example"><pre>
RewriteEngine  on
RewriteBase    /~quux/
RewriteRule    ^<strong>foo</strong>\.html$  <strong>bar</strong>.html
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="old-to-new-extern" id="old-to-new-extern">De l'ancien au nouveau (en externe)</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Supposons toujours que nous ayons rcemment renomm la page
	  <code>foo.html</code> en <code>bar.html</code>, et voulions
	  maintenant que l'ancienne URL soit toujours valide  des fins
	  de compatibilit ascendante. Par contre, nous voulons cette
	  fois que les utilisateurs de l'ancienne URL soient redirigs
	  vers la nouvelle, c'est  dire que l'adresse tape
	  dans leur navigateur doit aussi tre modifie.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On force une redirection HTTP vers la nouvelle URL, ce qui
	  entrane une modification de celle du navigateur et aussi de ce
	  que voit l'utilisateur :</p>

<div class="example"><pre>
RewriteEngine  on
RewriteBase    /~quux/
RewriteRule    ^<strong>foo</strong>\.html$  <strong>bar</strong>.html  [<strong>R</strong>]
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="static-to-dynamic" id="static-to-dynamic">De statique  dynamique</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Comment transformer une page statique <code>foo.html</code>
	  en sa variante dynamique <code>foo.cgi</code> de manire
	  transparente, c'est  dire sans en avertir le
	  navigateur/utilisateur.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On rcrit simplement l'URL en script CGI et force le
	  gestionnaire de contenu  <strong>cgi-script</strong> de faon
	   ce que le script s'excute en tant que programme CGI.
	  Ainsi, une requte vers <code>/~quux/foo.html</code> conduit
	  en interne  l'invocation de
	  <code>/~quux/foo.cgi</code>.</p>

<div class="example"><pre>
RewriteEngine  on
RewriteBase    /~quux/
RewriteRule    ^foo\.<strong>html</strong>$  foo.<strong>cgi</strong>  [H=<strong>cgi-script</strong>]
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="blocking-of-robots" id="blocking-of-robots">Blocage des robots</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Comment empcher un robot vraiment gnant de collecter les
	  pages d'une partie spcifique du site web ? Un fichier
	  <code>/robots.txt</code> comportant les entres du "Protocole
	  d'Exclusion des Robots" ne suffit gnralement pas  en venir
	   bout.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On utilise un jeu de rgles qui interdit les URLs de la
	  partie du site web concerne <code>/~quux/foo/arc/</code>
	  (peut-tre une partie du serveur avec une arborescence trs
	  dveloppe  travers laquelle le parcours du
	  robot induirait une charge importante pour le serveur). Nous
	  devons nous assurer de n'interdire l'accs qu' ce robot
	  particulier, c'est  dire qu'il ne suffit pas d'interdire
	  l'accs  l'hte sur lequel le robot fonctionne, ce qui
	  bloquerait aussi les utilisateurs de cet hte. Pour y
	  parvenir, on tient aussi compte des informations contenues
	  dans l'en-tte HTTP User-Agent.</p>

<div class="example"><pre>
RewriteCond %{HTTP_USER_AGENT}   ^<strong>NameOfBadRobot</strong>.*
RewriteCond %{REMOTE_ADDR}       ^<strong>123\.45\.67\.[8-9]</strong>$
RewriteRule ^<strong>/~quux/foo/arc/</strong>.+   -   [<strong>F</strong>]
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="blocked-inline-images" id="blocked-inline-images">Blocage du rfrencement  chaud (Hotlinking) d'images</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Cette technique vous permet d'interdire  d'autres sites
	  d'inclure directement vos images dans leurs pages. On fait
	  souvent rfrence  cette pratique sous le nom de
	  rfrencement  chaud (Hotlinking) qui entrane l'utilisation
	  de votre bande passante pour servir des contenus faisant
	  partie du site de quelqu'un d'autre.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
	<p>Cette technique repose sur la valeur de la variable
	optionnelle <code>HTTP_REFERER</code>. Certaines personnes
	pourront donc contourner cette limitation. Pour la plupart des
	utilisateurs cependant, la requte chouera, en ce sens que
	l'image ne sera pas affiche depuis le site tiers.</p>
	<p>Il y a plusieurs manires de grer cette situation.</p>

	<p>Dans le premier exemple, nous rejetons tout simplement la
	requte si elle ne provenait pas d'une page appartenant  notre
	site. Pour les besoins de cet exemple, nous supposons que le nom
	de votre site est <code>www.example.com</code>.</p>

<div class="example"><pre>
RewriteCond %{HTTP_REFERER} <strong>!^$</strong>
RewriteCond %{HTTP_REFERER} !www.example.com [NC]
RewriteRule <strong>\.(gif|jpg|png)$</strong>    -   [F,NC]
</pre></div>

	<p>Dans le second exemple, plutt que de rejeter la requte,
	nous affichons une autre image  la place.</p>

<div class="example"><pre>
RewriteCond %{HTTP_REFERER} <strong>!^$</strong>
RewriteCond %{HTTP_REFERER} !www.example.com [NC]
RewriteRule <strong>\.(gif|jpg|png)$</strong>    /images/go-away.png   [R,NC]
</pre></div>

	<p>Dans le troisime exemple, nous redirigeons la requte vers
	une image appartenant  un site tiers.</p>


<div class="example"><pre>
RewriteCond %{HTTP_REFERER} <strong>!^$</strong>
RewriteCond %{HTTP_REFERER} !www.example.com [NC]
RewriteRule <strong>\.(gif|jpg|png)$</strong> http://other.site.com/image.gif   [R,NC]
</pre></div>
	<p>De tous ces exemples, les deux derniers semblent les plus
	efficaces pour faire en sorte que les gens arrtent de
	rfrencer vos images  chaud, car il ne verront pas les images
	qu'ils s'attendent  voir.</p>

        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="proxy-deny" id="proxy-deny">Interdiction du mandataire</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Comment interdire l'utilisation du mandataire d'Apache  un
	  certain hte, ou mme  un utilisateur d'un certain hte ?</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Nous devons tout d'abord nous assurer que
	  <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code> se situe en dessous (!) de
	  <code class="module"><a href="/mod/mod_proxy.html">mod_proxy</a></code> dans le fichier de configuration
	  lors de la compilation du serveur web Apache. De cette faon,
	  il est appel <em>avant</em> <code class="module"><a href="/mod/mod_proxy.html">mod_proxy</a></code>. Nous
	  pouvons alors utiliser la rgle suivante pour une interdiction
	  concernant un hte...</p>

<div class="example"><pre>
RewriteCond %{REMOTE_HOST} <strong>^mauvais-hte\.mon-domaine\.com$</strong>
RewriteRule !^http://[^/.]\.mon-domaine.com.*  - [F]
</pre></div>

          <p>...et celle-ci pour une interdiction concernant un
	  utilisateur d'un certain hte :</p>

<div class="example"><pre>
RewriteCond %{REMOTE_IDENT}@%{REMOTE_HOST}
<strong>^mauvais-sujet@mauvais-hte\.mon-domaine\.com$</strong>
RewriteRule !^http://[^/.]\.mon-domaine.com.*  - [F]
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="external-rewriting" id="external-rewriting">Moteur de rcriture externe</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Une question de la Faq : comment rsoudre le problme
	  FOO/BAR/QUUX/etc. ? <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code> ne semble pas
	  devoir y apporter de solution...</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Utiliser une <code class="directive"><a href="/mod/mod_rewrite.html#rewritemap">RewriteMap</a></code> ou table de rcriture externe, c'est
	   dire un programme qui agit de la mme faon qu'une
	  <code class="directive"><a href="/mod/mod_rewrite.html#rewritemap">RewriteMap</a></code>. Il
	  doit tre lanc une fois au dmarrage d'Apache, recevoir les
	  URLs des requtes sur <code>STDIN</code>, et restituer l'URL
	  rsultante (en gnral rcrite) sur <code>STDOUT</code> (dans
	  cet ordre !).</p>

<div class="example"><pre>
RewriteEngine on
RewriteMap    quux-table       <strong>prg:</strong>/chemin/vers/table.quux.pl
RewriteRule   ^/~quux/(.*)$  /~quux/<strong>${quux-table:$1}</strong>
</pre></div>

<div class="example"><pre>
#!/chemin/vers/perl

#   dsactive la mise en tampon des entres/sorties, qui risque
#   de provoquer des bouclages infinis pour le serveur Apache
$| = 1;

#   lit les URLs (une par ligne) depuis stdin et
#   gnre l'URL transforme sur stdout

#   read URLs one per line from stdin and
#   generate substitution URL on stdout
while (&lt;&gt;) {
    s|^foo/|bar/|;
    print $_;
}
</pre></div>

          <p>Ceci n'est qu'un exemple de dmonstration qui ne fait que
	  rcrire les URLs du style <code>/~quux/foo/...</code> vers
	  <code>/~quux/bar/...</code>. En fait, vous pouvez programmer
	  la substitution que vous voulez. Notez cependant que si de
	  tels programmes peuvent aussi tre <strong>utiliss</strong>
	  par un utilisateur standard, seul l'administrateur du systme
	  peut les <strong>crire</strong>.</p>
        </dd>
      </dl>

    </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span></p>
</div><div id="footer">
<p class="apache">Copyright 2010 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="/mod/">Modules</a> | <a href="/mod/directives.html">Directives</a> | <a href="/faq/">FAQ</a> | <a href="/glossary.html">Glossaire</a> | <a href="/sitemap.html">Plan du site</a></p></div>
</body></html>