/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.kde.kjas.server.KIOConnection;
import org.kde.kjas.server.KJASAppletContext;
import org.kde.kjas.server.KJASAppletStub;
import org.kde.kjas.server.KJASSecurityManager;
import org.kde.kjas.server.Main;

public class KJASProtocolHandler {
    private static final int CreateContextCode = 1;
    private static final int DestroyContextCode = 2;
    private static final int CreateAppletCode = 3;
    private static final int DestroyAppletCode = 4;
    private static final int StartAppletCode = 5;
    private static final int StopAppletCode = 6;
    private static final int InitAppletCode = 7;
    private static final int ShowDocumentCode = 8;
    private static final int ShowURLInFrameCode = 9;
    private static final int ShowStatusCode = 10;
    private static final int ResizeAppletCode = 11;
    private static final int GetURLDataCode = 12;
    private static final int URLDataCode = 13;
    private static final int ShutdownServerCode = 14;
    private static final int JavaScriptEvent = 15;
    static final int GetMember = 16;
    static final int CallMember = 17;
    private static final int PutMember = 18;
    private static final int DerefObject = 19;
    private static final int AudioClipPlayCode = 20;
    private static final int AudioClipLoopCode = 21;
    private static final int AudioClipStopCode = 22;
    private static final int AppletStateNotificationCode = 23;
    private static final int AppletFailedCode = 24;
    private static final int DataCommand = 25;
    private static final int PutURLDataCode = 26;
    private static final int PutDataCode = 27;
    private static final int SecurityConfirmCode = 28;
    private static final int ShowConsole = 29;
    private Hashtable contexts;
    private PushbackInputStream commands;
    private PrintStream signals;
    private int cmd_index;
    private static final char sep = '\u0000';

    public KJASProtocolHandler(InputStream inputStream, OutputStream outputStream) {
        this.commands = new PushbackInputStream(inputStream);
        this.signals = new PrintStream(outputStream);
        this.contexts = new Hashtable();
    }

    /*
     * Unable to fully structure code
     */
    public void commandLoop() {
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                try {
                    while (true) {
                        var1_1 = this.readPaddedLength(8);
                        Main.debug("PH: cmd_length = " + var1_1);
                        var2_6 = new byte[var1_1];
                        for (var3_7 = 0; var3_7 < var1_1; var3_7 += var4_8) {
                            var4_8 = this.commands.read(var2_6, var3_7, var1_1 - var3_7);
                            Main.debug("PH: read in " + var4_8 + " bytes for command");
                        }
                        this.processCommand(var2_6);
                    }
                }
                catch (NumberFormatException var1_2) {
                    Main.kjas_err("Could not parse out message length", var1_2);
                    var1_2.printStackTrace();
                    System.exit(1);
                }
                catch (Throwable var1_3) {
                    Main.debug("commandLoop caught a throwable, still going");
                    var1_3.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (Exception var1_4) {
            Main.kjas_err("commandLoop exited on exception: ", var1_4);
            var1_4.printStackTrace();
            System.exit(1);
            return;
        }
        ** GOTO lbl-1000
    }

    public void processCommand(byte[] byArray) {
        byte by;
        if (byArray == null) {
            return;
        }
        int n = byArray.length;
        this.cmd_index = 0;
        if ((by = byArray[this.cmd_index++]) == 1) {
            String string = this.getArg(byArray);
            Main.debug("createContext, id = " + string);
            KJASAppletContext kJASAppletContext = new KJASAppletContext(string);
            this.contexts.put(string, kJASAppletContext);
        } else if (by == 2) {
            String string = this.getArg(byArray);
            Main.debug("destroyContext, id = " + string);
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (this.contexts != null) {
                kJASAppletContext.destroy();
                this.contexts.remove(string);
            }
        } else if (by == 3) {
            String string = this.getArg(byArray);
            String string2 = this.getArg(byArray);
            String string3 = this.getArg(byArray);
            String string4 = this.getArg(byArray);
            String string5 = this.getArg(byArray);
            String string6 = this.getArg(byArray);
            String string7 = this.getArg(byArray);
            String string8 = this.getArg(byArray);
            String string9 = this.getArg(byArray);
            String string10 = this.getArg(byArray);
            String string11 = this.getArg(byArray);
            String string12 = this.getArg(byArray);
            String string13 = this.getArg(byArray);
            String string14 = this.getArg(byArray);
            int n2 = Integer.parseInt(string14.trim());
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (int i = 0; i < n2; ++i) {
                String string15;
                String string16 = this.getArg(byArray);
                if (string16 == null) {
                    string16 = new String();
                }
                if ((string15 = this.getArg(byArray)) == null) {
                    string15 = new String();
                }
                hashtable.put(string16, string15);
            }
            Main.debug("createApplet, context = " + string + ", applet = " + string2);
            Main.debug("              name = " + string3 + ", classname = " + string4);
            Main.debug("              baseURL = " + string5 + ", codeBase = " + string9);
            Main.debug("              archives = " + string10 + ", width = " + string11 + ", height = " + string12);
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext != null) {
                kJASAppletContext.createApplet(string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, hashtable);
            }
        } else if (by == 4) {
            String string = this.getArg(byArray);
            String string17 = this.getArg(byArray);
            Main.debug("destroyApplet, context = " + string + ", applet = " + string17);
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext != null) {
                kJASAppletContext.destroyApplet(string17);
            }
        } else if (by == 5) {
            String string = this.getArg(byArray);
            String string18 = this.getArg(byArray);
            Main.debug("startApplet, context = " + string + ", applet = " + string18);
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext != null) {
                kJASAppletContext.startApplet(string18);
            }
        } else if (by == 6) {
            String string = this.getArg(byArray);
            String string19 = this.getArg(byArray);
            Main.debug("stopApplet, context = " + string + ", applet = " + string19);
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext != null) {
                kJASAppletContext.stopApplet(string19);
            }
        } else if (by == 14) {
            Main.debug("shutDownServer received");
            KJASAppletStub.waitForAppletThreads();
            System.exit(1);
        } else if (by == 13) {
            String string = this.getArg(byArray);
            String string20 = this.getArg(byArray);
            Main.debug("KIO URLData received(" + string + ") code:" + string20);
            byte[] byArray2 = null;
            if (n - this.cmd_index > 0) {
                byArray2 = new byte[n - this.cmd_index];
                System.arraycopy(byArray, this.cmd_index, byArray2, 0, byArray2.length);
            }
            KIOConnection.setData(string, Integer.parseInt(string20), byArray2);
        } else if (by == 16) {
            int n3 = Integer.parseInt(this.getArg(byArray));
            String string = this.getArg(byArray);
            String string21 = this.getArg(byArray);
            int n4 = Integer.parseInt(this.getArg(byArray));
            String string22 = this.getArg(byArray);
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext == null || !kJASAppletContext.getMember(string21, n3, n4, string22)) {
                this.sendMemberValue(string, 16, n3, -1, 0, "");
            }
        } else if (by == 18) {
            int n5 = Integer.parseInt(this.getArg(byArray));
            String string = this.getArg(byArray);
            String string23 = this.getArg(byArray);
            int n6 = Integer.parseInt(this.getArg(byArray));
            String string24 = this.getArg(byArray);
            String string25 = this.getArg(byArray);
            boolean bl = false;
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext == null || !kJASAppletContext.putMember(string23, n5, n6, string24, string25)) {
                this.sendPutMember(string, n5, false);
            }
        } else if (by == 17) {
            Object object;
            int n7 = Integer.parseInt(this.getArg(byArray));
            String string = this.getArg(byArray);
            String string26 = this.getArg(byArray);
            int n8 = Integer.parseInt(this.getArg(byArray));
            String string27 = this.getArg(byArray);
            Vector<String> vector = new Vector<String>();
            try {
                object = this.getArg(byArray);
                while (object != null) {
                    vector.add((String)object);
                    object = this.getArg(byArray);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((object = (KJASAppletContext)this.contexts.get(string)) == null || !((KJASAppletContext)object).callMember(string26, n7, n8, string27, vector)) {
                Main.protocol.sendMemberValue(string, 17, n7, -1, 0, "");
            }
        } else if (by == 19) {
            String string = this.getArg(byArray);
            String string28 = this.getArg(byArray);
            String string29 = this.getArg(byArray);
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext != null) {
                kJASAppletContext.derefObject(string28, Integer.parseInt(string29));
            }
            Main.debug("DerefObject " + string29);
        } else if (by == 28) {
            String string = this.getArg(byArray);
            String string30 = this.getArg(byArray);
            Thread thread = (Thread)KJASSecurityManager.confirmRequests.get(string);
            Main.debug("SecurityConfirmCode " + string + " confirm:" + string30);
            if (thread != null) {
                KJASSecurityManager.confirmRequests.put(string, string30);
                try {
                    thread.interrupt();
                }
                catch (SecurityException securityException) {}
            }
        } else if (by == 29) {
            Main.console.setVisible(true);
        } else {
            throw new IllegalArgumentException("Unknown command code");
        }
    }

    public void sendGetURLDataCmd(String string, String string2) {
        Main.debug("sendGetURLCmd(" + string + ") url = " + string2);
        byte[] byArray = string2.getBytes();
        int n = string.length() + byArray.length + 4;
        byte[] byArray2 = new byte[n + 8];
        byte[] byArray3 = this.getPaddedLengthBytes(n);
        int n2 = 0;
        System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
        n2 += byArray3.length;
        byArray2[n2++] = 12;
        byArray2[n2++] = 0;
        byArray3 = string.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
        n2 += byArray3.length;
        byArray2[n2++] = 0;
        System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
        n2 += byArray.length;
        byArray2[n2++] = 0;
        this.signals.write(byArray2, 0, byArray2.length);
    }

    public void sendDataCmd(String string, int n) {
        Main.debug("sendDataCmd(" + string + ") command = " + n);
        byte[] byArray = String.valueOf(n).getBytes();
        int n2 = string.length() + byArray.length + 4;
        byte[] byArray2 = new byte[n2 + 8];
        byte[] byArray3 = this.getPaddedLengthBytes(n2);
        int n3 = 0;
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        n3 += byArray3.length;
        byArray2[n3++] = 25;
        byArray2[n3++] = 0;
        byArray3 = string.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        n3 += byArray3.length;
        byArray2[n3++] = 0;
        System.arraycopy(byArray, 0, byArray2, n3, byArray.length);
        n3 += byArray.length;
        byArray2[n3++] = 0;
        this.signals.write(byArray2, 0, byArray2.length);
    }

    public void sendPutURLDataCmd(String string, String string2) {
        Main.debug("sendPutURLCmd(" + string + ") url = " + string2);
        byte[] byArray = string2.getBytes();
        int n = string.length() + byArray.length + 4;
        byte[] byArray2 = new byte[n + 8];
        byte[] byArray3 = this.getPaddedLengthBytes(n);
        int n2 = 0;
        System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
        n2 += byArray3.length;
        byArray2[n2++] = 26;
        byArray2[n2++] = 0;
        byArray3 = string.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
        n2 += byArray3.length;
        byArray2[n2++] = 0;
        System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
        n2 += byArray.length;
        byArray2[n2++] = 0;
        this.signals.write(byArray2, 0, byArray2.length);
    }

    public void sendPutData(String string, byte[] byArray, int n, int n2) {
        Main.debug("sendPutData(" + string + ") len = " + n2);
        int n3 = string.length() + n2 + 4;
        byte[] byArray2 = new byte[n3 + 8];
        byte[] byArray3 = this.getPaddedLengthBytes(n3);
        int n4 = 0;
        System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
        n4 += byArray3.length;
        byArray2[n4++] = 27;
        byArray2[n4++] = 0;
        byArray3 = string.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
        n4 += byArray3.length;
        byArray2[n4++] = 0;
        System.arraycopy(byArray, n, byArray2, n4, n2);
        n4 += n2;
        byArray2[n4++] = 0;
        this.signals.write(byArray2, 0, byArray2.length);
    }

    public void sendAppletStateNotification(String string, String string2, int n) {
        Main.debug("sendAppletStateNotification, contextID = " + string + ", appletID = " + string2 + ", state=" + n);
        byte[] byArray = String.valueOf(n).getBytes();
        int n2 = string.length() + string2.length() + byArray.length + 5;
        byte[] byArray2 = new byte[n2 + 8];
        byte[] byArray3 = this.getPaddedLengthBytes(n2);
        int n3 = 0;
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        n3 += byArray3.length;
        byArray2[n3++] = 23;
        byArray2[n3++] = 0;
        byArray3 = string.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        n3 += byArray3.length;
        byArray2[n3++] = 0;
        byArray3 = string2.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        n3 += byArray3.length;
        byArray2[n3++] = 0;
        System.arraycopy(byArray, 0, byArray2, n3, byArray.length);
        n3 += byArray.length;
        byArray2[n3++] = 0;
        this.signals.write(byArray2, 0, byArray2.length);
    }

    public void sendAppletFailed(String string, String string2, String string3) {
        Main.debug("sendAppletFailed, contextID = " + string + ", appletID = " + string2 + ", errorMessage=" + string3);
        byte[] byArray = string3.getBytes();
        int n = string.length() + string2.length() + byArray.length + 5;
        byte[] byArray2 = new byte[n + 8];
        byte[] byArray3 = this.getPaddedLengthBytes(n);
        int n2 = 0;
        System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
        n2 += byArray3.length;
        byArray2[n2++] = 24;
        byArray2[n2++] = 0;
        byArray3 = string.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
        n2 += byArray3.length;
        byArray2[n2++] = 0;
        byArray3 = string2.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
        n2 += byArray3.length;
        byArray2[n2++] = 0;
        System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
        n2 += byArray.length;
        byArray2[n2++] = 0;
        this.signals.write(byArray2, 0, byArray2.length);
    }

    public void sendShowDocumentCmd(String string, String string2) {
        Main.debug("sendShowDocumentCmd from context#" + string + " url = " + string2);
        byte[] byArray = string2.getBytes();
        byte[] byArray2 = string.getBytes();
        int n = byArray2.length + byArray.length + 4;
        byte[] byArray3 = new byte[n + 8];
        byte[] byArray4 = this.getPaddedLengthBytes(n);
        int n2 = 0;
        System.arraycopy(byArray4, 0, byArray3, n2, byArray4.length);
        n2 += byArray4.length;
        byArray3[n2++] = 8;
        byArray3[n2++] = 0;
        System.arraycopy(byArray2, 0, byArray3, n2, byArray2.length);
        n2 += byArray2.length;
        byArray3[n2++] = 0;
        System.arraycopy(byArray, 0, byArray3, n2, byArray.length);
        n2 += byArray.length;
        byArray3[n2++] = 0;
        this.signals.write(byArray3, 0, byArray3.length);
    }

    public void sendShowDocumentCmd(String string, String string2, String string3) {
        Main.debug("sendShowDocumentCmd from context#" + string + " url = " + string2 + ", frame = " + string3);
        byte[] byArray = string2.getBytes();
        byte[] byArray2 = string3.getBytes();
        int n = string.length() + byArray.length + byArray2.length + 5;
        byte[] byArray3 = new byte[n + 8];
        byte[] byArray4 = this.getPaddedLengthBytes(n);
        int n2 = 0;
        System.arraycopy(byArray4, 0, byArray3, n2, byArray4.length);
        n2 += byArray4.length;
        byArray3[n2++] = 9;
        byArray3[n2++] = 0;
        byArray4 = string.getBytes();
        System.arraycopy(byArray4, 0, byArray3, n2, byArray4.length);
        n2 += byArray4.length;
        byArray3[n2++] = 0;
        System.arraycopy(byArray, 0, byArray3, n2, byArray.length);
        n2 += byArray.length;
        byArray3[n2++] = 0;
        System.arraycopy(byArray2, 0, byArray3, n2, byArray2.length);
        n2 += byArray2.length;
        byArray3[n2++] = 0;
        this.signals.write(byArray3, 0, byArray3.length);
    }

    public void sendShowStatusCmd(String string, String string2) {
        Main.debug("sendShowStatusCmd, contextID = " + string + " msg = " + string2);
        byte[] byArray = string2.getBytes();
        int n = string.length() + byArray.length + 4;
        byte[] byArray2 = new byte[n + 8];
        int n2 = 0;
        byte[] byArray3 = this.getPaddedLengthBytes(n);
        System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
        n2 += byArray3.length;
        byArray2[n2++] = 10;
        byArray2[n2++] = 0;
        byArray3 = string.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
        n2 += byArray3.length;
        byArray2[n2++] = 0;
        System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
        n2 += byArray.length;
        byArray2[n2++] = 0;
        this.signals.write(byArray2, 0, byArray2.length);
    }

    public void sendResizeAppletCmd(String string, String string2, int n, int n2) {
        Main.debug("sendResizeAppletCmd, contextID = " + string + ", appletID = " + string2 + ", width = " + n + ", height = " + n2);
        byte[] byArray = String.valueOf(n).getBytes();
        byte[] byArray2 = String.valueOf(n2).getBytes();
        int n3 = string.length() + string2.length() + byArray.length + byArray2.length + 6;
        byte[] byArray3 = new byte[n3 + 8];
        byte[] byArray4 = this.getPaddedLengthBytes(n3);
        int n4 = 0;
        System.arraycopy(byArray4, 0, byArray3, n4, byArray4.length);
        n4 += byArray4.length;
        byArray3[n4++] = 11;
        byArray3[n4++] = 0;
        byArray4 = string.getBytes();
        System.arraycopy(byArray4, 0, byArray3, n4, byArray4.length);
        n4 += byArray4.length;
        byArray3[n4++] = 0;
        byArray4 = string2.getBytes();
        System.arraycopy(byArray4, 0, byArray3, n4, byArray4.length);
        n4 += byArray4.length;
        byArray3[n4++] = 0;
        System.arraycopy(byArray, 0, byArray3, n4, byArray.length);
        n4 += byArray.length;
        byArray3[n4++] = 0;
        System.arraycopy(byArray2, 0, byArray3, n4, byArray2.length);
        n4 += byArray2.length;
        byArray3[n4++] = 0;
        this.signals.write(byArray3, 0, byArray3.length);
    }

    public void sendJavaScriptEventCmd(String string, String string2, int n, String string3, int[] nArray, String[] stringArray) {
        Main.debug("sendJavaScriptEventCmd, contextID = " + string + " event = " + string3);
        String string4 = new String("" + n);
        int n2 = string.length() + string2.length() + string3.length() + string4.length() + 6;
        byte[][][] byArray = null;
        if (nArray != null) {
            byArray = new byte[stringArray.length][2][];
            for (int i = 0; i < nArray.length; ++i) {
                byArray[i][0] = new String("" + nArray[i]).getBytes();
                byArray[i][1] = stringArray[i].getBytes();
                n2 += 2 + byArray[i][0].length + byArray[i][1].length;
            }
        }
        byte[] byArray2 = new byte[n2 + 8];
        int n3 = 0;
        byte[] byArray3 = this.getPaddedLengthBytes(n2);
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        n3 += byArray3.length;
        byArray2[n3++] = 15;
        byArray2[n3++] = 0;
        byArray3 = string.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        n3 += byArray3.length;
        byArray2[n3++] = 0;
        byArray3 = string2.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        n3 += byArray3.length;
        byArray2[n3++] = 0;
        byArray3 = string4.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        n3 += byArray3.length;
        byArray2[n3++] = 0;
        byArray3 = string3.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        n3 += byArray3.length;
        byArray2[n3++] = 0;
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                System.arraycopy(byArray[i][0], 0, byArray2, n3, byArray[i][0].length);
                n3 += byArray[i][0].length;
                byArray2[n3++] = 0;
                System.arraycopy(byArray[i][1], 0, byArray2, n3, byArray[i][1].length);
                n3 += byArray[i][1].length;
                byArray2[n3++] = 0;
            }
        }
        this.signals.write(byArray2, 0, byArray2.length);
    }

    public void sendMemberValue(String string, int n, int n2, int n3, int n4, String string2) {
        Main.debug("sendMemberValue, contextID = " + string + " value = " + string2 + " type=" + n3 + " rid=" + n4);
        String string3 = String.valueOf(n2);
        String string4 = String.valueOf(n3);
        String string5 = String.valueOf(n4);
        byte[] byArray = string2.getBytes();
        int n5 = string.length() + byArray.length + string4.length() + string5.length() + string3.length() + 7;
        byte[] byArray2 = new byte[n5 + 8];
        int n6 = 0;
        byte[] byArray3 = this.getPaddedLengthBytes(n5);
        System.arraycopy(byArray3, 0, byArray2, n6, byArray3.length);
        n6 += byArray3.length;
        byArray2[n6++] = (byte)n;
        byArray2[n6++] = 0;
        byArray3 = string.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n6, byArray3.length);
        n6 += byArray3.length;
        byArray2[n6++] = 0;
        byArray3 = string3.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n6, byArray3.length);
        n6 += byArray3.length;
        byArray2[n6++] = 0;
        byArray3 = string4.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n6, byArray3.length);
        n6 += byArray3.length;
        byArray2[n6++] = 0;
        byArray3 = string5.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n6, byArray3.length);
        n6 += byArray3.length;
        byArray2[n6++] = 0;
        System.arraycopy(byArray, 0, byArray2, n6, byArray.length);
        n6 += byArray.length;
        byArray2[n6++] = 0;
        this.signals.write(byArray2, 0, byArray2.length);
    }

    private void sendAudioClipCommand(String string, String string2, int n) {
        byte[] byArray = string2.getBytes();
        int n2 = string.length() + byArray.length + 4;
        byte[] byArray2 = new byte[n2 + 8];
        byte[] byArray3 = this.getPaddedLengthBytes(n2);
        int n3 = 0;
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        n3 += byArray3.length;
        byArray2[n3++] = (byte)n;
        byArray2[n3++] = 0;
        byArray3 = string.getBytes();
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        n3 += byArray3.length;
        byArray2[n3++] = 0;
        System.arraycopy(byArray, 0, byArray2, n3, byArray.length);
        n3 += byArray.length;
        byArray2[n3++] = 0;
        this.signals.write(byArray2, 0, byArray2.length);
    }

    public void sendAudioClipPlayCommand(String string, String string2) {
        this.sendAudioClipCommand(string, string2, 20);
    }

    public void sendAudioClipLoopCommand(String string, String string2) {
        this.sendAudioClipCommand(string, string2, 21);
    }

    public void sendAudioClipStopCommand(String string, String string2) {
        this.sendAudioClipCommand(string, string2, 22);
    }

    public void sendPutMember(String string, int n, boolean bl) {
        Main.debug("sendPutMember, contextID = " + string + " success = " + bl);
        byte[] byArray = String.valueOf(n).getBytes();
        byte[] byArray2 = String.valueOf(bl ? "1" : "0").getBytes();
        int n2 = string.length() + byArray2.length + byArray.length + 5;
        byte[] byArray3 = new byte[n2 + 8];
        byte[] byArray4 = this.getPaddedLengthBytes(n2);
        int n3 = 0;
        System.arraycopy(byArray4, 0, byArray3, n3, byArray4.length);
        n3 += byArray4.length;
        byArray3[n3++] = 18;
        byArray3[n3++] = 0;
        byArray4 = string.getBytes();
        System.arraycopy(byArray4, 0, byArray3, n3, byArray4.length);
        n3 += byArray4.length;
        byArray3[n3++] = 0;
        System.arraycopy(byArray, 0, byArray3, n3, byArray.length);
        n3 += byArray.length;
        byArray3[n3++] = 0;
        System.arraycopy(byArray2, 0, byArray3, n3, byArray2.length);
        n3 += byArray2.length;
        byArray3[n3++] = 0;
        this.signals.write(byArray3, 0, byArray3.length);
    }

    public void sendSecurityConfirm(String[] stringArray, int n, String string, String string2) {
        Main.debug("sendSecurityConfirm, ID = " + string2 + " certsnr = " + n);
        byte[] byArray = string2.getBytes();
        byte[] byArray2 = string.getBytes();
        byte[] byArray3 = String.valueOf(n).getBytes();
        int n2 = byArray2.length + byArray.length + byArray3.length + 5;
        for (int i = 0; i < n; ++i) {
            n2 += stringArray[i].length() + 1;
        }
        byte[] byArray4 = new byte[n2 + 8];
        byte[] byArray5 = this.getPaddedLengthBytes(n2);
        int n3 = 0;
        System.arraycopy(byArray5, 0, byArray4, n3, byArray5.length);
        n3 += byArray5.length;
        byArray4[n3++] = 28;
        byArray4[n3++] = 0;
        System.arraycopy(byArray, 0, byArray4, n3, byArray.length);
        n3 += byArray.length;
        byArray4[n3++] = 0;
        System.arraycopy(byArray2, 0, byArray4, n3, byArray2.length);
        n3 += byArray2.length;
        byArray4[n3++] = 0;
        System.arraycopy(byArray3, 0, byArray4, n3, byArray3.length);
        n3 += byArray3.length;
        byArray4[n3++] = 0;
        for (int i = 0; i < n; ++i) {
            byte[] byArray6 = stringArray[i].getBytes();
            System.arraycopy(byArray6, 0, byArray4, n3, byArray6.length);
            n3 += byArray6.length;
            byArray4[n3++] = 0;
        }
        this.signals.write(byArray4, 0, byArray4.length);
    }

    private String getArg(byte[] byArray) {
        int n = this.cmd_index;
        while (0 != byArray[this.cmd_index++]) {
        }
        if (this.cmd_index > n + 1) {
            String string = new String(byArray, n, this.cmd_index - n - 1);
            return string;
        }
        return null;
    }

    private byte[] getPaddedLengthBytes(int n) {
        byte[] byArray = String.valueOf(n).getBytes();
        if (byArray.length > 8) {
            throw new IllegalArgumentException("can't create string number of length = 8");
        }
        byte[] byArray2 = new byte[]{32, 32, 32, 32, 32, 32, 32, 32};
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    private int readPaddedLength(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.commands.read(byArray, 0, n);
        String string = new String(byArray);
        return Integer.parseInt(string.trim());
    }
}

