from qt import QFrame, QStringList, QVBoxLayout, SIGNAL, QLabel, QSizePolicy, Qt
from qttable import QTable
from kdeui import KTextEdit, KDatePicker, KDateWidget


labelText = 'KDatePicker'
iconName = 'date'
helpText = """A date selection widget.

Provides a widget for calendar date input.

Different from the previous versions, it now emits two types of
signals, either dateSelected() or dateEntered() (see documentation for
both signals).

A line edit has been added in the newer versions to allow the user to
select a date directly by entering numbers like 19990101 or 990101.
"""

class MainFrame(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.help = KTextEdit(helpText, '', self)
        self.dateDisplay = KDateWidget(self)

        self.dateDisplay.setSizePolicy(QSizePolicy(QSizePolicy.Maximum,
                                                   QSizePolicy.Maximum))
                                                   
        self.datePicker = KDatePicker(self)

        layout = QVBoxLayout(self)
        layout.addWidget(self.help, 1)
        layout.addWidget(self.datePicker, 0, Qt.AlignHCenter)
        layout.addStretch(1)

        self.other = QLabel('Selected Date:', self)
        layout.addWidget(self.other, 0)
        layout.addWidget(self.dateDisplay, 2)

        self.connect(self.datePicker, SIGNAL('dateChanged(QDate)'),
                     self.dateDisplay.setDate)

