import org.kde.qt.*;

public class GameBoard extends QWidget {
	private QLCDNumber hits;
	private QLCDNumber shotsLeft;
	private CannonField cannonField;

	public GameBoard() {
		super(null, "gameboard");
		QPushButton quit = new QPushButton("&Quit", this, "quit");
		quit.setFont(new QFont("Times", 18, QFont.Bold, false));

		connect(quit, SIGNAL("clicked()"), qApp(), SLOT("quit()"));

		LCDRange angle = new LCDRange("ANGLE", this, "angle");
		angle.setRange(5, 70);

		LCDRange force = new LCDRange("FORCE", this, "force");
		force.setRange(10, 50);

		QVBox box = new QVBox(this, "cannonFrame");
		box.setFrameStyle(QFrame.WinPanel | QFrame.Sunken);

		cannonField = new CannonField(box, "cannonField");

		connect(angle, SIGNAL("valueChanged(int)"),
						cannonField, SLOT("setAngle(int)"));
		connect(cannonField, SIGNAL("angleChanged(int)"),
						angle, SLOT("setValue(int)"));

		connect(force, SIGNAL("valueChanged(int)"),
						cannonField, SLOT("setForce(int)"));
		connect(cannonField, SIGNAL("forceChanged(int)"),
						force, SLOT("setValue(int)"));

		connect(cannonField, SIGNAL("hit()"),
						this, SLOT("hit()"));
		connect(cannonField, SIGNAL("missed()"),
						this, SLOT("missed()"));

		QPushButton shoot = new QPushButton("&Shoot", this, "shoot");
		shoot.setFont(new QFont("Times", 18, QFont.Bold, false));

		connect(shoot, SIGNAL("clicked()"), SLOT("fire()"));

		QPushButton restart = new QPushButton("&New Game", this, "newgame");
		restart.setFont(new QFont("Times", 18, QFont.Bold, false));

		connect(restart, SIGNAL("clicked()"), this, SLOT("newGame()"));

		hits = new QLCDNumber(2, this, "hits");
		shotsLeft = new QLCDNumber(2, this, "shotsleft");
		QLabel hitsL = new QLabel("HITS", this, "hitsLabel", 0);
		QLabel shotsLeftL = new QLabel("SHOTS LEFT", this, "shotsleftLabel", 0);

		QAccel accel = new QAccel(this);
		accel.connectItem(accel.insertItem(new QKeySequence(Key_Enter)), this, SLOT("fire()"));
		accel.connectItem(accel.insertItem(new QKeySequence(Key_Return)), this, SLOT("fire()"));
		accel.connectItem(accel.insertItem(new QKeySequence(CTRL+Key_Q)), qApp(), SLOT("quit()"));
/***
		accel.connectItem(accel.insertItem(Key_Enter), this, SLOT("fire()"));
		accel.connectItem(accel.insertItem(Key_Return), this, SLOT("fire()"));
		accel.connectItem(accel.insertItem(CTRL+Key_Q), qApp(), SLOT("quit()"));
***/
		QGridLayout grid = new QGridLayout(this, 2, 2, 10, -1, null);
		grid.addWidget(quit, 0, 0);
		grid.addWidget(box, 1, 1);
		grid.setColStretch(1, 10);

		QVBoxLayout leftBox = new QVBoxLayout();
		grid.addLayout(leftBox, 1, 0);
		leftBox.addWidget(angle);
		leftBox.addWidget(force);

		QHBoxLayout topBox = new QHBoxLayout();
		grid.addLayout(topBox, 0, 1);
		topBox.addWidget(shoot);
		topBox.addWidget(hits);
		topBox.addWidget(hitsL);
		topBox.addWidget(shotsLeft);
		topBox.addWidget(shotsLeftL);
		topBox.addStretch(1);
		topBox.addWidget(restart);

		angle.setValue(60);
		force.setValue(25);
		angle.setFocus();

		newGame();
	}

	protected void fire() {
		if (cannonField.gameOver() || cannonField.isShooting())
			return;
		shotsLeft.display(shotsLeft.intValue() - 1);
		cannonField.shoot();
	}

	protected void hit() {
		hits.display(hits.intValue() + 1);
		if (shotsLeft.intValue() == 0)
			cannonField.setGameOver();
		else
			cannonField.newTarget();
	}

	protected void missed() {
		if (shotsLeft.intValue() == 0)
			cannonField.setGameOver();
	}

	protected void newGame() {
		shotsLeft.display(15);
		hits.display(0);
		cannonField.restartGame();
		cannonField.newTarget();
	}
}
