/***************************************************************************
* $Id: Main.java 142206 2002-03-10 16:08:04Z rdale $
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.kde.qt.*;

public class Main {

public static void main(String[] args)
{
    if ( args.length > 0 && args[0].equals("-m") ) {
	QApplication.setColorSpec( QApplication.ManyColor );
    }
    else if ( args.length > 1 && args[1].equals("-n") ) {
	QApplication.setColorSpec( QApplication.NormalColor );
    }
    else {
	QApplication.setColorSpec( QApplication.CustomColor );
    }

    QApplication.setFont( new QFont("Helvetica", 12) );
    QApplication a = new QApplication( args );

    ImageIconProvider iip = new ImageIconProvider();
    QFileDialog.setIconProvider( iip );

    if ( args.length == 0 ) {
	// Create a window which looks after its own existence.
	ImageViewer w =
	    new ImageViewer(null, "new window", Qt.WDestructiveClose | Qt.WResizeNoErase );
	w.setCaption("Qt Example - Image Viewer");
	w.show();
    } else {
	for ( int i=0; i<args.length; i++ ) {
	    // Create a window which looks after its own existence.
	    ImageViewer w =
		new ImageViewer(null, args[i], Qt.WDestructiveClose | Qt.WResizeNoErase );
	    w.setCaption("Qt Example - Image Viewer");
	    w.loadImage( args[i] );
	    w.show();
	}
    }

    QObject.connect(Qt.qApp(), Qt.SIGNAL("lastWindowClosed()"), Qt.qApp(), Qt.SLOT("quit()"));

    a.exec();
    return;
}

	static {
		qtjava.initialize();
	}
}
