/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 *               2004 Jean-Franois Wauthy (pollux@xfce.org)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __XFPRINT_FILTER_H__
#define __XFPRINT_FILTER_H__

#include <glib.h>

typedef struct _XfprintFilter	XfprintFilter;
typedef struct _XfprintFilterList	XfprintFilterList;

struct _XfprintFilter
{
	guint	argc;
	gchar	**argv;
	gchar	*command;
	guint	size;
};

struct _XfprintFilterList
{
	GList	*cursor;
	GList	*filters;
};

/* filter function prototypes */
extern XfprintFilter	*xfprint_filter_new(const gchar *);
extern void		xfprint_filter_free(XfprintFilter *);
extern void		xfprint_filter_add(XfprintFilter *, const gchar *, ...);

/* filterlist function prototypes */
extern XfprintFilterList	*xfprint_filterlist_new(void);
extern void		xfprint_filterlist_free(XfprintFilterList *);
extern void		xfprint_filterlist_append(XfprintFilterList *, XfprintFilter *);
extern void		xfprint_filterlist_prepend(XfprintFilterList *, XfprintFilter *);
extern int		xfprint_filterlist_execute(XfprintFilterList *, int,int,int);

#endif	/* !__XFPRINT_FILTER_H__ */
