/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2005 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * gui_colorselectiondialog.c - creation and destruction of the color selection dialog
 *
 * used by the preferencesdialog. Display a color selection dialog and when OK is
 * clicked update the example frame in the preferences dialog.
 */

#include <gtk/gtk.h>

#include "gui_colorselectiondialog.h"
#include "gui_utils.h"
#include "support.h"
#include "types.h"

extern preferencestype preferences;
extern GtkWidget *preferencesdialog;

void
on_themebutton_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *colorselectiondialog, *examplelabel, *exampleframe;
	GdkPixbuf *colorselectiondialog_icon_pixbuf;
	GdkColor color, newcolor;
	gchar *col;
	gint response;

	colorselectiondialog = gtk_color_selection_dialog_new
		(_("xlog - select color"));
	colorselectiondialog_icon_pixbuf = create_pixbuf ("xlog.png");
	if (colorselectiondialog_icon_pixbuf)
	{
		gtk_window_set_icon (GTK_WINDOW (colorselectiondialog),
			colorselectiondialog_icon_pixbuf);
		g_object_unref (colorselectiondialog_icon_pixbuf);
	}
	gtk_widget_destroy
		(GTK_COLOR_SELECTION_DIALOG(colorselectiondialog)->help_button);
	gdk_color_parse (preferences.themecolor, &color);
	gtk_color_selection_set_current_color (GTK_COLOR_SELECTION
		(GTK_COLOR_SELECTION_DIALOG(colorselectiondialog)->colorsel), &color);
	gtk_widget_show_all (colorselectiondialog);
	response = gtk_dialog_run (GTK_DIALOG(colorselectiondialog));
	if (response == GTK_RESPONSE_OK)
	{
		gtk_color_selection_get_current_color (GTK_COLOR_SELECTION
(GTK_COLOR_SELECTION_DIALOG(colorselectiondialog)->colorsel), &newcolor);
		col = g_strdup_printf ("#%02X%02X%02X", newcolor.red >> 8,
			newcolor.green >> 8, newcolor.blue >> 8);
		exampleframe = lookup_widget (preferencesdialog, "exampleframe");
		setframestyle (exampleframe, col, preferences.themefont);
		examplelabel = lookup_widget (preferencesdialog, "examplelabel");
		setlabelstyle (examplelabel, col, preferences.themefont);
		g_free (col);
	}
	gtk_widget_destroy (colorselectiondialog);
}
