/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.security.AccessController;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.action.GetPropertyAction;
import sun.security.jgss.GSSExceptionImpl;
import sun.security.jgss.spi.MechanismFactory;

final class ProviderList {
    private static final String PROV_PROP_PREFIX = "GssApiMechanism.";
    private static final int PROV_PROP_PREFIX_LEN = PROV_PROP_PREFIX.length();
    private static final String SPI_MECH_FACTORY_TYPE = "sun.security.jgss.spi.MechanismFactory";
    private static final Oid DEFAULT_MECH_OID;
    private MechanismFactory defaultMechFactory;
    private ArrayList preferences = new ArrayList(5);
    private HashMap factories = new HashMap(5);
    private HashSet mechs = new HashSet(5);

    public ProviderList() {
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                this.addProviderAtEnd(providerArray[i], null);
                continue;
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
        }
    }

    private boolean isMechFactoryProperty(String string) {
        return string.startsWith(PROV_PROP_PREFIX) || string.regionMatches(true, 0, PROV_PROP_PREFIX, 0, PROV_PROP_PREFIX_LEN);
    }

    private Oid getOidFromMechFactoryProperty(String string) throws GSSException {
        String string2 = string.substring(PROV_PROP_PREFIX_LEN);
        return new Oid(string2);
    }

    public synchronized MechanismFactory getMechFactory(Oid oid) throws GSSException {
        if (oid == null || oid.equals(DEFAULT_MECH_OID)) {
            return this.defaultMechFactory;
        }
        for (PreferencesEntry preferencesEntry : this.preferences) {
            MechanismFactory mechanismFactory;
            if (!preferencesEntry.impliesMechanism(oid) || (mechanismFactory = this.getMechFactory(preferencesEntry, oid)) == null) continue;
            return mechanismFactory;
        }
        throw new GSSExceptionImpl(2, oid.toString());
    }

    private MechanismFactory getMechFactory(PreferencesEntry preferencesEntry, Oid oid) throws GSSException {
        Provider provider = preferencesEntry.getProvider();
        PreferencesEntry preferencesEntry2 = new PreferencesEntry(provider, oid);
        MechanismFactory mechanismFactory = (MechanismFactory)this.factories.get(preferencesEntry2);
        if (mechanismFactory == null) {
            String string = PROV_PROP_PREFIX + oid.toString();
            String string2 = provider.getProperty(string);
            if (string2 != null) {
                mechanismFactory = ProviderList.getMechFactoryImpl(provider, string2);
                this.factories.put(preferencesEntry2, mechanismFactory);
            } else if (preferencesEntry.getOid() != null) {
                throw new GSSExceptionImpl(2, "Provider " + provider.getName() + " does not support mechanism " + oid.toString());
            }
        }
        return mechanismFactory;
    }

    private static MechanismFactory getMechFactoryImpl(Provider provider, String string) throws GSSException {
        String string2 = "class configured by provider " + provider.getName() + " for GSS-API Mechanism Factory: " + string;
        try {
            Class<?> clazz = Class.forName(SPI_MECH_FACTORY_TYPE);
            ClassLoader classLoader = provider.getClass().getClassLoader();
            Class<?> clazz2 = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            if (clazz.isAssignableFrom(clazz2)) {
                return (MechanismFactory)clazz2.newInstance();
            }
            throw new GSSExceptionImpl(2, string2 + " is not a " + SPI_MECH_FACTORY_TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GSSExceptionImpl(2, string2 + "cannot be found - " + classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw (GSSExceptionImpl)new GSSExceptionImpl(2, string2 + " cannot be instantiated ").initCause(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new GSSExceptionImpl(2, string2 + " cannot be accessed - " + illegalAccessException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new GSSExceptionImpl(2, string2 + " cannot be accessed - " + securityException.getMessage());
        }
    }

    public Oid getDefaultMechanism() {
        return DEFAULT_MECH_OID;
    }

    public Oid[] getMechs() {
        return this.mechs.toArray(new Oid[0]);
    }

    public synchronized void addProviderAtFront(Provider provider, Oid oid) throws GSSException {
        boolean bl;
        PreferencesEntry preferencesEntry = new PreferencesEntry(provider, oid);
        Iterator iterator = this.preferences.iterator();
        while (iterator.hasNext()) {
            PreferencesEntry preferencesEntry2 = (PreferencesEntry)iterator.next();
            if (!preferencesEntry.implies(preferencesEntry2)) continue;
            iterator.remove();
        }
        if (oid == null) {
            bl = this.addAllMechsFromProvider(provider);
        } else {
            String string = oid.toString();
            if (provider.getProperty(PROV_PROP_PREFIX + string) == null) {
                throw new GSSExceptionImpl(2, "Provider " + provider.getName() + " does not support " + string);
            }
            this.mechs.add(oid);
            bl = true;
        }
        if (bl) {
            this.preferences.add(0, preferencesEntry);
        }
    }

    public synchronized void addProviderAtEnd(Provider provider, Oid oid) throws GSSException {
        boolean bl;
        PreferencesEntry preferencesEntry = new PreferencesEntry(provider, oid);
        for (PreferencesEntry preferencesEntry2 : this.preferences) {
            if (!preferencesEntry2.implies(preferencesEntry)) continue;
            return;
        }
        if (oid == null) {
            bl = this.addAllMechsFromProvider(provider);
        } else {
            String string = oid.toString();
            if (provider.getProperty(PROV_PROP_PREFIX + string) == null) {
                throw new GSSExceptionImpl(2, "Provider " + provider.getName() + " does not support " + string);
            }
            this.mechs.add(oid);
            bl = true;
        }
        if (bl) {
            this.preferences.add(preferencesEntry);
        }
    }

    private boolean addAllMechsFromProvider(Provider provider) {
        boolean bl = false;
        Enumeration enumeration = provider.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.isMechFactoryProperty(string)) continue;
            try {
                Oid oid = this.getOidFromMechFactoryProperty(string);
                if (this.defaultMechFactory == null && DEFAULT_MECH_OID.equals(oid)) {
                    String string2 = provider.getProperty(string);
                    this.defaultMechFactory = ProviderList.getMechFactoryImpl(provider, string2);
                    PreferencesEntry preferencesEntry = new PreferencesEntry(provider, DEFAULT_MECH_OID);
                    this.factories.put(preferencesEntry, this.defaultMechFactory);
                }
                this.mechs.add(oid);
                bl = true;
            }
            catch (GSSException gSSException) {}
        }
        return bl;
    }

    static {
        Oid oid = null;
        Oid oid2 = null;
        String string = null;
        try {
            oid = new Oid("1.2.840.113554.1.2.2");
            string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.security.jgss.mechanism"));
            if (string != null) {
                oid2 = new Oid(string);
            }
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
        DEFAULT_MECH_OID = oid2 != null ? oid2 : oid;
    }

    final class PreferencesEntry {
        private Provider p;
        private Oid oid;

        public PreferencesEntry(Provider provider, Oid oid) {
            this.p = provider;
            this.oid = oid;
        }

        public boolean equals(Object object) {
            if (object instanceof PreferencesEntry) {
                return this.equals((PreferencesEntry)object);
            }
            return false;
        }

        public boolean equals(PreferencesEntry preferencesEntry) {
            if (this.p.getName().equals(preferencesEntry.p.getName())) {
                if (this.oid != null && preferencesEntry.oid != null) {
                    return this.oid.equals(preferencesEntry.oid);
                }
                return this.oid == null && preferencesEntry.oid == null;
            }
            return false;
        }

        public boolean implies(Object object) {
            if (object instanceof PreferencesEntry) {
                PreferencesEntry preferencesEntry = (PreferencesEntry)object;
                return this.equals(preferencesEntry) || this.p.getName().equals(preferencesEntry.p.getName()) && this.oid == null;
            }
            return false;
        }

        public Provider getProvider() {
            return this.p;
        }

        public Oid getOid() {
            return this.oid;
        }

        public boolean impliesMechanism(Oid oid) {
            return this.oid == null || this.oid.equals(oid);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("<");
            stringBuffer.append(this.p.getName());
            stringBuffer.append(", ");
            stringBuffer.append(this.oid);
            stringBuffer.append(">");
            return stringBuffer.toString();
        }
    }
}

