/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import sun.io.CharToByteEUC_TW;
import sun.io.ConversionBufferFullException;
import sun.io.UnknownCharacterException;

abstract class CharToByteX11CNS11643
extends CharToByteEUC_TW {
    private final int plane;
    private final String encoding;

    CharToByteX11CNS11643(int n, String string) {
        switch (n) {
            case 1: {
                this.plane = 0;
                break;
            }
            case 2: 
            case 3: {
                this.plane = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only planes 1, 2, and 3 supported");
            }
        }
        this.encoding = string;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public boolean canConvert(char c) {
        if (c <= '\u007f') {
            return false;
        }
        int n = (this.unicodeToEUC(c) & 0xFF0000) >> 16;
        if (n == 0 && this.plane == 0) {
            return true;
        }
        return this.plane == n - 160;
    }

    public int convert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws ConversionBufferFullException, UnknownCharacterException {
        this.charOff = n;
        this.byteOff = n3;
        if (n >= n2) {
            return 0;
        }
        int n5 = n;
        int n6 = n3;
        int n7 = n4 - 2;
        while (n5 < n2) {
            if (n6 > n7) {
                this.charOff = n5;
                this.byteOff = n6;
                throw new ConversionBufferFullException();
            }
            if (this.canConvert(cArray[n5])) {
                int n8 = this.unicodeToEUC(cArray[n5++]);
                byArray[n6++] = (byte)(n8 >> 8 & 0x7F);
                byArray[n6++] = (byte)(n8 & 0x7F);
                continue;
            }
            if (this.subMode) {
                ++n5;
                byArray[n6++] = this.subBytes.length > 0 ? this.subBytes[0] : (byte)0;
                byArray[n6++] = this.subBytes.length > 1 ? this.subBytes[1] : (byte)0;
                continue;
            }
            this.charOff = n5;
            this.byteOff = n6;
            throw new UnknownCharacterException();
        }
        this.charOff = n5;
        this.byteOff = n6;
        return n6 - n3;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
    }

    public int flush(byte[] byArray, int n, int n2) {
        this.reset();
        return 0;
    }

    public int getMaxBytesPerChar() {
        return 2;
    }
}

