/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XDragAndDropProtocols;
import sun.awt.X11.XDropTargetEventProcessor;
import sun.awt.X11.XDropTargetProtocol;
import sun.awt.X11.XException;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XTranslateCoordinates;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;

final class XDropTargetRegistry {
    private static final long DELAYED_REGISTRATION_PERIOD = 200L;
    private static final XDropTargetRegistry theInstance = new XDropTargetRegistry();
    private final HashMap<Long, Runnable> delayedRegistrationMap = new HashMap();
    private final HashMap embeddedDropSiteRegistry = new HashMap();

    private XDropTargetRegistry() {
    }

    static XDropTargetRegistry getRegistry() {
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getToplevelWindow(long l) {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        do {
            WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l, XWM.XA_WM_STATE, 0L, 0L, false, 0L);
            try {
                windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
                if (windowPropertyGetter.getActualType() == XWM.XA_WM_STATE.getAtom()) {
                    l2 = l;
                }
            }
            finally {
                windowPropertyGetter.dispose();
            }
            XQueryTree xQueryTree = new XQueryTree(l);
            try {
                if (xQueryTree.execute() == 0) {
                    long l5 = 0L;
                    return l5;
                }
                l3 = xQueryTree.get_root();
                l4 = xQueryTree.get_parent();
            }
            finally {
                xQueryTree.dispose();
            }
        } while ((l = l4) != l3);
        return l2;
    }

    static final long getDnDProxyWindow() {
        return XWindow.getXAWTRootWindow().getWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmbeddedDropSiteEntry registerEmbedderDropSite(long l) {
        XDropTargetProtocol xDropTargetProtocol;
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        long l2 = XDropTargetRegistry.getDnDProxyWindow();
        Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
        ArrayList<XDropTargetProtocol> arrayList = new ArrayList<XDropTargetProtocol>();
        while (iterator.hasNext()) {
            xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
            if (!xDropTargetProtocol.isProtocolSupported(l)) continue;
            arrayList.add(xDropTargetProtocol);
        }
        iterator = !arrayList.isEmpty() ? arrayList.iterator() : XDragAndDropProtocols.getDropTargetProtocols();
        XlibWrapper.XGrabServer(XToolkit.getDisplay());
        try {
            while (iterator.hasNext()) {
                xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
                xDropTargetProtocol.registerEmbedderDropSite(l);
            }
            long l3 = 0L;
            long l4 = 0L;
            XWindowAttributes xWindowAttributes = new XWindowAttributes();
            try {
                XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
                int n = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l, xWindowAttributes.pData);
                XToolkit.RESTORE_XERROR_HANDLER();
                if (n == 0 || XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                    throw new XException("XGetWindowAttributes failed");
                }
                l4 = xWindowAttributes.get_your_event_mask();
                l3 = xWindowAttributes.get_root();
            }
            finally {
                xWindowAttributes.dispose();
            }
            if ((l4 & 0x400000L) == 0L) {
                XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
                XlibWrapper.XSelectInput(XToolkit.getDisplay(), l, l4 | 0x400000L);
                XToolkit.RESTORE_XERROR_HANDLER();
                if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                    throw new XException("XSelectInput failed");
                }
            }
            EmbeddedDropSiteEntry embeddedDropSiteEntry = new EmbeddedDropSiteEntry(l3, l4);
            return embeddedDropSiteEntry;
        }
        finally {
            XlibWrapper.XUngrabServer(XToolkit.getDisplay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEmbedderDropSite(long l) {
        XDropTargetProtocol xDropTargetProtocol;
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        Long l2 = new Long(l);
        Iterator iterator = this;
        synchronized (iterator) {
            if (this.embeddedDropSiteRegistry.get(l2) == null) {
                return;
            }
        }
        iterator = XDragAndDropProtocols.getDropTargetProtocols();
        ArrayList<XDropTargetProtocol> arrayList = new ArrayList<XDropTargetProtocol>();
        while (iterator.hasNext()) {
            xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
            if (!xDropTargetProtocol.isProtocolSupported(l)) continue;
            arrayList.add(xDropTargetProtocol);
        }
        iterator = !arrayList.isEmpty() ? arrayList.iterator() : XDragAndDropProtocols.getDropTargetProtocols();
        XlibWrapper.XGrabServer(XToolkit.getDisplay());
        try {
            while (iterator.hasNext()) {
                xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
                xDropTargetProtocol.registerEmbedderDropSite(l);
            }
        }
        finally {
            XlibWrapper.XUngrabServer(XToolkit.getDisplay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterEmbedderDropSite(long l, EmbeddedDropSiteEntry embeddedDropSiteEntry) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
        XlibWrapper.XGrabServer(XToolkit.getDisplay());
        try {
            while (iterator.hasNext()) {
                XDropTargetProtocol xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
                xDropTargetProtocol.unregisterEmbedderDropSite(l);
            }
            long l2 = embeddedDropSiteEntry.getEventMask();
            if ((l2 & 0x400000L) == 0L) {
                XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
                XlibWrapper.XSelectInput(XToolkit.getDisplay(), l, l2);
                XToolkit.RESTORE_XERROR_HANDLER();
                if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                    throw new XException("XSelectInput failed");
                }
            }
        }
        finally {
            XlibWrapper.XUngrabServer(XToolkit.getDisplay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerEmbeddedDropSite(long l, long l2) {
        Long l3 = new Long(l);
        EmbeddedDropSiteEntry embeddedDropSiteEntry = null;
        XDropTargetRegistry xDropTargetRegistry = this;
        synchronized (xDropTargetRegistry) {
            embeddedDropSiteEntry = (EmbeddedDropSiteEntry)this.embeddedDropSiteRegistry.get(l3);
            if (embeddedDropSiteEntry == null) {
                embeddedDropSiteEntry = this.registerEmbedderDropSite(l);
                this.embeddedDropSiteRegistry.put(l3, embeddedDropSiteEntry);
            }
        }
        assert (embeddedDropSiteEntry != null);
        embeddedDropSiteEntry.addSite(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterEmbeddedDropSite(long l, long l2) {
        Long l3 = new Long(l);
        EmbeddedDropSiteEntry embeddedDropSiteEntry = null;
        XDropTargetRegistry xDropTargetRegistry = this;
        synchronized (xDropTargetRegistry) {
            embeddedDropSiteEntry = (EmbeddedDropSiteEntry)this.embeddedDropSiteRegistry.get(l3);
            assert (embeddedDropSiteEntry != null);
            embeddedDropSiteEntry.removeSite(l2);
            if (!embeddedDropSiteEntry.hasSites()) {
                this.embeddedDropSiteRegistry.remove(l3);
                this.unregisterEmbedderDropSite(l, embeddedDropSiteEntry);
            }
        }
    }

    public long getEmbeddedDropSite(long l, int n, int n2) {
        Long l2 = new Long(l);
        EmbeddedDropSiteEntry embeddedDropSiteEntry = (EmbeddedDropSiteEntry)this.embeddedDropSiteRegistry.get(l2);
        if (embeddedDropSiteEntry == null) {
            return 0L;
        }
        return embeddedDropSiteEntry.getSite(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDropSite(long l) {
        if (l == 0L) {
            throw new IllegalArgumentException();
        }
        XDropTargetEventProcessor.activate();
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            long l2 = this.getToplevelWindow(l);
            if (l2 == 0L) {
                this.addDelayedRegistrationEntry(l);
                return;
            }
            if (l2 == l) {
                Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
                while (iterator.hasNext()) {
                    XDropTargetProtocol xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
                    xDropTargetProtocol.registerDropTarget(l2);
                }
            } else {
                this.registerEmbeddedDropSite(l2, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDropSite(long l) {
        if (l == 0L) {
            throw new IllegalArgumentException();
        }
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
            this.removeDelayedRegistrationEntry(l);
            while (iterator.hasNext()) {
                XDropTargetProtocol xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
                xDropTargetProtocol.unregisterDropTarget(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDelayedRegistrationEntry(final long l) {
        Long l2 = new Long(l);
        Runnable runnable = new Runnable(){

            public void run() {
                XDropTargetRegistry.this.removeDelayedRegistrationEntry(l);
                XDropTargetRegistry.this.registerDropSite(l);
            }
        };
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            this.removeDelayedRegistrationEntry(l);
            this.delayedRegistrationMap.put(l2, runnable);
            XToolkit.schedule(runnable, 200L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDelayedRegistrationEntry(long l) {
        Long l2 = new Long(l);
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            Runnable runnable = this.delayedRegistrationMap.remove(l2);
            if (runnable != null) {
                XToolkit.remove(runnable);
            }
        }
    }

    private static final class EmbeddedDropSiteEntry {
        private final long root;
        private final long event_mask;
        private final List sites = new ArrayList();

        public EmbeddedDropSiteEntry(long l, long l2) {
            this.root = l;
            this.event_mask = l2;
        }

        public long getRoot() {
            return this.root;
        }

        public long getEventMask() {
            return this.event_mask;
        }

        public void addSite(long l) {
            Long l2 = new Long(l);
            if (!this.sites.contains(l2)) {
                this.sites.add(l2);
            }
        }

        public void removeSite(long l) {
            Long l2 = new Long(l);
            this.sites.remove(l2);
        }

        public boolean hasSites() {
            return this.sites.isEmpty();
        }

        public long[] getSites() {
            long[] lArray = new long[this.sites.size()];
            Iterator iterator = this.sites.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Long l = (Long)iterator.next();
                lArray[n++] = l;
            }
            return lArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getSite(int n, int n2) {
            assert (Thread.holdsLock(XToolkit.getAWTLock()));
            for (Long l : this.sites) {
                long l2 = l;
                XTranslateCoordinates xTranslateCoordinates = new XTranslateCoordinates(this.getRoot(), l2, n, n2);
                try {
                    int n3 = xTranslateCoordinates.execute(XToolkit.IgnoreBadWindowHandler);
                    if (n3 == 0 || XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) continue;
                    int n4 = xTranslateCoordinates.get_dest_x();
                    int n5 = xTranslateCoordinates.get_dest_y();
                    if (n4 < 0 || n5 < 0) continue;
                    XWindowAttributes xWindowAttributes = new XWindowAttributes();
                    try {
                        XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
                        n3 = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l2, xWindowAttributes.pData);
                        XToolkit.RESTORE_XERROR_HANDLER();
                        if (n3 == 0 || XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0 || xWindowAttributes.get_map_state() == 0 || n4 >= xWindowAttributes.get_width() || n5 >= xWindowAttributes.get_height()) continue;
                        long l3 = l2;
                        return l3;
                    }
                    finally {
                        xWindowAttributes.dispose();
                    }
                }
                finally {
                    xTranslateCoordinates.dispose();
                }
            }
            return 0L;
        }
    }
}

