/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import com.sun.jmx.trace.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.loading.MLetContent;

class MLetParser {
    private int c;
    private static String tag = "mlet";
    private String dbgTag = "MLetParser";

    public void skipSpace(Reader reader) throws IOException {
        while (this.c >= 0 && (this.c == 32 || this.c == 9 || this.c == 10 || this.c == 13)) {
            this.c = reader.read();
        }
    }

    public String scanIdentifier(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.c >= 97 && this.c <= 122 || this.c >= 65 && this.c <= 90 || this.c >= 48 && this.c <= 57 || this.c == 95) {
            stringBuffer.append((char)this.c);
            this.c = reader.read();
        }
        return stringBuffer.toString();
    }

    public Hashtable scanTag(Reader reader) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        this.skipSpace(reader);
        while (this.c >= 0 && this.c != 62) {
            String string = this.scanIdentifier(reader);
            String string2 = "";
            this.skipSpace(reader);
            if (this.c == 61) {
                int n = -1;
                this.c = reader.read();
                this.skipSpace(reader);
                if (this.c == 39 || this.c == 34) {
                    n = this.c;
                    this.c = reader.read();
                }
                StringBuffer stringBuffer = new StringBuffer();
                while (this.c > 0 && (n < 0 && this.c != 32 && this.c != 9 && this.c != 10 && this.c != 13 && this.c != 62 || n >= 0 && this.c != n)) {
                    stringBuffer.append((char)this.c);
                    this.c = reader.read();
                }
                if (this.c == n) {
                    this.c = reader.read();
                }
                this.skipSpace(reader);
                string2 = stringBuffer.toString();
            }
            hashtable.put(string.toLowerCase(), string2);
            this.skipSpace(reader);
        }
        return hashtable;
    }

    public Vector parse(URL uRL) throws IOException {
        Vector<MLetContent> vector;
        BufferedReader bufferedReader;
        block16: {
            String string = "parse";
            String string2 = "<param name=... value=...> tag requires name parameter.";
            String string3 = "<param> tag outside <mlet> ... </mlet>.";
            String string4 = "<mlet> tag requires either code or object parameter.";
            String string5 = "<mlet> tag requires archive parameter.";
            URLConnection uRLConnection = uRL.openConnection();
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream(), "UTF-8"));
            uRL = uRLConnection.getURL();
            vector = new Vector<MLetContent>();
            Hashtable hashtable = null;
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            while (true) {
                String string6;
                this.c = ((Reader)bufferedReader).read();
                if (this.c == -1) break block16;
                if (this.c != 60) continue;
                this.c = ((Reader)bufferedReader).read();
                if (this.c == 47) {
                    this.c = ((Reader)bufferedReader).read();
                    string6 = this.scanIdentifier(bufferedReader);
                    if (!string6.equalsIgnoreCase(tag)) continue;
                    if (hashtable != null) {
                        if (vector2.size() == vector3.size() && !vector2.isEmpty() && !vector3.isEmpty()) {
                            hashtable.put("types", vector2.clone());
                            hashtable.put("values", vector3.clone());
                        }
                        vector.addElement(new MLetContent(uRL, hashtable));
                    }
                    hashtable = null;
                    vector2.removeAllElements();
                    vector3.removeAllElements();
                    continue;
                }
                string6 = this.scanIdentifier(bufferedReader);
                if (string6.equalsIgnoreCase("arg")) {
                    Hashtable hashtable2 = this.scanTag(bufferedReader);
                    String string7 = (String)hashtable2.get("type");
                    if (string7 == null) {
                        if (this.isTraceOn()) {
                            this.trace(string, string2);
                        }
                        throw new IOException(string2);
                    }
                    if (hashtable == null) {
                        if (this.isTraceOn()) {
                            this.trace(string, string3);
                        }
                        throw new IOException(string3);
                    }
                    vector2.addElement(string7);
                    String string8 = (String)hashtable2.get("value");
                    if (string8 == null) {
                        if (this.isTraceOn()) {
                            this.trace(string, string2);
                        }
                        throw new IOException(string2);
                    }
                    if (hashtable != null) {
                        vector3.addElement(string8);
                        continue;
                    }
                    if (this.isTraceOn()) {
                        this.trace(string, string3);
                    }
                    throw new IOException(string3);
                }
                if (!string6.equalsIgnoreCase(tag)) continue;
                hashtable = this.scanTag(bufferedReader);
                if (hashtable.get("code") == null && hashtable.get("object") == null) {
                    if (this.isTraceOn()) {
                        this.trace(string, string4);
                    }
                    hashtable = null;
                    throw new IOException(string4);
                }
                if (hashtable.get("archive") == null) break;
            }
            if (this.isTraceOn()) {
                this.trace(string, string5);
            }
            hashtable = null;
            throw new IOException(string5);
        }
        ((Reader)bufferedReader).close();
        return vector;
    }

    public Vector parseURL(String string) throws IOException {
        URL uRL = null;
        if (string.indexOf(58) <= 1) {
            String string2 = System.getProperty("user.dir");
            String string3 = string2.charAt(0) == '/' || string2.charAt(0) == File.separatorChar ? "file:" : "file:/";
            uRL = new URL(string3 + string2.replace(File.separatorChar, '/') + "/");
            uRL = new URL(uRL, string);
        } else {
            uRL = new URL(string);
        }
        return this.parse(uRL);
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 2);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 2, string, string2, string3);
    }

    private void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 2);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 2, string, string2, string3);
    }

    private void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }
}

