/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;

public class GTKEngine {
    static final GTKEngine INSTANCE = new GTKEngine();
    static final int[] DEFAULT_FOCUS_PATTERN = new int[]{1, 1};

    static int adjustAxisForComponentOrientation(JComponent jComponent, int n) {
        if (jComponent.getComponentOrientation().isLeftToRight()) {
            return n;
        }
        switch (n) {
            case 3: {
                return 7;
            }
            case 7: {
                return 3;
            }
        }
        return n;
    }

    public void paintArrow(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        int n8 = n6 / 4 + 1;
        int n9 = n7 / 4 + 1;
        int n10 = Math.max(2, Math.min(n8, n9));
        switch (n3) {
            case 100: 
            case 101: {
                n4 += (n6 - n10 * 2 + 1) / 2;
                n5 += (n7 - n10) / 2;
                break;
            }
            case 102: 
            case 103: {
                n4 += (n6 - n10) / 2;
                n5 += (n7 - n10 * 2 + 1) / 2;
            }
        }
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n11 = n10 * 2 - 2;
        graphics.translate(n4, n5);
        if (n == 8) {
            graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.WHITE));
        } else {
            graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.FOREGROUND));
        }
        switch (n3) {
            case 100: {
                for (int i = 0; i < n10; ++i) {
                    graphics.drawLine(i, n10 - i - 1, n11 - i, n10 - i - 1);
                }
                break;
            }
            case 101: {
                for (int i = 0; i < n10; ++i) {
                    graphics.drawLine(i, i, n11 - i, i);
                }
                break;
            }
            case 102: {
                int n12 = 0;
                int n13 = n10 - 1;
                while (n13 >= 0) {
                    graphics.drawLine(n13, n12, n13, n11 - n12);
                    --n13;
                    ++n12;
                }
                break;
            }
            case 103: {
                for (int i = 0; i < n10; ++i) {
                    graphics.drawLine(i, i, i, n11 - i);
                }
                break;
            }
        }
        graphics.translate(-n4, -n5);
    }

    public void paintBox(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        Region region = synthContext.getRegion();
        if (string == "menuitem" && n == 2 && GTKLookAndFeel.is2_2()) {
            this.paintBackground(synthContext, graphics, n, gTKStyle.getGTKColor(synthContext.getComponent(), region, 2, GTKColorType.BACKGROUND), n3, n4, n5, n6);
        } else {
            this.paintBackground(synthContext, graphics, n, gTKStyle.getGTKColor(synthContext.getComponent(), region, n, GTKColorType.BACKGROUND), n3, n4, n5, n6);
        }
        this.paintShadow(synthContext, graphics, n, n2, string, n3, n4, n5, n6);
    }

    public void paintBoxGap(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this._paintBoxGap(synthContext, graphics, n, n2, n3, n4, n5, n6, n7, n8, n9, GTKColorType.BACKGROUND, GTKColorType.LIGHT, GTKColorType.BLACK, GTKColorType.DARK, false);
    }

    void _paintBoxGap(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ColorType colorType, ColorType colorType2, ColorType colorType3, ColorType colorType4, boolean bl) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        JComponent jComponent = synthContext.getComponent();
        Region region = synthContext.getRegion();
        this.paintBackground(synthContext, graphics, n, gTKStyle.getGTKColor(jComponent, region, n, colorType), n3, n4, n5, n6);
        int n10 = n8 + n9;
        Color color = gTKStyle.getGTKColor(jComponent, region, n, colorType2);
        Color color2 = gTKStyle.getGTKColor(jComponent, region, n, colorType3);
        Color color3 = gTKStyle.getGTKColor(jComponent, region, n, colorType4);
        Color color4 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.WHITE);
        graphics.translate(n3, n4);
        if (n7 == 2) {
            graphics.setColor(color2);
            graphics.drawLine(0, n6 - 1, n5 - 1, n6 - 1);
            graphics.setColor(color3);
            graphics.drawLine(1, n6 - 2, n5 - 2, n6 - 2);
            graphics.setColor(color);
            graphics.drawLine(0, 0, 0, n6 - 2);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(1, 0, 1, n6 - 3);
            }
            graphics.setColor(color2);
            graphics.drawLine(n5 - 1, 0, n5 - 1, n6 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n5 - 2, 0, n5 - 2, n6 - 2);
            if (n8 > 1) {
                graphics.setColor(color);
                graphics.drawLine(0, 0, n8 - 2, 0);
            }
            graphics.setColor(color);
            graphics.drawLine(n10 - 1, 0, n5 - 2, 0);
            if (bl) {
                graphics.setColor(color4);
                if (n8 > 0) {
                    graphics.drawLine(0, 1, n8, 1);
                }
                graphics.drawLine(n10, 1, n5 - 2, 1);
            }
        } else if (n7 == 3) {
            graphics.setColor(color);
            graphics.drawLine(0, 0, n5 - 1, 0);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(0, 1, n5 - 1, 1);
            }
            graphics.setColor(color);
            graphics.drawLine(0, 0, 0, n6 - 1);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(1, 1, 1, n6 - 2);
            }
            graphics.setColor(color2);
            graphics.drawLine(n5 - 1, 0, n5 - 1, n6 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n5 - 2, 1, n5 - 2, n6 - 2);
            if (n8 > 1) {
                graphics.setColor(color2);
                graphics.drawLine(0, n6 - 1, n8 - 2, n6 - 1);
                graphics.setColor(color3);
                graphics.drawLine(n8 - 1, n6 - 1, n8 - 1, n6 - 1);
                graphics.drawLine(1, n6 - 2, n8 - 2, n6 - 2);
            }
            graphics.setColor(color2);
            graphics.drawLine(n10 - 1, n6 - 1, n5 - 1, n6 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n10 - 2, n6 - 1, n10 - 2, n6 - 1);
            graphics.drawLine(n10 - 1, n6 - 2, n5 - 2, n6 - 2);
        } else if (n7 == 1) {
            graphics.setColor(color);
            graphics.drawLine(0, 0, n5 - 1, 0);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(0, 1, n5 - 1, 1);
            }
            graphics.setColor(color2);
            graphics.drawLine(0, n6 - 1, n5 - 1, n6 - 1);
            graphics.setColor(color3);
            graphics.drawLine(1, n6 - 2, n5 - 2, n6 - 2);
            graphics.setColor(color);
            graphics.drawLine(0, 0, 0, n6 - 2);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(1, 1, 1, n6 - 3);
            }
            if (n8 > 1) {
                graphics.setColor(color2);
                graphics.drawLine(n5 - 1, 0, n5 - 1, n8 - 2);
                graphics.setColor(color3);
                graphics.drawLine(n5 - 1, n8 - 1, n5 - 1, n8 - 1);
                graphics.drawLine(n5 - 2, 1, n5 - 2, n8 - 2);
            }
            graphics.setColor(color2);
            graphics.drawLine(n5 - 1, n10 - 1, n5 - 1, n6 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n5 - 1, n10 - 2, n5 - 1, n10 - 2);
            graphics.drawLine(n5 - 2, n10 - 1, n5 - 2, n6 - 2);
        } else if (n7 == 0) {
            graphics.setColor(color);
            graphics.drawLine(0, 0, n5 - 2, 0);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(0, 1, n5 - 2, 1);
            }
            graphics.setColor(color2);
            graphics.drawLine(0, n6 - 1, n5 - 1, n6 - 1);
            graphics.setColor(color3);
            graphics.drawLine(1, n6 - 2, n5 - 2, n6 - 2);
            graphics.setColor(color2);
            graphics.drawLine(n5 - 1, 1, n5 - 1, n6 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n5 - 2, 0, n5 - 2, n6 - 2);
            if (n8 > 1) {
                graphics.setColor(color);
                graphics.drawLine(0, 0, 0, n8 - 2);
            }
            graphics.setColor(color);
            graphics.drawLine(0, n10 - 1, 0, n6 - 2);
            if (bl) {
                graphics.setColor(color4);
                if (n8 > 1) {
                    graphics.drawLine(1, 0, 1, n8 - 1);
                }
                graphics.drawLine(1, n10 - 1, 1, n6 - 3);
            }
        }
        graphics.translate(-n3, -n4);
    }

    public void paintCheck(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = synthContext.getComponentState();
        JComponent jComponent = synthContext.getComponent();
        Region region = synthContext.getRegion();
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        if ("checkbutton" == string) {
            n7 = (n8 & 4) == 0 ? 1 : 4;
            this.paintFlatBoxText(synthContext, graphics, n7, string, n3, n4, n5, n6);
            this.paintShadow(synthContext, graphics, n7, 0, string, n3, n4, n5, n6);
        }
        graphics.translate(n3, n4);
        n7 = n6 / 2 - 1;
        if ((n8 & 0x200) != 0) {
            graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.FOREGROUND));
            graphics.drawLine(3, n7 + 2, 4, n7 + 2);
            graphics.drawLine(5, n7 + 3, 6, n7 + 3);
            graphics.drawLine(6, n7 + 2, 6, n7 + 4);
            graphics.drawLine(7, n7 + 1, 7, n7);
            graphics.drawLine(7, n7, 8, n7);
            graphics.drawLine(8, n7, 8, n7 - 1);
            graphics.drawLine(8, n7 - 1, 9, n7 - 1);
            graphics.drawLine(9, n7 - 1, 9, n7 - 2);
            if (!GTKLookAndFeel.is2_2()) {
                if ((n8 & 4) != 0) {
                    graphics.setColor(gTKStyle.getGTKColor(jComponent, region, 4, GTKColorType.DARK));
                } else {
                    graphics.setColor(gTKStyle.getGTKColor(jComponent, region, 1, GTKColorType.DARK));
                }
            }
            graphics.drawLine(3, n7 + 1, 4, n7 + 1);
            graphics.drawLine(4, n7 + 3, 4, n7 + 3);
            graphics.drawLine(5, n7 + 2, 5, n7 + 2);
            graphics.drawLine(6, n7 + 1, 6, n7 + 1);
            graphics.drawLine(7, n7 + 2, 7, n7 + 2);
            graphics.drawLine(10, n7 - 2, 10, n7 - 2);
        }
        graphics.translate(-n3, -n4);
    }

    public void paintExtension(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8) {
        this._paintExtension(synthContext, graphics, n, n2, n3, n4, n5, n6, n7, GTKColorType.LIGHT, GTKColorType.BACKGROUND, GTKColorType.BLACK, GTKColorType.DARK, false, n8);
    }

    void _paintExtension(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, ColorType colorType, ColorType colorType2, ColorType colorType3, ColorType colorType4, boolean bl, int n8) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        JComponent jComponent = synthContext.getComponent();
        Region region = synthContext.getRegion();
        int n9 = gTKStyle.getXThickness();
        int n10 = gTKStyle.getYThickness();
        if (n9 < 0 && n10 < 0) {
            return;
        }
        Color color = gTKStyle.getGTKColor(jComponent, region, n, colorType);
        Color color2 = gTKStyle.getGTKColor(jComponent, region, n, colorType2);
        Color color3 = gTKStyle.getGTKColor(jComponent, region, n, colorType3);
        Color color4 = gTKStyle.getGTKColor(jComponent, region, n, colorType4);
        Color color5 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.WHITE);
        int n11 = ((JTabbedPane)jComponent).getSelectedIndex();
        graphics.translate(n3, n4);
        if (n7 == 3) {
            this.paintBackground(synthContext, graphics, n, color2, 0, 1, n5, n6);
            if (n8 == n11 || n8 == 0) {
                graphics.setColor(color);
                graphics.drawLine(0, 1, 0, n6 - 1);
                graphics.drawLine(1, 0, n5 - 2, 0);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(1, 1, 1, n6 - 1);
                    graphics.drawLine(1, 1, n5 - 3, 1);
                }
            } else {
                graphics.setColor(color);
                graphics.drawLine(0, 0, n5 - 2, 0);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(0, 1, n5 - 3, 1);
                }
            }
            if (n8 + 1 != n11) {
                graphics.setColor(color4);
                graphics.drawLine(n5 - 2, 2, n5 - 2, n6 - 1);
                graphics.setColor(color3);
                graphics.drawLine(n5 - 1, 1, n5 - 1, n6 - 1);
            }
        } else if (n7 == 2) {
            this.paintBackground(synthContext, graphics, n, color2, 0, 0, n5, n6 - 1);
            if (n8 == n11 || n8 == 0) {
                graphics.setColor(color);
                graphics.drawLine(0, 0, 0, n6 - 2);
                graphics.setColor(color3);
                graphics.drawLine(1, n6 - 1, n5 - 2, n6 - 1);
                graphics.setColor(color4);
                graphics.drawLine(2, n6 - 2, n5 - 2, n6 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(1, 0, 1, n6 - 2);
                }
            } else {
                graphics.setColor(color3);
                graphics.drawLine(0, n6 - 1, n5 - 2, n6 - 1);
                graphics.setColor(color4);
                graphics.drawLine(0, n6 - 2, n5 - 2, n6 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(0, 0, 0, n6 - 2);
                }
            }
            if (n8 + 1 != n11) {
                graphics.setColor(color3);
                graphics.drawLine(n5 - 1, 0, n5 - 1, n6 - 2);
                graphics.setColor(color4);
                graphics.drawLine(n5 - 2, 0, n5 - 2, n6 - 2);
            }
        } else if (n7 == 1) {
            this.paintBackground(synthContext, graphics, n, color2, 1, 0, n5, n6);
            if (n8 == n11 || n8 == 0) {
                graphics.setColor(color);
                graphics.drawLine(1, 0, n5 - 1, 0);
                graphics.drawLine(0, 1, 0, n6 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(1, 1, n5, 1);
                    graphics.drawLine(1, 1, 1, n6 - 3);
                }
            } else {
                graphics.setColor(color);
                graphics.drawLine(0, 0, 0, n6 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(1, 1, 1, n6 - 3);
                }
            }
            if (n8 + 1 != n11) {
                graphics.setColor(color3);
                graphics.drawLine(1, n6 - 1, n5 - 1, n6 - 1);
                graphics.setColor(color4);
                graphics.drawLine(2, n6 - 2, n5 - 1, n6 - 2);
            }
        } else if (n7 == 0) {
            this.paintBackground(synthContext, graphics, n, color2, 0, 0, n5 - 1, n6);
            if (n8 == n11 || n8 == 0) {
                graphics.setColor(color);
                graphics.drawLine(0, 0, n5 - 2, 0);
                graphics.setColor(color3);
                graphics.drawLine(n5 - 1, 1, n5 - 1, n6 - 2);
                graphics.setColor(color4);
                graphics.drawLine(n5 - 2, 2, n5 - 2, n6 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(0, 1, n5 - 2, 1);
                    graphics.drawLine(n5 - 2, 1, n5 - 2, n6 - 3);
                }
            } else {
                graphics.setColor(color3);
                graphics.drawLine(n5 - 1, 0, n5 - 1, n6 - 2);
                graphics.setColor(color4);
                graphics.drawLine(n5 - 2, 0, n5 - 2, n6 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(n5 - 2, 1, n5 - 2, n6 - 3);
                }
            }
            if (n8 + 1 != n11) {
                graphics.setColor(color3);
                graphics.drawLine(0, n6 - 1, n5 - 2, n6 - 1);
                graphics.setColor(color4);
                graphics.drawLine(0, n6 - 2, n5 - 2, n6 - 2);
            }
        }
        graphics.translate(-n3, -n4);
    }

    void paintFlatBoxNormal(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.BACKGROUND));
        this.paintFlatBox(synthContext, graphics, n, string, n2, n3, n4, n5);
    }

    void paintFlatBoxText(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.TEXT_BACKGROUND));
        this.paintFlatBox(synthContext, graphics, n, string, n2, n3, n4, n5);
    }

    public void paintFlatBox(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        if (string == "cell_odd") {
            graphics.fillRect(n2, n3, n4, n5);
        } else {
            this.paintBackground(synthContext, graphics, n, graphics.getColor(), n2, n3, n4, n5);
        }
        if (string == "tooltip") {
            graphics.setColor(Color.BLACK);
            graphics.drawRect(n2, n3, n4 - 1, n5 - 1);
        }
    }

    public void paintFocus(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int[] nArray = (int[])gTKStyle.getClassSpecificValue(synthContext, "focus-line-pattern");
        int n6 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        if (nArray == null) {
            nArray = DEFAULT_FOCUS_PATTERN;
        }
        if (n6 <= 0) {
            return;
        }
        graphics.setColor(this.getFocusColor(synthContext, n));
        this._paintFocus(graphics, n2, n3, n4, n5, nArray, n6);
    }

    void _paintFocus(Graphics graphics, int n, int n2, int n3, int n4, int[] nArray, int n5) {
        int n6;
        graphics.translate(n, n2);
        int n7 = n6 = n5 / 2;
        int n8 = 0;
        int n9 = n3 - n5;
        int n10 = n9 + n4 - n5;
        int n11 = n10 + n3 - n5;
        int n12 = n11 + n4;
        while (n7 < n12) {
            int n13 = n7 + nArray[n8];
            if (n8 % 2 == 0) {
                int n14;
                int n15;
                if (n7 < n9) {
                    graphics.fillRect(n7, 0, Math.min(n13, n3) - n7, n5);
                    n7 = Math.min(n13, n9);
                }
                if (n7 != n13 && n7 < n10) {
                    graphics.fillRect(n3 - n5, n7 - n9, n5, Math.min(n10, n13) - n7);
                    n7 = Math.min(n10, n13);
                }
                if (n7 != n13 && n7 < n11) {
                    n15 = n3 - (n7 - n10);
                    n14 = Math.min(n13 - n7, n11 - n7);
                    graphics.fillRect(n15 - n14, n4 - n5, n14, n5);
                    n7 += n14;
                }
                if (n7 != n13) {
                    n15 = n4 - (n7 - n11);
                    n14 = Math.min(n13 - n7, n12 - n7);
                    graphics.fillRect(0, n15 - n14, n5, n14);
                    n7 += n14;
                }
            } else {
                n7 = n13;
            }
            n8 = (n8 + 1) % nArray.length;
        }
        graphics.translate(-n, -n2);
    }

    Color getFocusColor(SynthContext synthContext, int n) {
        return ((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, ColorType.FOREGROUND);
    }

    public void paintHandle(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7) {
        this.paintBox(synthContext, graphics, n, n2, string, n3, n4, n5, n6);
        graphics.translate(n3, n4);
        Region region = synthContext.getRegion();
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        JComponent jComponent = synthContext.getComponent();
        Color color = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.LIGHT);
        Color color2 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.DARK);
        Color color3 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.BLACK);
        if (string == "paned") {
            int n8;
            int n9;
            JSplitPane jSplitPane = (JSplitPane)jComponent;
            int n10 = 33;
            if (n7 == 0) {
                n9 = n5 / 2 - n10 / 2;
                n8 = jSplitPane.getDividerSize() / 2 - 1;
            } else {
                n9 = jSplitPane.getDividerSize() / 2 - 1;
                n8 = n6 / 2 - n10 / 2;
            }
            for (int i = 0; i < 7; ++i) {
                if (n7 == 0) {
                    n9 += 5;
                } else {
                    n8 += 5;
                }
                graphics.setColor(color);
                graphics.fillRect(n9, n8, 2, 2);
                graphics.setColor(color3);
                graphics.fillRect(n9 + 1, n8 + 1, 2, 2);
                graphics.setColor(color2);
                graphics.fillRect(n9 + 1, n8 + 1, 1, 1);
            }
        } else if (string == "handlebox") {
            int n11;
            int n12;
            JToolBar jToolBar = (JToolBar)jComponent;
            if (jToolBar.getOrientation() == 0) {
                for (n12 = 2; n12 < n6; n12 += 3) {
                    graphics.setColor(color2);
                    graphics.fillRect(n11 + 1, n12 + 1, 2, 2);
                    graphics.fillRect(n11 + 4, n12 + 2, 2, 2);
                    graphics.setColor(color);
                    graphics.fillRect(n11, n12, 2, 2);
                    graphics.fillRect(n11 + 3, n12 + 1, 2, 2);
                }
            } else {
                boolean bl = true;
                for (n11 = 2; n11 < n5; n11 += 3) {
                    graphics.setColor(color2);
                    graphics.fillRect(n11 + 1, n12 + 1, 2, 2);
                    graphics.fillRect(n11 + 1, n12 + 4, 2, 2);
                    graphics.setColor(color);
                    graphics.fillRect(n11, n12, 2, 2);
                    graphics.fillRect(n11, n12 + 3, 2, 2);
                    if (bl) {
                        ++n12;
                        bl = false;
                        continue;
                    }
                    --n12;
                    bl = true;
                }
            }
            this.paintShadow(synthContext, graphics, n, n2, string, 0, 0, n5, n6);
        }
        graphics.translate(-n3, -n4);
    }

    public void paintOption(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        graphics.translate(n3, n4);
        int n7 = synthContext.getComponentState();
        int n8 = n6 / 2 - 1;
        JComponent jComponent = synthContext.getComponent();
        Region region = synthContext.getRegion();
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n9 = (n7 & 4) == 0 ? 1 : 4;
        graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n9, GTKColorType.TEXT_BACKGROUND));
        if (region != Region.RADIO_BUTTON_MENU_ITEM) {
            graphics.fillRect(3, n8 - 3, 9, 9);
            graphics.fillRect(13, n8 - 1, 1, 4);
            graphics.fillRect(12, n8 + 3, 1, 2);
            graphics.fillRect(9, n8 + 6, 2, 1);
            graphics.fillRect(5, n8 + 7, 4, 1);
            graphics.setColor(gTKStyle.getGTKColor(jComponent, region, 1, GTKColorType.DARK));
            graphics.fillRect(5, n8 - 5, 4, 1);
            graphics.fillRect(3, n8 - 4, 3, 1);
            graphics.fillRect(2, n8 - 3, 1, 2);
            graphics.fillRect(1, n8 - 1, 1, 4);
            graphics.fillRect(2, n8 + 4, 1, 1);
            graphics.fillRect(3, n8 + 5, 2, 1);
            graphics.fillRect(5, n8 + 6, 4, 1);
            graphics.fillRect(9, n8 + 5, 2, 1);
            graphics.fillRect(11, n8 + 3, 1, 2);
            graphics.fillRect(12, n8 - 1, 1, 4);
            graphics.fillRect(11, n8 - 3, 1, 2);
            graphics.fillRect(10, n8 - 4, 1, 1);
            graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.BLACK));
            graphics.fillRect(5, n8 - 4, 5, 1);
            graphics.fillRect(10, n8 - 3, 1, 1);
            graphics.fillRect(3, n8 - 3, 2, 1);
            graphics.fillRect(3, n8 - 2, 1, 1);
            graphics.fillRect(2, n8 - 1, 1, 5);
            graphics.fillRect(3, n8 + 4, 1, 1);
        }
        if ((n7 & 0x200) != 0) {
            graphics.setColor(gTKStyle.getGTKColor(jComponent, region, 1, GTKColorType.FOREGROUND));
            graphics.fillRect(5, n8, 5, 3);
            graphics.fillRect(6, n8 - 1, 3, 1);
            graphics.fillRect(6, n8 + 3, 3, 1);
        }
        graphics.translate(-n3, -n4);
    }

    public void paintShadow(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        if (string == "buttondefault") {
            graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.BLACK));
            graphics.drawRect(n3, n4, n5 - 1, n6 - 1);
            return;
        }
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        JComponent jComponent = synthContext.getComponent();
        Region region = synthContext.getRegion();
        int n7 = gTKStyle.getXThickness();
        int n8 = gTKStyle.getYThickness();
        if (string == "trough" || string == "spinbutton" && jComponent instanceof JButton) {
            n8 = 1;
            n7 = 1;
        }
        if (n7 < 0 && n8 < 0) {
            return;
        }
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        Color color4 = null;
        switch (n2) {
            case 0: {
                if (string == "spinbutton" && jComponent instanceof JButton) {
                    color4 = color = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.DARK);
                    color3 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.BLACK);
                    break;
                }
                color = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.DARK);
                color2 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.BLACK);
                color3 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.LIGHT);
                color4 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.BACKGROUND);
                break;
            }
            case 1: {
                color = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.LIGHT);
                color2 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.BACKGROUND);
                color3 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.BLACK);
                color4 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.DARK);
                break;
            }
        }
        if (string == "spinbutton" && jComponent instanceof JButton) {
            this._paintSpinButtonShadow(graphics, n3, n4, n5, n6, n7, n8, color, color2, color3, color4);
        } else {
            this._paintShadow(graphics, n3, n4, n5, n6, n7, n8, color, color2, color3, color4);
        }
    }

    void _paintShadow(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Color color, Color color2, Color color3, Color color4) {
        graphics.translate(n, n2);
        graphics.setColor(color);
        if (n5 > 0) {
            graphics.drawLine(0, 0, 0, n4 - 1);
        }
        if (n6 > 0) {
            graphics.drawLine(1, 0, n3 - 1, 0);
        }
        if (n5 > 1 || n6 > 1) {
            graphics.setColor(color2);
            if (n5 > 1) {
                graphics.drawLine(1, 1, 1, n4 - 2);
            }
            if (n6 > 1) {
                graphics.drawLine(2, 1, n3 - 2, 1);
            }
        }
        graphics.setColor(color3);
        if (n5 > 0) {
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
        }
        if (n6 > 0) {
            graphics.drawLine(1, n4 - 1, n3 - 2, n4 - 1);
        }
        if (n5 > 1 || n6 > 1) {
            graphics.setColor(color4);
            if (n5 > 1) {
                graphics.drawLine(n3 - 2, 2, n3 - 2, n4 - 2);
            }
            if (n6 > 1) {
                graphics.drawLine(2, n4 - 2, n3 - 3, n4 - 2);
            }
        }
        graphics.translate(-n, -n2);
    }

    void _paintSpinButtonShadow(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Color color, Color color2, Color color3, Color color4) {
        graphics.translate(n, n2);
        graphics.setColor(color);
        graphics.drawLine(0, 0, n3 - 1, 0);
        graphics.setColor(color4);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.setColor(color3);
        graphics.drawLine(0, 0, 0, n4 - 1);
        graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
        graphics.translate(-n, -n2);
    }

    public void paintExpander(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        if (n2 == 0) {
            if (n != 2) {
                this.paintHollowTriangle(synthContext, graphics, n, n3, n4, Math.min(n5, n6), GTKEngine.adjustAxisForComponentOrientation(synthContext.getComponent(), 3));
            }
        } else if (n != 2) {
            this.paintHollowTriangle(synthContext, graphics, n, n3, n4, Math.min(n5, n6), 5);
        }
    }

    private void paintHollowTriangle(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = n4 / 2;
        int n7 = n4 / 2 + 1;
        int n8 = Math.max(1, n4 / 7);
        graphics.translate(n2, n3);
        Color color = gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.FOREGROUND);
        Color color2 = gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.BACKGROUND);
        switch (n5) {
            case 1: {
                int n9;
                int n10;
                int n11 = n4 / 2 + n7 / 2 - 1;
                graphics.setColor(color2);
                for (n10 = n7 - 1; n10 > 0; --n10) {
                    graphics.drawLine(n6 - n10 + 1, n11, n6 + n10 - 1, n11);
                    --n11;
                }
                graphics.setColor(color);
                n11 = n4 / 2 + n7 / 2 - 1;
                int n12 = n8 - 1;
                for (n9 = 0; n9 < n8; ++n9) {
                    graphics.drawLine(0 - n12, n11 - n9, n4 + n12, n11 - n9);
                    --n12;
                }
                --n11;
                for (n10 = n7 - 1; n10 > 0; --n10) {
                    for (n9 = 0; n9 < n8; ++n9) {
                        graphics.drawLine(n6 - n10 + 1 - n9, n11, n6 - n10 + 1 - n9, n11);
                        graphics.drawLine(n6 + n10 - 1 + n9, n11, n6 + n10 - 1 + n9, n11);
                    }
                    --n11;
                }
                if (n8 <= 1) break;
                for (n9 = n8 - 2; n9 >= 0; --n9) {
                    graphics.drawLine(n6 - n9, n11, n6 + n9, n11);
                    --n11;
                }
                break;
            }
            case 5: {
                int n13;
                int n14;
                int n15 = n4 / 2 - n7 / 2 - 1;
                graphics.setColor(color2);
                for (n14 = n7 - 1; n14 > 0; --n14) {
                    graphics.drawLine(n6 - n14 + 1, n15, n6 + n14 - 1, n15);
                    ++n15;
                }
                graphics.setColor(color);
                n15 = n4 / 2 - n7 / 2 - 1;
                int n16 = n8 - 1;
                for (n13 = 0; n13 < n8; ++n13) {
                    graphics.drawLine(0 - n16, n15 + n13, n4 + n16, n15 + n13);
                    --n16;
                }
                ++n15;
                for (n14 = n7 - 1; n14 > 0; --n14) {
                    for (n13 = 0; n13 < n8; ++n13) {
                        graphics.drawLine(n6 - n14 + 1 - n13, n15, n6 - n14 + 1 - n13, n15);
                        graphics.drawLine(n6 + n14 - 1 + n13, n15, n6 + n14 - 1 + n13, n15);
                    }
                    ++n15;
                }
                if (n8 <= 1) break;
                for (n13 = n8 - 2; n13 >= 0; --n13) {
                    graphics.drawLine(n6 - n13, n15, n6 + n13, n15);
                    ++n15;
                }
                break;
            }
            case 7: {
                int n17;
                int n18;
                int n19 = n4 / 2 + n7 / 2 - 1;
                graphics.setColor(color2);
                for (n18 = n7 - 1; n18 > 0; --n18) {
                    graphics.drawLine(n19, n6 - n18 + 1, n19, n6 + n18 - 1);
                    --n19;
                }
                graphics.setColor(color);
                n19 = n4 / 2 + n7 / 2 - 1;
                int n20 = n8 - 1;
                for (n17 = 0; n17 < n8; ++n17) {
                    graphics.drawLine(n19 - n17, 0 - n20, n19 - n17, n4 + n20);
                    --n20;
                }
                --n19;
                for (n18 = n7 - 1; n18 > 0; --n18) {
                    for (n17 = 0; n17 < n8; ++n17) {
                        graphics.drawLine(n19, n6 - n18 + 1 - n17, n19, n6 - n18 + 1 - n17);
                        graphics.drawLine(n19, n6 + n18 - 1 + n17, n19, n6 + n18 - 1 + n17);
                    }
                    --n19;
                }
                if (n8 <= 1) break;
                for (n17 = n8 - 2; n17 >= 0; --n17) {
                    graphics.drawLine(n19, n6 - n17, n19, n6 + n17);
                    --n19;
                }
                break;
            }
            case 3: {
                int n21;
                int n22;
                int n23 = n4 / 2 - n7 / 2 - 1;
                graphics.setColor(color2);
                for (n22 = n7 - 1; n22 > 0; --n22) {
                    graphics.drawLine(n23, n6 - n22 + 1, n23, n6 + n22 - 1);
                    ++n23;
                }
                graphics.setColor(color);
                n23 = n4 / 2 - n7 / 2 - 1;
                int n24 = n8 - 1;
                for (n21 = 0; n21 < n8; ++n21) {
                    graphics.drawLine(n23 + n21, 0 - n24, n23 + n21, n4 + n24);
                    --n24;
                }
                ++n23;
                for (n22 = n7 - 1; n22 > 0; --n22) {
                    for (n21 = 0; n21 < n8; ++n21) {
                        graphics.drawLine(n23, n6 - n22 + 1 - n21, n23, n6 - n22 + 1 - n21);
                        graphics.drawLine(n23, n6 + n22 - 1 + n21, n23, n6 + n22 - 1 + n21);
                    }
                    ++n23;
                }
                if (n8 <= 1) break;
                for (n21 = n8 - 2; n21 >= 0; --n21) {
                    graphics.drawLine(n23, n6 - n21, n23, n6 + n21);
                    ++n23;
                }
                break;
            }
        }
        graphics.translate(-n2, -n3);
    }

    public void paintSlider(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7) {
        this.paintBox(synthContext, graphics, n, n2, string, n3, n4, n5, n6);
        if (synthContext.getRegion() == Region.SLIDER_THUMB) {
            if (n7 == 0) {
                this.paintVline(synthContext, graphics, n, string, n3 + n5 / 2 - 1, n4 + 2, 2, n6 - 4);
            } else {
                this.paintHline(synthContext, graphics, n, string, n3 + 2, n4 + n6 / 2 - 1, n5 - 4, 2);
            }
        }
    }

    public void paintHline(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = n5 / 2;
        if (n5 == 2) {
            n6 = 0;
        }
        graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.DARK));
        graphics.drawLine(0, n6, n4 - 2, n6);
        graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.LIGHT));
        graphics.drawLine(0, n6 + 1, n4 - 1, n6 + 1);
        graphics.drawLine(n4 - 1, n6, n4 - 1, n6 + 1);
        graphics.translate(-n2, -n3);
    }

    public void paintVline(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = n4 / 2;
        graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.DARK));
        graphics.drawLine(n6, 0, n6, n5 - 2);
        graphics.drawLine(n6, 0, n6 + 1, 0);
        graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.LIGHT));
        graphics.drawLine(n6 + 1, 1, n6 + 1, n5 - 1);
        graphics.drawLine(n6, n5 - 1, n6 + 1, n5 - 1);
        graphics.translate(-n2, -n3);
    }

    void paintBackground(SynthContext synthContext, Graphics graphics, int n, Color color, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        if (gTKStyle.fillBackground(synthContext, n)) {
            graphics.setColor(color);
            graphics.fillRect(n2, n3, n4, n5);
        } else {
            int n6;
            int n7;
            Image image = gTKStyle.getBackgroundImage(synthContext, n);
            if (image != null && (n7 = image.getWidth(null)) > 0 && (n6 = image.getHeight(null)) > 0) {
                Serializable serializable;
                int n8 = n2;
                int n9 = n3;
                Container container = synthContext.getComponent().getParent();
                while (container != null && !(container instanceof Window) && !(container instanceof Applet)) {
                    serializable = container.getParent();
                    if (container instanceof JRootPane && !(serializable instanceof Window) && !(serializable instanceof Applet)) {
                        n8 += container.getX();
                        n9 += container.getY();
                    }
                    container = serializable;
                }
                n8 %= n7;
                n9 %= n6;
                serializable = graphics.getClipRect();
                int n10 = ((Rectangle)serializable).x;
                int n11 = ((Rectangle)serializable).y;
                int n12 = n10 + ((Rectangle)serializable).width;
                int n13 = n11 + ((Rectangle)serializable).height;
                int n14 = n9;
                int n15 = n3 + n5;
                for (int i = n3; i < n15; i += n6 - n14) {
                    int n16 = n8;
                    int n17 = n2 + n4;
                    for (int j = n2; j < n17; j += n7 - n16) {
                        int n18 = Math.min(n17, j + n7 - n16);
                        int n19 = Math.min(n15, i + n6 - n14);
                        if (n18 > n10 && n19 > n11 && n12 > j && n13 > i) {
                            graphics.drawImage(image, j, i, n18, n19, n16, n14, n16 + n18 - j, n14 + n19 - i, null);
                        }
                        n16 = 0;
                    }
                    n14 = 0;
                }
            }
        }
    }
}

