/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.net.protocol.jar;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.net.www.protocol.jar.JarURLConnection;
import sun.plugin.cache.JarCache;
import sun.plugin.net.protocol.jar.Handler;
import sun.plugin.util.URLUtil;

public class CachedJarURLConnection
extends JarURLConnection {
    private URL jarFileURL = null;
    private String entryName;
    private JarEntry jarEntry;
    private JarFile jarFile;
    private String contentType;
    private boolean useJarCache = false;

    public CachedJarURLConnection(URL uRL, Handler handler) throws MalformedURLException, IOException {
        super(uRL, handler);
        this.getJarFileURL();
        this.entryName = this.getEntryName();
    }

    public synchronized URL getJarFileURL() {
        if (this.jarFileURL == null) {
            this.jarFileURL = super.getJarFileURL();
            try {
                this.jarFileURL = new URL(URLUtil.canonicalize(this.jarFileURL.toString()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.jarFileURL;
    }

    public JarFile getJarFile() throws IOException {
        this.connect();
        return this.jarFile;
    }

    public JarEntry getJarEntry() throws IOException {
        this.connect();
        return this.jarEntry;
    }

    public void connect() throws IOException {
        if (!this.connected) {
            if (this.getUseCaches()) {
                this.jarFile = JarCache.get(this.jarFileURL);
            }
            if (this.jarFile != null) {
                this.useJarCache = true;
            } else {
                super.connect();
                this.jarFile = super.getJarFile();
            }
            if (this.entryName != null) {
                this.jarEntry = this.jarFile.getJarEntry(this.entryName);
                if (this.jarEntry == null) {
                    throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName());
                }
            }
            this.connected = true;
        }
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        if (!this.useJarCache) {
            return super.getInputStream();
        }
        InputStream inputStream = null;
        if (this.entryName == null) {
            throw new IOException("no entry name specified");
        }
        if (this.jarEntry == null) {
            throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName());
        }
        inputStream = this.jarFile.getInputStream(this.jarEntry);
        return inputStream;
    }

    public Object getContent() throws IOException {
        Object object = null;
        this.connect();
        if (!this.useJarCache) {
            return super.getContent();
        }
        object = this.entryName == null ? this.getJarFile() : super.getContent();
        return object;
    }

    public String getContentType() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this.useJarCache) {
            return super.getContentType();
        }
        if (this.contentType == null) {
            if (this.entryName == null) {
                this.contentType = "x-java/jar";
            } else {
                try {
                    this.connect();
                    InputStream inputStream = this.getJarFile().getInputStream(this.jarEntry);
                    this.contentType = CachedJarURLConnection.guessContentTypeFromStream(new BufferedInputStream(inputStream));
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.contentType == null) {
                this.contentType = CachedJarURLConnection.guessContentTypeFromName(this.entryName);
            }
            if (this.contentType == null) {
                this.contentType = "content/unknown";
            }
        }
        return this.contentType;
    }

    public int getContentLength() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this.useJarCache) {
            return super.getContentLength();
        }
        if (this.jarEntry != null) {
            return (int)this.jarEntry.getSize();
        }
        return -1;
    }
}

