/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ObjectStreamException;
import java.net.InetAddress;
import java.util.Arrays;

public final class Inet4Address
extends InetAddress {
    static final long serialVersionUID = 3286316764910316507L;

    private Object writeReplace() throws ObjectStreamException {
        return new InetAddress(this.addr, this.hostName);
    }

    Inet4Address(byte[] addr, String host) {
        super(addr, host);
    }

    public boolean isMulticastAddress() {
        return (this.addr[0] & 0xF0) == 224;
    }

    public boolean isLoopbackAddress() {
        return this.addr[0] == 127;
    }

    public boolean isAnyLocalAddress() {
        byte[] anylocal = new byte[]{0, 0, 0, 0};
        return Arrays.equals(this.addr, anylocal);
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        if (this.addr[0] == 10) {
            return true;
        }
        if (this.addr[0] == 172 && (this.addr[1] & 0xF0) == 1) {
            return true;
        }
        return this.addr[0] == 192 && this.addr[1] == 168;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return this.addr[0] == 224 && this.addr[1] == 0 && this.addr[2] == 0;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public byte[] getAddress() {
        return this.addr;
    }

    public String getHostAddress() {
        StringBuffer sbuf = new StringBuffer(40);
        int len = this.addr.length;
        int i = 0;
        while (true) {
            sbuf.append(this.addr[i] & 0xFF);
            if (++i == len) break;
            sbuf.append('.');
        }
        return sbuf.toString();
    }

    public int hashCode() {
        int i;
        int hash = 0;
        int len = this.addr.length;
        int n = i = len > 4 ? len - 4 : 0;
        while (i < len) {
            hash = hash << 8 | this.addr[i] & 0xFF;
            ++i;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InetAddress)) {
            return false;
        }
        byte[] addr1 = this.addr;
        byte[] addr2 = ((InetAddress)obj).addr;
        if (addr1.length != addr2.length) {
            return false;
        }
        int i = addr1.length;
        while (--i >= 0) {
            if (addr1[i] == addr2[i]) continue;
            return false;
        }
        return true;
    }
}

