/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.DisplayMode;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.Window;

public abstract class GraphicsDevice {
    public static final int TYPE_RASTER_SCREEN = 0;
    public static final int TYPE_PRINTER = 1;
    public static final int TYPE_IMAGE_BUFFER = 2;
    private Window full_screen;
    private DisplayMode mode;

    protected GraphicsDevice() {
    }

    public abstract int getType();

    public abstract String getIDstring();

    public abstract GraphicsConfiguration[] getConfigurations();

    public abstract GraphicsConfiguration getDefaultConfiguration();

    public GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate template) {
        return template.getBestConfiguration(this.getConfigurations());
    }

    public boolean isFullScreenSupported() {
        return true;
    }

    public synchronized void setFullScreenWindow(Window w) {
        if (this.full_screen != null) {
            // empty if block
        }
        this.full_screen = w;
        throw new Error("not implemented");
    }

    public Window getFullScreenWindow() {
        return this.full_screen;
    }

    public boolean isDisplayChangeSupported() {
        return false;
    }

    public void setDisplayMode(DisplayMode mode) {
        int i;
        DisplayMode[] array = this.getDisplayModes();
        if (!this.isDisplayChangeSupported()) {
            throw new UnsupportedOperationException();
        }
        int n = i = array == null ? 0 : array.length;
        while (--i >= 0 && !array[i].equals(mode)) {
        }
        if (i < 0) {
            throw new IllegalArgumentException();
        }
        this.mode = mode;
    }

    public DisplayMode getDisplayMode() {
        return this.mode;
    }

    public DisplayMode[] getDisplayModes() {
        return new DisplayMode[0];
    }

    public int getAvailableAcceleratedMemory() {
        return 0;
    }
}

