/*-
 * sigFromName.c --
 *	Signal number and name mapping
 *
 * Copyright (c) 1982 Regents of the University of California.
 * Copyright (c) 1992 by Andreas Stolcke
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * and Andreas Stolcke make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 */
#ifndef lint
static char *rcsid =
"$Id: sigFromName.c,v 1.1 1994/05/18 17:56:45 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include    <string.h>

#include    "customs.h"

extern struct signal {
    int	signo;			/* OS specific signal number */
    char *name;			/* short signal name */
} signalList[];

/*-
 *-----------------------------------------------------------------------
 * Signal_FromName --
 *	Map a signal name to a SIGNAL_ value.
 *
 * Results:
 *	The SIGNAL_ value.
 *
 * Side Effects:
 *	None.
 *
 *-----------------------------------------------------------------------
 */
int
Signal_FromName (name)
    char	*name;
{
    int signal;

    for (signal = 0; signal < SIGNAL_INVAL; signal++) {
	if (strcmp(signalList[signal].name, name) == 0) {
	    break;
	}
    }
    return (signal);
}

