/*
 * Copyright (C) 2003-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <ctype.h>

#include <errno.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"
#include "constants.h"
#include "types.h"

#include "keybindings.h"

#include "misc.h"
#include "menu.h"
#include "menu_callbacks.h"
#include "glade_main_callbacks.h"
#include "callbacks.h"
#include "dnd.h"
#include "entry.h"
#include "icons.h"
#include "help.h"
#include "monitor.h"
#include "options.h"
#include "refresh.h"
#include "settings.h"
#include "treeview.h"
#include "treestore.h"
#include "widgets.h"
#include "password_dialog.h"
#include "libs/input.h"
#include "print.h"
#include "run.h"
#include "remove.h"
#include "callbacks.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

typedef struct treefind_t {
	GtkTreeView *treeview;
	GtkTreeSelection *selection;
	GtkTreePath *ipath;
	GtkTreePath *prev_path;
	tree_entry_t *en;
	gchar c;
	gchar C;
	gboolean second_letter_match;
	gboolean done;
} treefind_t;

/* XXX: (cleanup) these variables should be treestuff */
static GtkTreeRowReference *Rref=NULL,*Lref=NULL;
extern gboolean easy_mode;

static void status_the_path(GtkTreeView *treeview, GtkTreePath *ipath,tree_entry_t *en)
	    {
		gchar *readable_path;
    		/*GtkTreeModel *treemodel =
		 * gtk_tree_view_get_model(treeview);*/
		
		
		readable_path=g_strdup(FILENAME(en));
		if (IS_NETWORK_TYPE(en->type)&&!IS_SAMBA_SERVER(en->subtype))
			ascii_readable(readable_path);
		print_status_tmp(resolve_icon_small(en), 
				readable_path,
				NULL);
		g_free(readable_path);readable_path=NULL;
		turn_on();
	    }

G_MODULE_EXPORT
void set_path_reference(GtkTreeView *treeview,GtkTreePath *ipath){
    	GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
	if (get_tree_id (treeview) == 0){
		if (Rref) gtk_tree_row_reference_free(Rref);
		if (!ipath) Rref=NULL;
		else Rref= gtk_tree_row_reference_new(treemodel, ipath);
	} else {
		if (Lref) gtk_tree_row_reference_free(Lref);
		if (!ipath) Lref=NULL;
		else Lref= gtk_tree_row_reference_new(treemodel, ipath);
	}
}

static gboolean find_next_row(GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data)
{
    treefind_t *treefind = (treefind_t *) data;
    GtkTreeIter parent;
    gchar *f,*ff;
    tree_entry_t *en;

    if (treefind->done) return FALSE;
    if (!treepath || !treefind->ipath) {
	    TRACE("bailing out 1, keybindings.c\n");
	    treefind->done=TRUE;
	    return TRUE;
    }

    if (gtk_tree_path_compare (treepath,treefind->ipath) <= 0) return FALSE;

    if (gtk_tree_model_iter_parent(treemodel, &parent, iter)){
	    /* this relies on the fact that all children nodes are unexpanded on collapsing an ancestor */
	    GtkTreePath * tpath;
	    tpath=gtk_tree_model_get_path (treemodel,&parent);
	    if (!gtk_tree_view_row_expanded(treefind->treeview,tpath)){
		gtk_tree_path_free(tpath);
		return FALSE;
	    }
	    gtk_tree_path_free(tpath);	    	    
    }
    gtk_tree_model_get(treemodel, iter, NAME_COLUMN, &f, ENTRY_COLUMN, &en, -1);
    if (!f || !strlen(f)) {
	TRACE("treemodel_get returns nothing for name column cell!\n");
	if (f) g_free(f);
	return FALSE;
    }
    ff=f;
    if (treefind->second_letter_match && strlen(f)>1) f++;
    if (*f =='/') f++;
    if (*f == treefind->C || *f == treefind->c){
        gdk_flush();
    	gtk_tree_view_scroll_to_cell(treefind->treeview, treepath, NULL, TRUE, 0.0, 0.0);
	clear_dnd_selection_list();
    	gtk_tree_selection_select_path(treefind->selection,treepath);
        get_dnd_selection(treemodel, treepath, iter, (gpointer) (treefind->treeview));
    	gtk_tree_view_set_cursor (treefind->treeview,treepath,NULL,FALSE);
    	if (en) status_the_path(treefind->treeview,treepath,en);	
    	set_path_reference (treefind->treeview,treepath);
	treefind->done=TRUE;
	g_free(ff);
    	return TRUE;
    } 
    g_free(ff);

    return FALSE;
}

static gboolean find_prev_row(GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data)
{
    treefind_t *treefind = (treefind_t *) data;
    GtkTreeIter parent;
    gchar *f,*ff;
    tree_entry_t *en;

    if (treefind->done) return FALSE;
    if (!treepath || !treefind->ipath) {
	    TRACE("bailing out 2, keybindings.c\n");
	    treefind->done=TRUE;
	    return TRUE;
    }

    if (gtk_tree_path_compare (treepath,treefind->ipath) > 0) return FALSE;
    if (gtk_tree_path_compare (treepath,treefind->ipath) == 0) {
	    if (treefind->prev_path){
		TRACE("previous path found=%s\n",treefind->en->path);
        	gdk_flush();
    		gtk_tree_view_scroll_to_cell(treefind->treeview, treefind->prev_path, NULL, TRUE, 0.0, 0.0);
		clear_dnd_selection_list();
    		gtk_tree_selection_select_path(treefind->selection,treefind->prev_path);
	        get_dnd_selection(treemodel,treefind->prev_path, iter, (gpointer) (treefind->treeview));
    		gtk_tree_view_set_cursor (treefind->treeview,treefind->prev_path,NULL,FALSE);
    		if (treefind->en) status_the_path(treefind->treeview,treefind->prev_path,treefind->en);	
    		set_path_reference (treefind->treeview,treefind->prev_path);
		treefind->done=TRUE;
    	        gtk_tree_path_free(treefind->prev_path);
		treefind->prev_path=NULL;
	    }
	    return TRUE;
    }

    if (gtk_tree_model_iter_parent(treemodel, &parent, iter)){
	    /* this relies on the fact that all children nodes are unexpanded on collapsing an ancestor */
	    GtkTreePath * tpath;
	    tpath=gtk_tree_model_get_path (treemodel,&parent);
	    if (!gtk_tree_view_row_expanded(treefind->treeview,tpath)){
		gtk_tree_path_free(tpath);
		return FALSE;
	    }
	    gtk_tree_path_free(tpath);	    	    
    }
    gtk_tree_model_get(treemodel, iter, NAME_COLUMN, &f, ENTRY_COLUMN, &en, -1);
    if (!f || !strlen(f)) {
	TRACE("treemodel_get returns nothing for name column cell!\n");
	if (f) g_free(f);	
	return FALSE;
    }
    ff=f;
    if (treefind->second_letter_match && strlen(f)>1) f++;
    if (*f =='/') f++;
    if (*f == treefind->C || *f == treefind->c){
        if (treefind->prev_path) gtk_tree_path_free(treefind->prev_path);
	treefind->prev_path=gtk_tree_path_copy(treepath);
        gtk_tree_model_get(treemodel, iter,ENTRY_COLUMN, &(treefind->en), -1);
	TRACE("found %c==%c==%c\n",*f,treefind->C,treefind->c);
	TRACE("treefind->en->path=%s\n",treefind->en->path);
	g_free(ff);
    	return FALSE;
    } 
    g_free(ff);
	TRACE("returning FALSE\n");

    return FALSE;
}

static void change_to_treeview(int tree_id){
    GtkTreePath *ipath=NULL;
    GtkTreeRowReference **ref;
    if (tree_id==0) {
		on_unselect_activate((GtkMenuItem *)tree_details->treestuff[1].treeview,NULL);
	ref=&Rref;
    }
    else {
		on_unselect_activate((GtkMenuItem *)tree_details->treestuff[0].treeview,NULL);
	ref=&Lref;
    }
    if (*ref && gtk_tree_row_reference_valid(*ref)) {
	ipath=gtk_tree_row_reference_get_path(*ref);	
    } else {
    if (*ref) gtk_tree_row_reference_free(*ref);
	ipath=gtk_tree_path_new_first();
	*ref=gtk_tree_row_reference_new(tree_details->treestuff[tree_id].treemodel, ipath);
    }
    gtk_widget_grab_focus((GtkWidget *) tree_details->treestuff[tree_id].treeview);
    gtk_tree_view_set_cursor (tree_details->treestuff[tree_id].treeview,ipath,NULL,FALSE);
    gtk_tree_selection_select_path(tree_details->treestuff[tree_id].selection,ipath);
    if(ipath) gtk_tree_path_free(ipath);
}

G_MODULE_EXPORT
void
on_pane1_clicked                       (GtkButton       *button,
                                        gpointer         user_data){
    GtkWidget *hpaned=WIDGET("hpaned1");
    tree_details->hpane=hpaned->allocation.width;
    change_to_treeview(1);
    gtk_paned_set_position(GTK_PANED(hpaned), tree_details->hpane);
    tree_details->hpane_ratio=1.0;
}

G_MODULE_EXPORT
void
on_pane0_clicked                       (GtkButton       *button,
                                        gpointer         user_data){
    GtkWidget *hpaned=WIDGET("hpaned1");
    tree_details->hpane=0;
    change_to_treeview(0);
    gtk_paned_set_position(GTK_PANED(hpaned), tree_details->hpane);
    tree_details->hpane_ratio=0.0;
}
G_MODULE_EXPORT
void
on_pane10_clicked                       (GtkButton       *button,
                                        gpointer         user_data){
    GtkWidget *hpaned=WIDGET("hpaned1");
    tree_details->hpane=hpaned->allocation.width/2;
    gtk_paned_set_position(GTK_PANED(hpaned), tree_details->hpane);
    tree_details->hpane_ratio=0.50;
}


/* additional key bindings for the tree */
G_MODULE_EXPORT
gboolean treeview_key(GtkWidget *w,
		GdkEventKey *event,gpointer data){
	GtkTreeView *treeview=(GtkTreeView *)w;
    	GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    	GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
	GtkTreePath *ipath=NULL;
	GtkTreeIter iter;
	static gboolean lock=FALSE;
        tree_entry_t *en=NULL;
	/*treestuff_t *treestuff=get_treestuff(treeview);*/

    if (event->state&(GDK_CONTROL_MASK)){
	/* inactive menu item accels should be caught here 
	 * this is a workaround for gtk accelerators to hidden
	 * menu element not working (they used to, but not any
	 * more)*/
	
	switch (toupper(event->keyval)){
	    case GDK_I:
		on_properties_activate((GtkMenuItem *)w,NULL);
		break;
	    case GDK_C:
		on_copy_activate((GtkMenuItem *)w,NULL);
		break;
	    case GDK_V:
		on_paste_activate((GtkMenuItem *)w,NULL);
		break;
	    case GDK_X:
		on_cut_activate((GtkMenuItem *)w,NULL);
		break;
	    case GDK_Q:
		on_close_activate((GtkMenuItem *)w,NULL);
		break;
	    case GDK_Y:
		on_countfiles_activate((GtkMenuItem *)w,NULL);
		break;
	    case GDK_Z:
		on_refresh_activate((GtkMenuItem *)w,NULL);
		break;
	    case GDK_B:
		on_open_book_activate((GtkMenuItem *)w,NULL);
		break;
	    case GDK_A:
		on_select_all_activate((GtkMenuItem *)w,NULL);
		break;
	    case GDK_P:
		on_print_activate((GtkMenuItem *)w,NULL);
		break;
	    case GDK_D:
		on_duplicate_activate((GtkMenuItem *)w,NULL);
		break;
	    case GDK_S:
		on_symlink_activate((GtkMenuItem *)w,NULL);
		break;
	    case GDK_R:
		on_rename_activate((GtkMenuItem *)w,NULL);
		break;
	    case GDK_M:
		on_touch_activate((GtkMenuItem *)w,NULL);
		break;
	    default:
		break;
	}
	return FALSE;
    }
   /* asian input methods */
    if (event->keyval == GDK_space &&(event->state&(GDK_MOD1_MASK|GDK_SHIFT_MASK))){
	return FALSE;
    }
	easy_mode = FALSE; /*may be better down below */
	if (tree_details->loading){
			TRACE("ignoring key...\n");
		return TRUE;
	}
	if (lock) {
		TRACE("keys locked!\n");
		return TRUE;
	}
	{ 
	    int i;
	    for (i=0;i<TREECOUNT;i++) {
		gtk_tree_view_set_drag_dest_row (tree_details->treestuff[i].treeview,NULL,GTK_TREE_VIEW_DROP_INTO_OR_BEFORE);
	    }
	}

	hide_text(w);
	TRACE("keyval=0x%x state=0x%x, mods= 0x%x 0x%x 0x%x 0x%x 0x%x \n",
			event->keyval,event->state,GDK_MOD1_MASK,GDK_MOD2_MASK,GDK_MOD3_MASK,GDK_MOD4_MASK,GDK_MOD5_MASK);
	switch (event->keyval){
		case GDK_Control_L:
		case GDK_Control_R:
		case GDK_Shift_L:
		case GDK_Shift_R:
		case GDK_Caps_Lock:
		case GDK_Shift_Lock:
		case GDK_Meta_L:
		case GDK_Meta_R:
		case GDK_Alt_L:
		case GDK_Alt_R:
			return TRUE;
		/*case GDK_MOD3_MASK | GDK_minus :*/
		case GDK_minus :
		case GDK_KP_Subtract :
			return FALSE;
		case GDK_plus:
		case GDK_KP_Add:
			return FALSE;
		default: break;
			
	}
	
	
	switch (event->keyval){
		case GDK_Print:
			tb_print(w);
			return TRUE;
		case GDK_Execute:
			on_run_activate((GtkMenuItem *)w, NULL);
			return TRUE;
		case GDK_Delete:
			on_remove_activate((GtkMenuItem *)w, NULL);
			return TRUE;

		case GDK_Tab:
		{
			
			if (get_only_visible_treestuff()) return TRUE;
			    
			lock=TRUE;
			if (get_tree_id (treeview) == 0){
			    change_to_treeview(1);	
			} else {
			    change_to_treeview(0);	
			}
			    
			
		        lock=FALSE;
			turn_on();
 
			return TRUE;
		}
		case GDK_F10:
		{	 
			do_main_popup("main_menu2_menu",0);
			return TRUE;
		}
		case GDK_F1:
		{	 
		    static GtkWidget *help_menu = NULL;
		    if (!help_menu) {
			GtkWidget *menuitem;
			gchar *g,**p,*t[]={"F1","Help",
				    "F2","Sort",
				    "F3","Tools",
				    "F4","New window",
				    "F5","Go",
				    "F6","Options",
				    "F7","Preferences",
				    "F8","File",
				    "F9","Actions",/*popup*/
				    "F10","Main menu",
				    "F11","Show left pane",
				    "F12","Show right pane",
				    NULL,NULL
			};
			help_menu = gtk_menu_new ();
			for (p=t; *p; p+=2){
			    g=g_strdup_printf("%s -- %s",*p,_(*(p+1)));
			    menuitem = gtk_menu_item_new_with_mnemonic (g);
			    g_free(g);
			    gtk_widget_show (menuitem);
			   /* gtk_widget_set_sensitive(menuitem, FALSE);*/
			    gtk_container_add (GTK_CONTAINER (help_menu), menuitem);
			}
			GLADE_HOOKUP_OBJECT (tree_details->window, help_menu,"help_menu");
		    }
		    do_main_popup("help_menu",0);
		    return TRUE;
		}
		case GDK_F3:
		{	 
			do_main_popup("tools1_menu",0);
			return TRUE;
		}
		case GDK_F4:
		{	 
			do_main_popup("open1_menu",0);
			return TRUE;
		}
		case GDK_F5:
		{	 
			do_main_popup("go1_menu",0);
			return TRUE;
		}
		case GDK_F6:
		{	 
			do_main_popup("options1_menu",0);
			return TRUE;
		}
		case GDK_F7:
		{	 
			do_main_popup("preferences3_menu",0);
			return TRUE;
		}
		case GDK_F11 : /* hide show treeview 1 */
		{	 
			lock=TRUE;
		   if (get_only_visible_treestuff()) on_pane10_clicked (NULL,NULL);
		   else {
		       on_pane1_clicked (NULL,NULL);
		   }
			lock=FALSE;
			return TRUE;
		}
		case GDK_F12 : /* hide show treeview 1 */
		{
			lock=TRUE;
		   if (get_only_visible_treestuff()) on_pane10_clicked (NULL,NULL);
		   else {
			on_pane0_clicked (NULL,NULL);
		   }
			lock=FALSE;
			return TRUE;
		}
		case GDK_Menu:
		case GDK_F8:
		case GDK_F2:
		case GDK_F9:
		{	 
			GtkTreePath *selectpath=NULL;
			tree_details->selectionOK=0;
    			gtk_tree_selection_selected_foreach(selection, 
		    		count_selection, (gpointer) treeview);
			if (tree_details->selectionOK==0 && event->keyval==GDK_Menu) {
			    do_main_popup("main_menu2_menu",0);
			    return TRUE;
			}
			if (tree_details->selectionOK==1){
			  gtk_tree_selection_set_mode(selection, GTK_SELECTION_BROWSE);
			  if(gtk_tree_selection_get_selected(selection, &treemodel, &iter))
  		   	  gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
			  gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
			  if (!en && event->keyval==GDK_Menu) {
			      if (event->keyval==GDK_Menu) do_main_popup("main_menu2_menu",0);
			      return TRUE;
			  }
			  if (en) selectpath=gtk_tree_model_get_path (treemodel,&iter);
			}
			switch (event->keyval){
			  case GDK_F2:
			    if (tree_details->selectionOK==1) {
				set_sense(2,TRUE);
			        if(!en || IS_BROKEN_LNK(en->type)) set_sense(2,FALSE);
			    }
			    else set_sense(2,FALSE);
			    do_main_popup("sort1_menu",0);
			    break;
			  case GDK_F8:
			    if (tree_details->selectionOK==1 && IS_PATH(en->type)) {
				set_sense(1,TRUE);
			        if(!en || IS_BROKEN_LNK(en->type)) set_sense(1,FALSE);
				/* this block is repeated in menu.c */
				if (IS_DIR(en->type)|| !IS_FILE(en->type)){
				    gtk_widget_set_sensitive(WIDGET("sb_scramble_menuitem"),FALSE);
				    gtk_widget_set_sensitive(WIDGET("sb_unscramble_menuitem"),FALSE);
				} else {
				    gchar *p=strrchr(en->path,'.');
				    if (!p || strcmp(p,".cyt")!=0) {
				      gtk_widget_set_sensitive(WIDGET("sb_scramble_menuitem"),TRUE);
				      gtk_widget_set_sensitive(WIDGET("sb_unscramble_menuitem"),FALSE);
				    }
				    else {
				      gtk_widget_set_sensitive(WIDGET("sb_unscramble_menuitem"),TRUE);
				      gtk_widget_set_sensitive(WIDGET("sb_scramble_menuitem"),FALSE);
				    }
				}
				/* end of repeated block */
			    }
			    else set_sense(1,FALSE);
			    do_main_popup("file1_menu",0);
			    break;
			  case GDK_F9:
			  case GDK_Menu:
			    do_select_popup(treeview, selectpath,0);
			    break;
			}
			
			if (selectpath) gtk_tree_path_free(selectpath);
			return TRUE;
		}
	case GDK_Escape:
			on_unselect_activate((GtkMenuItem *)w,NULL);
			return TRUE;
		default: break;
	}

	/* this will leave only one selected */
	
	gtk_tree_selection_set_mode(selection, GTK_SELECTION_BROWSE);
	if(gtk_tree_selection_get_selected(selection, &treemodel, &iter))
  		   gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
	gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);

	if ((event->keyval >= GDK_space && event->keyval <= GDK_asciitilde) || 
	    (event->keyval >= GDK_KP_Multiply && event->keyval <= GDK_KP_9)  
	    )
	{
	    gboolean backwards=FALSE;
	    treefind_t treefind;
	    treefind.second_letter_match=FALSE;
	    if (event->keyval >= GDK_space && event->keyval <= GDK_asciitilde)
		treefind.c=event->keyval;
	    else switch (event->keyval){
		case GDK_KP_0: treefind.c=GDK_0; break;
		case GDK_KP_1: treefind.c=GDK_1; break;
		case GDK_KP_2: treefind.c=GDK_2; break;
		case GDK_KP_3: treefind.c=GDK_3; break;
		case GDK_KP_4: treefind.c=GDK_4; break;
		case GDK_KP_5: treefind.c=GDK_5; break;
		case GDK_KP_6: treefind.c=GDK_6; break;
		case GDK_KP_7: treefind.c=GDK_7; break;
		case GDK_KP_8: treefind.c=GDK_8; break;
		case GDK_KP_9: treefind.c=GDK_9; break;
		case GDK_KP_Multiply: treefind.c=GDK_asterisk; break;
		case GDK_KP_Add: treefind.c=GDK_plus; break;
		case GDK_KP_Separator: treefind.c=GDK_space; break;
		case GDK_KP_Subtract: treefind.c=GDK_minus; break;
		case GDK_KP_Decimal: treefind.c=GDK_period; break;
		case GDK_KP_Divide: treefind.c=GDK_slash; break;
		default : treefind.c=0x7f; break;
	    }
	    if (treefind.c >= GDK_A && treefind.c <= GDK_Z) treefind.C = treefind.c + (GDK_a - GDK_A);
	    else if (treefind.c >= GDK_a && treefind.c <= GDK_z) treefind.C = treefind.c - (GDK_a - GDK_A);
	    else treefind.C = treefind.c;
	    /*printf ("state=0x%x\n",event->state);*/
	    /* Use windows key modifier to do second letter match */
	    /* let's keep the window modifyer for xbindkey: much more useful */
	    /*if (event->state & GDK_MOD4_MASK) treefind.second_letter_match=TRUE;*/
	    if (event->state & (GDK_MOD3_MASK)) {
		    treefind.second_letter_match=TRUE;
	    }
	    if (event->state & GDK_SHIFT_MASK){
		    backwards = TRUE;
		    treefind.second_letter_match=FALSE;
		    TRACE("going backwards!\n");
	    }


	    TRACE("alphabeta keyval=0x%x\n",event->keyval);
	    /*if (!en) {
		if (!gtk_tree_model_get_iter_first (treemodel,&iter))
		    return FALSE;
		if (backwards) done = TRUE;
	    } */	    
	    treefind.ipath=gtk_tree_model_get_path(treemodel, &iter);
	    
	    treefind.done=FALSE;
	    treefind.treeview=treeview;
	    treefind.prev_path=NULL;
	    treefind.selection=selection;
	    if (!backwards) {
		    gtk_tree_model_foreach(treemodel, find_next_row, &treefind);
		    if (!treefind.done) print_diagnostics("xfce/info",
							_("Search hit BOTTOM (use SHIFT to search toward TOP)"),
							"\n",NULL);
	    }
	    else {
		    gtk_tree_model_foreach(treemodel, find_prev_row, &treefind);
		    if (!treefind.done) print_diagnostics("xfce/info",
							_("Search hit TOP"),
							"\n",NULL);
	    }

    	    if (treefind.ipath) {
		gtk_tree_path_free(treefind.ipath);
		treefind.ipath=NULL;
	    }
	    return TRUE;
	}
	
	if (!en) return TRUE;
        if(tree_details->input)	cancel_input(NULL,NULL);
	
	switch (event->keyval){
		default: break;
	        case GDK_Find:
			 sb_find(w);
			 return TRUE;
		case GDK_Down:
		     TRACE("gdk down...state=0x%x, mod3 is 0x%x\n", event->state,GDK_MOD3_MASK);
	        case GDK_Up:
			if (event->state&GDK_SHIFT_MASK) return FALSE;
		         lock=TRUE;
		         TRACE("lock #1!\n");
	    		if (!en) {
			  if (!gtk_tree_model_get_iter_first (treemodel,&iter))
		          lock=FALSE;
		    	  return TRUE;
	    		} 
			if (ipath) gtk_tree_path_free(ipath);
	    		ipath=gtk_tree_model_get_path(treemodel, &iter);
			if (event->keyval==GDK_Down) {
				GtkTreeIter iter2;
				if (gtk_tree_view_row_expanded (treeview,ipath)){
					gtk_tree_path_down (ipath);
				} else {
					gtk_tree_path_next (ipath);
				}
				if (!gtk_tree_model_get_iter (treemodel,&iter2,ipath)){
					if (!gtk_tree_model_iter_next(treemodel,&iter)){
				  	   gtk_tree_path_free(ipath);
					   ipath=NULL;
				  	   lock=FALSE;
		    	  	  	   return TRUE;
					}
	    				ipath=gtk_tree_model_get_path(treemodel, &iter);
				}
			}
			if (event->keyval==GDK_Up) {
				GtkTreePath *rpath=gtk_tree_path_new_first();
				if (!rpath || !ipath || gtk_tree_path_compare (rpath,ipath)==0){
				  if (ipath) gtk_tree_path_free(ipath);
				  ipath=NULL;
				  if (rpath) gtk_tree_path_free(rpath);
				  lock=FALSE;
		    	  	  return TRUE;
				}
				gtk_tree_path_free(rpath);
				if (ipath && !gtk_tree_path_prev (ipath)) gtk_tree_path_up(ipath);
			}
			
			set_path_reference(treeview,ipath);
		    	gtk_widget_grab_focus((GtkWidget *) treeview);
			if (ipath){
			    gtk_tree_view_set_cursor (treeview,ipath,NULL,FALSE);
			    gtk_tree_selection_select_path(selection,ipath);
			    gtk_tree_model_get_iter(treemodel, &iter, ipath);
			    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);

			    if (en) status_the_path(treeview,ipath,en);
			    /* scrolling with alt key */	
			    if (event->state&GDK_MOD1_MASK){
				/*get selected path ++*/
			     gdk_flush();
			     gtk_tree_view_scroll_to_cell(treeview, ipath, NULL, TRUE, 0.0, 0.0);
			     clear_dnd_selection_list();
			     get_dnd_selection(treemodel, ipath, &iter, (gpointer) treeview);
			    }
			
			    gtk_tree_path_free(ipath);
			}
		        lock=FALSE;
			TRACE("unlock #1!\n");
		    	return TRUE;
		case GDK_Right:
		{
			lock=TRUE;
			TRACE("lock #2...\n");
			if (ipath) gtk_tree_path_free(ipath);
			ipath = gtk_tree_model_get_path(treemodel, &iter);
			if (gtk_tree_model_iter_has_child(treemodel,&iter))
			{
			     TRACE("lock #2a...path=%s\n",(en->path)?en->path:"null");
			     gtk_tree_view_expand_row(treeview, ipath, FALSE);
			     gtk_tree_selection_select_path (selection,ipath);
			     gtk_tree_view_set_cursor (treeview,ipath,NULL,FALSE);
		             get_dnd_selection(treemodel, ipath, &iter, (gpointer) treeview);			
			     set_path_reference(treeview,ipath);
			     turn_on();
			     lock=FALSE;
			     TRACE("unlock #2a!\n");
			      if (ipath) gtk_tree_path_free(ipath);
			      ipath=NULL;
			      return TRUE;
			}
			/* otherwise, -> is a return: */
		}
		case GDK_Return:
			 lock=TRUE;
			 TRACE("lock #2b!\n");
			 on_double_click_activate((GtkMenuItem *)w,
					(gpointer) treeview);
			 lock=FALSE;
			 TRACE("unlock #2b!\n");
			 return TRUE;
			 break;
		case GDK_Left:
			lock=TRUE;
			TRACE("lock #3!\n");
			
			{	
			  GtkTreeIter parent;
			  /*if (ipath) gtk_tree_path_free(ipath);*/
			  ipath = gtk_tree_model_get_path(treemodel, &iter);
			  
			  if (gtk_tree_view_row_expanded (treeview,ipath)){
			     gtk_tree_view_collapse_row(treeview, ipath);
			     turn_on();
			     gtk_tree_selection_select_path (selection,ipath);
			     gtk_tree_view_set_cursor (treeview,ipath,NULL,FALSE);
		             get_dnd_selection(treemodel, ipath, &iter, (gpointer) treeview);
			     set_path_reference(treeview,ipath);
		    	     gtk_tree_path_free(ipath);
			     ipath=NULL;
			     lock=FALSE;
			     return TRUE;
			  } 
			  if (gtk_tree_model_iter_parent (treemodel,&parent,&iter)){
			     if (ipath) gtk_tree_path_free(ipath);
			     ipath=gtk_tree_model_get_path(treemodel, &parent);
			     gtk_tree_view_collapse_row(treeview, ipath);
				     
    			     gtk_tree_view_scroll_to_cell(treeview, ipath, NULL, TRUE, 0.0, 0.0);

			     clear_dnd_selection_list();

			     gtk_tree_selection_select_path (selection,ipath);
			     gtk_tree_view_set_cursor (treeview,ipath,NULL,FALSE);
		             get_dnd_selection(treemodel, ipath, &parent, (gpointer) treeview);
			     set_path_reference(treeview,ipath);

		    	     gtk_tree_path_free(ipath);
			     ipath=NULL;
			     turn_on();
			     lock=FALSE;
			     return TRUE;
			  }  
			}
			
			
			lock=FALSE;
			TRACE("unlock #3!\n");
			return TRUE;
			
			break;
	}
		
	return FALSE;
}


