#ifndef __ERRORS_H__
#define __ERRORS_H__

#include <errno.h>

#ifdef	ENOMSG		
# define EFALLBACK ENOMSG
#else
#warning "ENOMSG not available for fallback message!"
# ifdef EIO
# define EFALLBACK EIO
# else
# error "No fallback message set. Please edit libs/errors.h for your choice"
# endif
#endif


#ifndef EPERM
#warning 		"EPERM"
#define EPERM		EFALLBACK
#endif

#ifndef ENOENT
#warning 		"ENOENT"
#define ENOENT		EFALLBACK
#endif

#ifndef ESRCH
#warning 		"ESRCH"
#define ESRCH		EFALLBACK
#endif

#ifndef EINTR
#warning 		"EINTR"
#define EINTR		EFALLBACK
#endif

#ifndef EIO
#warning 		"EIO"
#define EIO		EFALLBACK
#endif

#ifndef ENXIO
#warning 		"ENXIO"
#define ENXIO		EFALLBACK
#endif

#ifndef E2BIG
#warning 		"E2BIG"
#define E2BIG		EFALLBACK
#endif

#ifndef ENOEXEC
#warning 		"ENOEXEC"
#define ENOEXEC		EFALLBACK
#endif

#ifndef EBADF
#warning 		"EBADF"
#define EBADF		EFALLBACK
#endif

#ifndef ECHILD
#warning 		"ECHILD"
#define ECHILD		EFALLBACK
#endif

#ifndef EDEADLK
#warning 		"EDEADLK"
#define EDEADLK		EFALLBACK
#endif

#ifndef ENOMEM
#warning 		"ENOMEM"
#define ENOMEM		EFALLBACK
#endif

#ifndef EACCES
#warning 		"EACCES"
#define EACCES		EFALLBACK
#endif

#ifndef EFAULT
#warning 		"EFAULT"
#define EFAULT		EFALLBACK
#endif

#ifndef EBUSY
#warning 		"EBUSY"
#define EBUSY		EFALLBACK
#endif

#ifndef EEXIST
#warning 		"EEXIST"
#define EEXIST		EFALLBACK
#endif

#ifndef EXDEV
#warning 		"EXDEV"
#define EXDEV		EFALLBACK
#endif

#ifndef 		ENODEV
#warning 		"EFALLBACK"
#define 		ENODEV		EFALLBACK
#endif

#ifndef	ENOTDIR		
#warning 		"ENOTDIR"
#define ENOTDIR		EFALLBACK
#endif

#ifndef	EISDIR		
#warning 		"EISDIR"
#define EISDIR		EFALLBACK
#endif

#ifndef	EINVAL		
#warning 		"EINVAL"
#define EINVAL		EFALLBACK
#endif

#ifndef	ENFILE		
#warning 		"ENFILE"
#define ENFILE		EFALLBACK
#endif

#ifndef	EMFILE		
#warning 		"EMFILE"
#define EMFILE		EFALLBACK
#endif

#ifndef	ENOTTY		
#warning 		"ENOTTY"
#define ENOTTY		EFALLBACK
#endif

#ifndef	ETXTBSY		
#warning 		"ETXTBSY"
#define ETXTBSY		EFALLBACK
#endif

#ifndef	EFBIG		
#warning 		"EFBIG"
#define EFBIG		EFALLBACK
#endif

#ifndef	ENOSPC		
#warning 		"ENOSPC"
#define ENOSPC		EFALLBACK
#endif

#ifndef	ESPIPE		
#warning 		"ESPIPE"
#define ESPIPE		EFALLBACK
#endif

#ifndef	EROFS		
#warning 		"EROFS"
#define EROFS		EFALLBACK
#endif

#ifndef	EMLINK		
#warning 		"EMLINK"
#define EMLINK		EFALLBACK
#endif

#ifndef	EPIPE		
#warning 		"EPIPE"
#define EPIPE		EFALLBACK
#endif

#ifndef	EDOM		
#warning 		"EDOM"
#define 		EFALLBACK
#endif

#ifndef	ERANGE		
#warning 		"ERANGE"
#define ERANGE		EFALLBACK
#endif

#ifndef	EAGAIN		
#warning 		"EAGAIN"
#define EAGAIN		EFALLBACK
#endif

#ifndef	EINPROGRESS		
#warning 		"EINPROGRESS"
#define EINPROGRESS	EFALLBACK
#endif

#ifndef	EALREADY	
#warning 		"EALREADY"
#define 		EFALLBACK
#endif

#ifndef	ENOTSOCK	
#warning 		"ENOTSOCK"
#define ENOTSOCK	EFALLBACK
#endif

#ifndef	EDESTADDRREQ	
#warning 		"EDESTADDRREQ"
#define EDESTADDRREQ	EFALLBACK
#endif

#ifndef	EMSGSIZE	
#warning 		"EMSGSIZE"
#define EMSGSIZE	EFALLBACK
#endif

#ifndef	EPROTOTYPE		
#warning 		"EPROTOTYPE"
#define EPROTOTYPE	EFALLBACK
#endif

#ifndef	ENOPROTOOPT	
#warning 		"ENOPROTOOPT"
#define ENOPROTOOPT	EFALLBACK
#endif

#ifndef	EPROTONOSUPPORT	
#warning 		"EPROTONOSUPPORT"
#define EPROTONOSUPPORT	EFALLBACK
#endif

#ifndef	EOPNOTSUPP	
#warning 		"EOPNOTSUPP"
#define EOPNOTSUPP	EFALLBACK
#endif

#ifndef	EAFNOSUPPORT	
#warning 		"EAFNOSUPPORT"
#define EAFNOSUPPORT	EFALLBACK
#endif

#ifndef	EADDRINUSE	
#warning 		"EADDRINUSE"
#define EADDRINUSE	EFALLBACK
#endif

#ifndef	EADDRNOTAVAIL	
#warning 		"EADDRNOTAVAIL"
#define EADDRNOTAVAIL	EFALLBACK
#endif

#ifndef	ENETDOWN	
#warning 		"ENETDOWN"
#define ENETDOWN	EFALLBACK
#endif

#ifndef	ENETUNREACH	
#warning 		"ENETUNREACH"
#define ENETUNREACH	EFALLBACK
#endif

#ifndef	ENETRESET	
#warning 		"ENETRESET"
#define ENETRESET	EFALLBACK
#endif

#ifndef	ECONNABORTED	
#warning 		"ECONNABORTED"
#define ECONNABORTED	EFALLBACK
#endif

#ifndef	ECONNRESET	
#warning 		"ECONNRESET"
#define ECONNRESET	EFALLBACK
#endif

#ifndef	ENOBUFS	
#warning 		"ENOBUFS"
#define ENOBUFS		EFALLBACK
#endif

#ifndef	EISCONN		
#warning 		"EISCONN"
#define EISCONN		EFALLBACK
#endif

#ifndef	ENOTCONN		
#warning 		"ENOTCONN"
#define ENOTCONN	EFALLBACK
#endif

#ifndef	ETIMEDOUT	
#warning 		"ETIMEDOUT"
#define ETIMEDOUT	EFALLBACK
#endif

#ifndef	ECONNREFUSED		
#warning 		"ECONNREFUSED"
#define ECONNREFUSED	EFALLBACK
#endif

#ifndef	ELOOP	
#warning 		"ELOOP"
#define ELOOP		EFALLBACK
#endif

#ifndef	ENAMETOOLONG		
#warning 		"ENAMETOOLONG"
#define ENAMETOOLONG	EFALLBACK
#endif

#ifndef	EHOSTUNREACH	
#warning 		"EHOSTUNREACH"
#define EHOSTUNREACH	EFALLBACK
#endif

#ifndef	ENOTEMPTY	
#warning 		"ENOTEMPTY"
#define ENOTEMPTY	EFALLBACK
#endif

#ifndef	ENOLCK	
#warning 		"ENOLCK"
#define ENOLCK		EFALLBACK
#endif

#ifndef	ENOSYS		
#warning 		"ENOSYS"
#define ENOSYS		EFALLBACK
#endif

#ifndef	EIDRM		
#warning 		"EIDRM"
#define EIDRM		EFALLBACK
#endif

#ifndef	EOVERFLOW		
#warning 		"EOVERFLOW"
#define EOVERFLOW	EFALLBACK
#endif

#ifndef	ENOTSUP		
#define ENOTSUP		EOPNOTSUPP
#endif

#ifndef	ECANCELLED
#define ECANCELLED	EINTR
#endif


#endif
