/*
  Copyright 1999-2005 ImageMagick Studio LLC, a non-profit organization
  dedicated to making software imaging solutions freely available.
  
  You may not use this file except in compliance with the License.
  obtain a copy of the License at
  
    http://www.imagemagick.org/www/Copyright.html
  
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

  ImageMagick image composite private methods.
*/
#ifndef _MAGICK_COMPOSITE_PRIVATE_H
#define _MAGICK_COMPOSITE_PRIVATE_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/*
  ImageMagick Alpha Composite Inline Methods.
*/

static inline MagickRealType MagickAtop_(const MagickRealType p,
  const MagickRealType alpha,const MagickRealType q,const MagickRealType beta)
{
  MagickRealType
    pixel;
                                                                                
  pixel=((1-QuantumScale*alpha)*p*(1-QuantumScale*beta)+(1-QuantumScale*beta)*
    q*QuantumScale*alpha);
  return(pixel);
}
                                                                                
static inline void MagickCompositeAtop(const PixelPacket *p,
  const MagickRealType alpha,const PixelPacket *q,const MagickRealType beta,
  PixelPacket *composite)
{
  MagickRealType
    gamma;
                                                                                
  gamma=(1-QuantumScale*beta);
  composite->opacity=(Quantum) (MaxRGB*(1.0-gamma)+0.5);
  gamma=1.0/(gamma <= MagickEpsilon ? 1.0 : gamma);
  composite->red=(Quantum) (gamma*MagickAtop_((MagickRealType) p->red,alpha,
    (MagickRealType) q->red,beta)+0.5);
  composite->green=(Quantum) (gamma*MagickAtop_((MagickRealType) p->green,alpha,
    (MagickRealType) q->green,beta)+0.5);
  composite->blue=(Quantum) (gamma*MagickAtop_((MagickRealType) p->blue,alpha,
    (MagickRealType) q->blue,beta)+0.5);
}

static inline MagickRealType MagickOver_(const MagickRealType p,
  const MagickRealType alpha,const MagickRealType q,const MagickRealType beta)
{
  return((1-QuantumScale*alpha)*p+(1-QuantumScale*beta)*q*QuantumScale*alpha);
}
                                                                                
static inline void MagickCompositeOver(const PixelPacket *p,
  const MagickRealType alpha,const PixelPacket *q,const MagickRealType beta,
  PixelPacket *composite)
{
  MagickRealType
    gamma;
                                                                                
  gamma=1.0-QuantumScale*QuantumScale*alpha*beta;
  composite->opacity=(Quantum) (MaxRGB*(1.0-gamma)+0.5);
  gamma=1.0/(gamma <= MagickEpsilon ? 1.0 : gamma);
  composite->red=(Quantum) (gamma*MagickOver_((MagickRealType) p->red,alpha,
    (MagickRealType) q->red,beta)+0.5);
  composite->green=(Quantum) (gamma*MagickOver_((MagickRealType) p->green,alpha,
    (MagickRealType) q->green,beta)+0.5);
  composite->blue=(Quantum) (gamma*MagickOver_((MagickRealType) p->blue,alpha,
    (MagickRealType) q->blue,beta)+0.5);
}

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
