/* 
 * Copyright (C) 2004 the xine project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: vis.c,v 1.5 2004/12/02 02:38:32 dsalt Exp $
 *
 * Visualisation wrapper code
 */

#include "globals.h"

#include <string.h>
#include <pthread.h>

#include "engine.h"
#include "gtkvideo.h"
#include "script_engine.h"

void vis_hide (GtkVideo *this, xine_audio_port_t *audio_port)
{
  gtk_video_hide_vis (this, audio_port);
}

gboolean vis_show (GtkVideo *this, xine_audio_port_t **audio_port)
{
  if (xine_get_stream_info (stream, XINE_STREAM_INFO_HAS_VIDEO) ||
      !xine_get_stream_info (stream, XINE_STREAM_INFO_HAS_AUDIO))
    return FALSE;
  return gtk_video_show_vis (this, audio_port);
}

gboolean vis_set (GtkVideo *this, const char *id,
		  xine_audio_port_t **audio_port)
{
  return gtk_video_set_vis (this, id, audio_port);
}

static JSBool js_set_vis (JSContext *cx, JSObject *obj, uintN argc,
			     jsval *argv, jsval *rval)
{
  se_t     *se = (se_t *) JS_GetContextPrivate(cx);
  JSString *str;
  char     *id = NULL;

  se_log_fncall ("js_set_vis");

  se_argc_check (1, "set_vis");
  se_arg_is_string (0, "set_vis");

  str = JS_ValueToString (cx, argv[0]);

  id = JS_GetStringBytes (str);

  if (engine_mutex_trylock (se))
    return JS_TRUE;
  vis_set (GTK_VIDEO(gtv), id, &audio_port);
  pthread_mutex_unlock (&engine_lock);

  return JS_TRUE;
}

void vis_init (void)
{
  se_defun (gse, NULL, "set_vis", js_set_vis, 0, 0,
	    SE_GROUP_ENGINE, N_("string"), N_("visualisation name"));
}
