/*
 *	(c) Copyright 1990, Kim Fabricius Storm.  All rights reserved.
 *
 *	Global declarations and definitions.
 */

#ifndef _NN_GLOBAL_H
#define _NN_GLOBAL_H 1

/*
 *	Marks for global/external variables
 */

#define	export			/* export variable from module */
#define import	extern		/* import variable into module */

/*
 *	Various constants and types
 */

typedef int8  	attr_type;
typedef int32 	flag_type;

#ifdef I286_BUG
#	define FLAG(n)	(1L<<(n-1))
#else
#	define FLAG(n)	(((flag_type)1)<<(n-1))
#endif

typedef int32	article_number;
typedef int32	group_number;
typedef uint32	time_stamp;

typedef int	(* fct_type )();
#define CALL(fct)  (* (fct))
#define NULL_FCT  (fct_type)NULL

/* frequently used characters */

#define NUL	'\0'
#define TAB	'\t'
#define NL	'\n'
#define CR	'\r'
#define BS	'\b'
#define SP	' '

/* misc macros */

#define fl fflush(stdout)

#ifdef CONTROL_
#undef CONTROL_
#endif
#define CONTROL_(c)	(c&037)

#ifndef HAVE_STRCHR
#define	strrchr		rindex
#define strchr		index
#endif

#ifdef SIGNAL_HANDLERS_ARE_VOID
#define sig_type void
#else
#define sig_type int
#endif

/* define types of library functions */

char 	*getenv(), *ctime();
#ifndef MALLOC_FUNC_CHECK
char 	*strchr(), *strrchr();
#endif
off_t 	lseek();
long	ftell();
int	atoi();
long	atol();


/* define types of own functions */

char *mk_file_name(), *home_relative();
char *date_time(), *user_name(), *plural();
char *copy_str();

time_t	file_exist(), m_time(), cur_time();

extern FILE *open_file();
char *relative();

#define	OPEN_READ	0	/* open for reading */
#define	OPEN_UPDATE	1	/* open/create for update */
#define	OPEN_CREATE	2	/* create/truncate for write */
#define	OPEN_APPEND	3	/* open for append */
#define OPEN_CREATE_RW	4	/* create for read/write */

#define	DONT_CREATE	0x40	/* return if file does not exist */
#define	MUST_EXIST	0x80	/* fatal error if cannot open */
#define	OPEN_UNLINK	0x100	/* unlink after open (not OPEN_UPDATE) */


/*
 *	Other external definitions
 *
 *	NOTICE: the distinction between pointers and arrays is important
 *		here (they are global variables - not function arguments)
 */

extern char

    *nn_directory,
    *lib_directory,
    version_id[];

#ifdef NNTP
extern int  use_nntp;   /* 1 iff we are using nntp */
#else
#define use_nntp 0	/* for optimizers */
#endif

extern int
    s_hangup,	/* hangup signal */
    s_keyboard,	/* keyboard signal */
    s_pipe,	/* broken pipe */
    s_redraw;	/* continue signal after stop */

extern int who_am_i;

#define I_AM_MASTER	0
#define I_AM_NN		1
#define I_AM_ADMIN	2
#define I_AM_CHECK	3
#define I_AM_TIDY	4
#define I_AM_EMACS	5
#define I_AM_GOBACK	6
#define I_AM_POST	7
#define I_AM_GREP	8
#define I_AM_DAILY	9
#define I_AM_SPEW	10
#define I_AM_EXPIRE	11
#define I_AM_ACCT	12
#define I_AM_VIEW	13

extern uid_t    user_id;
extern gid_t    group_id;

extern int
    process_id;

extern int errno;

/*
 *	Storage management
 */

extern char *mem_obj(), *mem_resize(), *mem_str();

#define	newobj(type, nelt) \
    (type *)mem_obj(sizeof(type), (int32)(nelt))

#define	newstr(nelt) \
    mem_str((int32)(nelt))

#define	resizeobj(obj, type, nelt) \
    (type *)mem_resize((char *)(obj), sizeof(type), (int32)(nelt))

#define	clearobj(obj, type, nelt) \
    mem_clear((char *)(obj), sizeof(type), (int32)(nelt))

#define	freeobj(obj) mem_free((char *)(obj))

#ifdef __STDC__
#define quicksort(a,n,t,f) qsort((char *)(a), (unsigned)(n), sizeof(t), (int (*)(const void *,const void *)) f)
#else
#define quicksort(a,n,t,f) qsort((char *)(a), (unsigned)(n), sizeof(t), f)
#endif

#include "data.h"

/*
 *	db external data
 */

extern master_header master;

/* group headers */

#ifdef MALLOC_64K_LIMITATION
extern group_header **active_groups, **sorted_groups;
#else
extern group_header *active_groups, **sorted_groups;
#endif

/* current group information */

extern char 	group_path_name[];
extern char	*group_file_name;

extern group_header *current_group, *group_sequence, *rc_sequence;

extern group_header *lookup();


int l_g_index, s_g_first;

#define	Loop_Groups_Number(num) \
    for (num = 0; num < master.number_of_groups; num++)

#ifdef MALLOC_64K_LIMITATION
#define Loop_Groups_Header(gh) \
    for (l_g_index = 0; \
	 (l_g_index < master.number_of_groups) && \
	 (gh = active_groups[l_g_index]) ;\
	 l_g_index++)
#else
#define Loop_Groups_Header(gh) \
    for (l_g_index = 0, gh=active_groups; \
	 l_g_index < master.number_of_groups; \
	 l_g_index++, gh++)
#endif

#define Loop_Groups_Sorted(gh) \
    for (l_g_index = s_g_first; \
	 (l_g_index < master.number_of_groups) && \
	 (gh = sorted_groups[l_g_index]) ;\
	 l_g_index++)

#define	Loop_Groups_Sequence(gh) \
    for (gh = group_sequence; gh; gh = gh->next_group)

#define	Loop_Groups_Newsrc(gh) \
    for (gh = rc_sequence; gh; gh = gh->newsrc_seq)

#ifdef MALLOC_64K_LIMITATION
#define ACTIVE_GROUP(n)	active_groups[n]
#else
#define ACTIVE_GROUP(n)	&active_groups[n]
#endif

/* 8 bit support (ISO 8859/...) */

#ifdef HAVE_8BIT_CTYPE
#ifdef isascii
#undef isascii
#endif
#define isascii(c)	1

#define iso8859(c)	(isprint(c))
#else
#define iso8859(c)	((c) & 0x60)
#endif

#include <sys/types.h>
#include <errno.h>
#include <stdio.h>

#ifdef HAVE_STRING_H
#include <string.h>
#else
# ifdef HAVE_STRINGS_H
# include <strings.h>
# endif
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif


/* Global Functions... */

#if defined(__STDC__) || defined(__cplusplus)
#define __APROTO(s) s
#else
#define __APROTO(s) ()
#endif

#include "articles.h"
#include "keymap.h"
#include "news.h"
#include "regexp.h"
#include "options.h"

/*
 *	Some systems don't define these in <sys/stat.h>
 */

#ifndef S_IFMT
#define	S_IFMT	0170000			/* type of file */
#define S_IFDIR	0040000			/* directory */
#define S_IFREG	0100000			/* regular */
#endif

#ifndef O_RDONLY
#define	O_RDONLY	0
#define	O_WRONLY	1
#define	O_RDWR		2
#endif

/* account.c */

int	main		__APROTO((int argc, char *argv[]));
void	nn_exit		__APROTO((int n));
int	suspend_nn	__APROTO((void));

/* active.c */

void	read_active_file __APROTO((FILE *act, FILE *copy));

/* admin.c */

void	admin_mode	__APROTO((char *input_string));

/* answer.c */

FILE *	open_purpose_file  __APROTO((void));
int	display_group_list __APROTO((int get_regexp));
int	answer		__APROTO((article_header *ah, int command, int incl));
int	cancel		__APROTO((article_header *ah));
void	do_nnpost	__APROTO((int argc, char *argv[]));
int	post_menu	__APROTO((void));
void	init_answer	__APROTO((void));

/* articles.c */

article_header *alloc_art __APROTO((void));
char *	alloc_str	__APROTO((int len));
void	free_memory	__APROTO((void));
void	mark_str	__APROTO((string_marker *str_marker));
void	release_str	__APROTO((string_marker *str_marker));
void	mark_memory	__APROTO((memory_marker *mem_marker));
void	release_memory	__APROTO((memory_marker *mem_marker));
void	merge_memory	__APROTO((void));
void	add_article	__APROTO((article_header *art));
int	access_group	__APROTO((group_header *gh,
				  article_number first_article,
				  article_number last_article,
				  flag_type flags, char *mask));

/* collect.c */

int	do_collect	__APROTO((void));

/* db.c */

int	init_group	__APROTO((group_header *gh));
int	open_groups	__APROTO((int mode));
void	close_groups	__APROTO((void));
void	db_append_group	__APROTO((group_header *gh));
void	db_rewrite_groups __APROTO((int save_groups, group_header *group_list));
int	db_parse_group	__APROTO((group_header *gh, int trust_master));
void	open_master	__APROTO((int mode));
void	db_expand_master __APROTO((void));
void	close_master	__APROTO((void));
int	update_group	__APROTO((group_header *gh));
void	sort_groups	__APROTO((void));
group_header *lookup_no_alias __APROTO((char *name));
group_header *lookup	__APROTO((char *name));
int	art_collected	__APROTO((group_header *gh, article_number art_num));
char *	db_data_path	__APROTO((char *namebuf, group_header *gh, int d_or_x));
FILE *	open_data_file	__APROTO((group_header *gh, int d_or_x, int mode));
void	db_read_master	__APROTO((void));
void	db_write_master	__APROTO((void));
#ifdef NOV
void	db_read_group	__APROTO((group_header *gh, article_number low, article_number high));
#else
void	db_read_group	__APROTO((group_header *gh));
#endif
void	db_write_group	__APROTO((group_header *gh));
off_t	db_read_art	__APROTO((FILE *f));
int	db_write_art	__APROTO((FILE *f));
off_t	get_index_offset __APROTO((group_header *gh, article_number art_num));
off_t	get_data_offset	 __APROTO((group_header *gh, article_number art_num));
int	db_read_offset	__APROTO((FILE *f, off_t *offset));
int	db_write_offset	__APROTO((FILE *f, off_t *offset));

/* decode.c */

void	uud_start	__APROTO((char *dir));
void	uud_end		__APROTO((void));
int	uudecode	__APROTO((article_header *ah, FILE *in));

/* digest.c */

void	init_digest_parsing	__APROTO((void));
int	is_digest		__APROTO((char *subject));
int	get_folder_type		__APROTO((FILE *f));
int	get_digest_article	__APROTO((FILE *f, news_header_buffer hdrbuf));
int	skip_digest_body	__APROTO((FILE *f));
int	parse_digest_header	__APROTO((FILE *f, int all, news_header_buffer hdrbuf));

/* dir.c */

int	list_directory		__APROTO((char *dir, char *prefix));
int	next_directory		__APROTO((char *buffer, int add_slash));
int	compl_help_directory	__APROTO((void));
void	close_directory		__APROTO((void));

/* execute.c */

void	init_execute	__APROTO((void));
int	execute		__APROTO((char *path, char **args, int toggle_visual));
int	shell_escape	__APROTO((void));
int	run_shell	__APROTO((char *command, int clear, int init_sh));
int	suspend_nn	__APROTO((void));

/* expire.c */

int	do_expire	__APROTO((void));

/* folder.c */

int	expand_file_name __APROTO((char *dest, char *src, int expand_mode));
int	file_completion	 __APROTO((char *path, int index));
void	fcancel		 __APROTO((article_header *ah));
int	folder_menu	 __APROTO((char *path, int mode));
void	rewrite_folder	 __APROTO((void));

/* fullname.c */

char *full_name		__APROTO((void));

/* global.c */

sig_type catch_hangup	__APROTO((int n));
int	init_global	__APROTO((void));
void	new_temp_file	__APROTO((void));
FILE *	open_file	__APROTO((char *name, int mode));
FILE *	open_file_search_path	__APROTO((char *name, int mode));
int	fgets_multi	__APROTO((char *buf, int size, FILE *f));
char *	relative	__APROTO((char *dir, char *name));
char *	mk_file_name	__APROTO((char *dir, char *name));
char *	home_relative	__APROTO((char *dir));
char *	substchr	__APROTO((char *str, int c1, int c2));
char *	copy_str	__APROTO((char *str));
time_t	m_time		__APROTO((FILE *f));
time_t	file_exist	__APROTO((char *name, char *mode));
int	cmp_file(char *, char *);
int32	copy_file	__APROTO((char *src, char *dest, int append));
int	move_file	__APROTO((char *old, char *new, int may_keep_old));
int	save_old_file	__APROTO((char *name, char *suffix));
void	sys_error(char *,...);
int	sys_warning(char *,...);
int	log_entry(int, char *,...);
char *	user_name	__APROTO((void));
time_t	cur_time	__APROTO((void));
char *	date_time	__APROTO((time_t t));
char *	plural		__APROTO((long n));
char *	mem_obj		__APROTO((unsigned size, int32 nelt));
char *	mem_str		__APROTO((int32 nelt));
char *	mem_resize	__APROTO((char *obj, unsigned size, int32 nelt));
void	mem_clear	__APROTO((char *obj, unsigned size, int32 nelt));
void	mem_free	__APROTO((char *obj));
int	nn_truncate	__APROTO((char *path, off_t len));
char *	strsave		__APROTO((char *s));
char *	str3save	__APROTO((char *s1, char *s2, char *s3));
char *	fgetstr		__APROTO((FILE *f));
int	getline(char *, int);
extern char	*tmp_directory;
extern char	*nntp_cache_dir;

/* group.c */

int	group_completion	__APROTO((char *hbuf, int ix));
int	group_menu		__APROTO((group_header *gh,
					  article_number first_art,
					  flag_type access_mode,
					  char *mask, fct_type menu));
group_header *lookup_regexp	__APROTO((char *name, char *pr, int flag));
int	goto_group		__APROTO((int command, article_header *ah,
					  flag_type access_mode));
void	merge_and_read		__APROTO((flag_type access_mode, char *mask));
int	unsubscribe		__APROTO((group_header *gh));
void	group_overview		__APROTO((int amount));

/* hostname.c */

void	nn_gethostname	__APROTO((char *name, int length));

/* init.c */

void	init_message(char *,...);
void	visit_init_file	__APROTO((int only_seq, char *first_arg));
int	alt_completion	__APROTO((char *buf, int index));
int	parse_command	__APROTO((char *cmd, int ok_val, FILE *initf));
void	display_help	__APROTO((char *subject));

/* keymap.c */

void	init_key_map	__APROTO((void));
int	lookup_command	__APROTO((char *command, int restriction));
int	cmd_completion	__APROTO((char *path, int index));
char *	command_name	__APROTO((int cmd));
key_type parse_key	__APROTO((char *str));
char *	key_name	__APROTO((int c));
void	dump_global_map	__APROTO((void));
int	dump_key_map	__APROTO((char *where));
int	lookup_keymap	__APROTO((char *name));
int	make_keymap	__APROTO((char *name));
int	keymap_completion __APROTO((char *buf, int ix));

/* kill.c */

int	kill_article		__APROTO((article_header *ah));
int	auto_select_article	__APROTO((article_header *ah, int do_select));
void	enter_kill_file		__APROTO((group_header *gh, char *pattern,
					  flag_type flag, int days));
int	kill_menu		__APROTO((article_header *ah));
int	init_kill		__APROTO((void));
void	rm_kill_file		__APROTO((void));
void	free_kill_entries	__APROTO((void));
void	dump_kill_list		__APROTO((void));

/* macro.c */

void	init_macro	__APROTO((void));
char *	m_define	__APROTO((char *id, FILE *f));
char *	m_get_macro	__APROTO((char *id));
char *	parse_enter_macro __APROTO((FILE *f, int c));
void	m_invoke	__APROTO((int n));
void	m_startinput	__APROTO((void));
void	m_endinput	__APROTO((void));
void	m_advinput	__APROTO((void));
void	m_break_entry	__APROTO((void));
void	m_break		__APROTO((void));
void	macro_dbg	__APROTO((void));
int	m_getc		__APROTO((int *cp));
int	m_gets		__APROTO((char *s));
int	m_yes		__APROTO((void));

/* master.c */

void	nn_exit		__APROTO((int n));
void	clean_group	__APROTO((group_header *gh));
group_header *add_new_group __APROTO((char *name));
int	main		__APROTO((int argc, char **argv));
int	receive_admin	__APROTO((void));
void	write_error	__APROTO((void));
void	dummy_error	__APROTO((char *name));
int	suspend_nn	__APROTO((void));
void	user_delay	__APROTO((int n));

/* match.c */

void	fold_string	__APROTO((char *mask));
int	streq_fold	__APROTO((char *mask, char *str));
int	strmatch_fold	__APROTO((char *mask, char *str));
int	strmatch	__APROTO((char *mask, char *str));
int	strmatch_cf	__APROTO((char *mask, char *str));
int	regexec_fold	__APROTO((regexp *prog, char *string));
int	regexec_cf	__APROTO((regexp *prog, char *string));

/* menu.c */

int	prt_replies	__APROTO((int level));
char *	pct		__APROTO((long start, long end,	
				  long first, long last));
int	menu		__APROTO((fct_type print_header));
article_header *get_menu_article	__APROTO((void));
int	alt_command	__APROTO((void));

/* more.c */

int	get_header_field	__APROTO((int code, char **namep, char **valp,
				   article_header *ah));
void	scan_header_fields	__APROTO((char *fields, article_header *ah));
int	next_header_field	__APROTO((char **namep, char **valp,
					  fct_type *attrp));
int	more			__APROTO((article_header *ah, int mode,
					  int screen_offset));
void	rot13_line		__APROTO((char *cp));
#ifdef NOV
void	setpos			__APROTO((article_header *ah, FILE *art));
#endif
/* news.c */

char *	parse_header	__APROTO((FILE *f, char **(*hdr_field)(), 
				  int modes, news_header_buffer hdrbuf));
int	is_header_line	__APROTO((char *line));
FILE *	open_news_article __APROTO((article_header *art, int modes,
				    news_header_buffer buffer1,
				    news_header_buffer buffer2));

/* newsrc.c */

void	visit_rc_file	__APROTO((void));
void	use_newsrc	__APROTO((group_header *gh, int mode));
attr_type test_article	__APROTO((article_header *ah));
void	flush_newsrc	__APROTO((void));
int	restore_bak	__APROTO((void));
void	update_rc	__APROTO((group_header *gh));
void	update_rc_all	__APROTO((group_header *gh, int unsub));
void	add_to_newsrc	__APROTO((group_header *gh));
int32	restore_rc	__APROTO((group_header *gh, article_number last));
int	restore_unread	__APROTO((group_header *gh));
void	count_unread_articles	__APROTO((void));
void	prt_unread	__APROTO((char *format));
int	add_unread	__APROTO((group_header *gh, int mode));
void	opt_nngrep	__APROTO((int argc, char *argv[]));
void	do_grep		__APROTO((char **pat));
int	opt_nntidy	__APROTO((int argc, char *argv[]));
void	do_tidy_newsrc	__APROTO((void));
int	opt_nngoback	__APROTO((int argc, char ***argvp));
void	do_goback	__APROTO((void));
group_header *add_new_group	__APROTO((char *name));

/* nn.c */

void parseargv_variables(char **, int);
flag_type parse_access_flags	__APROTO((void));
int	unread_mail	__APROTO((time_t t));
void	stop_usage	__APROTO((void));
time_t	tick_usage	__APROTO((void));
void	log_usage	__APROTO((void));
void	emacs_mode	__APROTO((void));
int	display_motd	__APROTO((int check));
void	clean_group	__APROTO((group_header *gh));
int	main		__APROTO((int argc, char *argv[]));
void	nn_exit		__APROTO((int n));

/* nntp.c */

void	nntp_check		__APROTO((void));
int	nntp_no_post		__APROTO((void));
int	nntp_set_group		__APROTO((group_header *gh));
int	nntp_get_active		__APROTO((void));
FILE *	nntp_get_newsgroups	__APROTO((void));
FILE *	nntp_fopen_list		__APROTO((char *cmd));
char *	nntp_fgets		__APROTO((char *buf, int size));
article_number *nntp_get_article_list	__APROTO((group_header *gh));
FILE *	nntp_get_article	__APROTO((article_number article, int mode));
char *	nntp_get_filename	__APROTO((article_number art, group_header *gh));
void	nntp_close_server	__APROTO(());
void	nntp_cleanup		__APROTO((void));

/* options.c */

char *	program_name		__APROTO((char **av));
int	parse_options		__APROTO((int ac, char **av, char *envname,
					  struct option_descr options[],
					  char *usage));

/* pack_date.c */

time_stamp	pack_date	__APROTO((char *date));

/* pack_name.c */

int	pack_name		__APROTO((char *dest, char *source,
					  int length));

/* pack_subject.c */

int	pack_subject		__APROTO((char *dest, char *src,
					  int *re_counter_ptr,
					  int max_length));

/* prefix.c */

int	main	__APROTO((int argc, char *argv[]));
void	nn_exit	__APROTO((int n));
int	suspend_nn	__APROTO((void));

/* proto.c */

int	proto_lock	__APROTO((int prog, int command));
FILE *	open_gate_file	__APROTO((int mode));
void	send_master	__APROTO((int command, group_header *gh, int opt, long arg));

/* regexp.c */

regexp *regcomp	__APROTO((char *exp));
int	regexec	__APROTO((regexp *prog, char *string));
void	regsub	__APROTO((regexp *prog, char *source, char *dest));
void	regerror	__APROTO((char *s));

/* reroute.c */

int	reroute	__APROTO((char *route, char *address));

/* save.c */

void	set_folder_type	__APROTO((char *name));
char *	init_save	__APROTO((int command, char **mode_textp));
int	save	__APROTO((article_header *ah));
int	end_save	__APROTO((void));
void	store_header	__APROTO((article_header *ah, FILE *f, char *dir, char *file));
int	mailbox_format	__APROTO((FILE *f, int top));
char *	run_mkdir	__APROTO((char *dir, char *name_buf));
int	change_dir	__APROTO((char *dir, int in_init));

/* sequence.c */

int	only_folder_args	__APROTO((char **args));
void	parse_save_files	__APROTO((FILE *sf));
void	named_group_sequence	__APROTO((char **groups));
void	normal_group_sequence	__APROTO((void));
void	start_group_search	__APROTO((char *group));
group_header *get_group_search	__APROTO((void));

/* sort.c */

void	sort_articles	__APROTO((int mode));
void	no_sort_articles	__APROTO((void));
int	elim_articles	__APROTO((article_number *list, int list_lgt));

/* term.c */

void	micro_alarm	__APROTO((int n));
void	enter_multi_key	__APROTO((int code, key_type *keys));
void	dump_multi_keys	__APROTO((void));
void	init_term	__APROTO((int full));
void	home	__APROTO((void));
void	save_xy	__APROTO((void));
void	restore_xy	__APROTO((void));
void	gotoxy	__APROTO((int c, int l));
void	clrdisp	__APROTO((void));
void	clrline	__APROTO((void));
void	clrline_noflush	__APROTO((void));
void	clrpage	__APROTO((void));
void	tprintf(char *,...);
void	tputc	__APROTO((int c));
int	so_gotoxy	__APROTO((int, int, int));
void	so_printf(char *,...);
void	so_end	__APROTO((void));
void	so_printxy(int, int,char *,...);
int	underline	__APROTO((int on));
int	highlight	__APROTO((int on));
int	shadeline	__APROTO((int on));
void	visual_on	__APROTO((void));
int	visual_off	__APROTO((void));
void	nn_raw	__APROTO((void));
int	no_raw	__APROTO((void));
int	unset_raw	__APROTO((void));
void	flush_input	__APROTO((void));
int	get_c	__APROTO((void));
char *	get_s	__APROTO((char *dflt, char *prefill, char *break_chars, fct_type completion));
int	list_completion	__APROTO((char *str));
int	yes	__APROTO((int must_answer));
void	ding	__APROTO((void));
void	display_file	__APROTO((char *name, int modes));
void	push_msg	__APROTO((char *str));
void	clrmsg	__APROTO((int col));
void	prompt(char *,...);
int	any_key	__APROTO((int line));
void	pg_init	__APROTO((int first_line, int cols));
int	pg_scroll	__APROTO((int n));
int	pg_next	__APROTO((void));
void	pg_indent	__APROTO((int pos));
int	pg_end	__APROTO((void));
void	user_delay	__APROTO((int ticks));

/* unshar.c */

int	unshar_position	__APROTO((FILE *fil));

/* usercheck.c */

int	main	__APROTO((int argc, char *argv[]));

/* variable.c */

int	set_variable	__APROTO((char *variable, int on, char *val_string));
void	toggle_variable	__APROTO((char *variable));
void	lock_variable	__APROTO((char *variable));
int	test_variable	__APROTO((char *expr));
void	var_compl_opts	__APROTO((int col));
int	var_completion	__APROTO((char *path, int index));
void	mark_var_stack	__APROTO((void));
int	push_variable	__APROTO((char *variable));
void	restore_variables	__APROTO((void));
void	disp_variables	__APROTO((int all, char *rexp));
void	print_variable_config	__APROTO((FILE *f, int all));
void	var_options	__APROTO((char **str, char *options, flag_type *res));

#endif /* _NN_GLOBAL_H */
