/*-
 * customsInit.c --
 *	Initialize things so these functions may be used
 *
 * Copyright (c) 1988, 1989 by the Regents of the University of California
 * Copyright (c) 1988, 1989 by Adam de Boor
 * Copyright (c) 1989 by Berkeley Softworks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * Berkeley Softworks and Adam de Boor make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 */
#ifndef lint
static char *rcsid =
"$Id: customsInit.c,v 1.1 1994/05/18 23:00:01 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include    <stdio.h>
#include    <netdb.h>
#include    <fcntl.h>

#include    "customs.h"

int  	  	    	customs_Socket = -1;
struct sockaddr_in   	customs_AgentAddr;
struct timeval	    	customs_RetryTimeOut = {
    CUSTOMS_RETRY, CUSTOMS_URETRY
};
Rpc_Stat	  	customs_Status;		/* last RPC return code */

static short	    	udpPort,
			tcpPort;


/*-
 *-----------------------------------------------------------------------
 * Customs_Init --
 *	Initialize things so these functions may be used.
 *
 * Results:
 *	None.
 *
 * Side Effects:
 *	A udp socket is opened and customs_AgentAddr is initialized to be
 *	suitable for talking to the local agent.
 *
 *-----------------------------------------------------------------------
 */
void
Customs_Init()
{
    struct servent  *sep;
    int	    	i;

    i = 3;

    do {
	sep = getservbyname(CUSTOMS_SERVICE_NAME, "udp");
    } while (sep == NULL && i-- > 0);

    if (sep == NULL) {
#if 0
	printf("%s/udp unknown\n", CUSTOMS_SERVICE_NAME);
	/*XXX*/
	exit(1);
#else
	udpPort = DEF_CUSTOMS_UDP_PORT;
#endif
    } else {
	udpPort = ntohs(sep->s_port);
    }
    i = 3;
    do {
	sep = getservbyname(CUSTOMS_SERVICE_NAME, "tcp");
    } while (sep == NULL && i-- > 0);

    if (sep == NULL) {
#if 0
	printf("%s/tcp unknown\n", CUSTOMS_SERVICE_NAME);
	/*XXX*/
	exit(1);
#else
	tcpPort = DEF_CUSTOMS_TCP_PORT;
#endif
    } else {
	tcpPort = ntohs(sep->s_port);
    }
    
    /*
     * Try to use a reserved port so we may call CUSTOMS_HOST and 
     * other rpcs that require root priviledge.
     */
    customs_Socket = Rpc_UdpCreate(False, 0);
    if (customs_Socket < 0) {
	static Boolean printed = False;
	if (!printed) {
	    perror("Rpc_UdpCreate");
	    printed = True;
	}
    }
    else {
	(void)fcntl(customs_Socket, F_SETFD, 1);
    }

    memset(&customs_AgentAddr, 0, sizeof(customs_AgentAddr));
    customs_AgentAddr.sin_family = AF_INET;
    customs_AgentAddr.sin_port = htons(udpPort);
    customs_AgentAddr.sin_addr.s_addr = htonl(INADDR_LOOPBACK);
}
/*-
 *-----------------------------------------------------------------------
 * Customs_Port --
 *	Get the TCP port number for talking to customs
 *
 * Results:
 *	The port number in host byte order.
 *
 * Side Effects:
 *	None.
 *
 *-----------------------------------------------------------------------
 */
short
Customs_Port()
{
    if (customs_Socket == -1) {
	Customs_Init();
    }
    return tcpPort;
}

