/*-
 * customsHost.c --
 *	Request a host for exportation
 *
 * Copyright (c) 1988, 1989 by the Regents of the University of California
 * Copyright (c) 1988, 1989 by Adam de Boor
 * Copyright (c) 1989 by Berkeley Softworks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * Berkeley Softworks and Adam de Boor make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 */
#ifndef lint
static char *rcsid =
"$Id: customsHost.c,v 1.1 1994/05/18 23:00:01 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include    "customs.h"


/*-
 *-----------------------------------------------------------------------
 * Customs_Host --
 *	Request a host for exportation from the local agent. We send the
 *	effective user-id partly because it's in the protocol and
 *	partly because that's what determines file accesses...
 *
 * Results:
 *	The status of the call. If RPC_SUCCESS, permitPtr contains the
 *	agent's response, which may have an addr field of INADDR_ANY. This
 *	indicates that a host could not be allocated.
 *
 * Side Effects:
 *	None.
 *
 *-----------------------------------------------------------------------
 */
Rpc_Stat
Customs_Host(flags, permitPtr)
    short   	  flags;
    ExportPermit  *permitPtr;
{
    Host_Data	  data;
    
    data.uid = geteuid();
    data.flags = flags;
    *data.attrs = '\0';

    if (customs_Socket == -1) {
	Customs_Init();
    }
    customs_Status = Rpc_Call(customs_Socket, &customs_AgentAddr,
			  (Rpc_Proc)CUSTOMS_HOST,
			  sizeof(data), (Rpc_Opaque)&data,
			  sizeof(ExportPermit), (Rpc_Opaque)permitPtr,
			  CUSTOMS_NRETRY, &customs_RetryTimeOut);
    return(customs_Status);
}

