/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* gui_saveasdialog.c - creation and destructon of the saveasdialog 
 *
 * this shows a savedialog with an optionmenu added for the supported filetypes:
 * xlog, adif, cabrillo, EDI, trlog (tlf) and glabels. There are also 2 entries
 * which you can use to save part of the log. We do a check if the first QSO
 * number is lower than the last and display a warning dialog in case we overwrite
 * a previously created log.
 */
 

#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>

#include "types.h"
#include "log.h"
#include "gui_saveasdialog.h"
#include "support.h"
#include "utils.h"

extern GList *logwindowlist;
extern GtkWidget *mainnotebook;
extern GtkWidget *mainwindow;
extern preferencestype preferences;

void
on_menu_saveas_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	gint index, page, saveas_response, savewarning_response;
	GdkPixbuf *saveasdialog_icon_pixbuf;
	GtkWidget *saveasdialog, *ok_button, *cancel_button, *filemenu, *hbox, 
		*label, *menu, *item, *qsolabel, *lowqsoentry, *highqsoentry, *dash,
		*savewarningdialog, *savewarninglabel;
	logtype *logwindow;
	gchar *temp, *selection;
	struct stat statdir;
	GdkPixbuf *savewarningdialog_icon_pixbuf;
	GtkWidget *dialog_vbox;
	GtkWidget *dialog_action_area;
	GtkWidget *savewarningcancelbutton;
	GtkWidget *savewarningokbutton;
	gchar *logfile;
	gint type = 1;
	gint highqso, lowqso;


	page = gtk_notebook_get_current_page (GTK_NOTEBOOK(mainnotebook));
	if (page >= 0)
	{
		saveasdialog = gtk_file_selection_new (_("xlog - save as"));
		gtk_container_set_border_width (GTK_CONTAINER (saveasdialog), 10);
		gtk_window_set_position (GTK_WINDOW (saveasdialog), GTK_WIN_POS_MOUSE);
		saveasdialog_icon_pixbuf = create_pixbuf ("xlog.png");
		if (saveasdialog_icon_pixbuf)
		{
			gtk_window_set_icon (GTK_WINDOW (saveasdialog), saveasdialog_icon_pixbuf);
			g_object_unref (saveasdialog_icon_pixbuf);
		}
		/* optionmenu for the file types */
		hbox = gtk_hbox_new (FALSE, 0);
		gtk_container_add (GTK_CONTAINER(GTK_FILE_SELECTION (saveasdialog)->main_vbox), hbox);
		label = gtk_label_new (_("Type of log:"));
		gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 25);
		filemenu = gtk_option_menu_new ();
		gtk_widget_ref (filemenu);
		g_object_set_data_full (G_OBJECT (saveasdialog), "saveasmenu", filemenu, (GDestroyNotify) gtk_widget_unref);
		gtk_box_pack_start (GTK_BOX (hbox), filemenu, FALSE, FALSE, 0);
		menu = gtk_menu_new ();
		item = gtk_menu_item_new_with_label ("xlog");
		gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
		item = gtk_menu_item_new_with_label ("adif");
		gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
		item = gtk_menu_item_new_with_label ("cabrillo");
		gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
		item = gtk_menu_item_new_with_label ("EDI");
		gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
		item = gtk_menu_item_new_with_label ("labels");
		gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
		gtk_option_menu_set_menu (GTK_OPTION_MENU (filemenu), menu);
		gtk_option_menu_set_history (GTK_OPTION_MENU (filemenu), 0);
	
		qsolabel = gtk_label_new (_("Save QSO:"));
		gtk_box_pack_start (GTK_BOX (hbox), qsolabel, FALSE, FALSE, 25);
		lowqsoentry = gtk_entry_new ();
		gtk_widget_set_size_request (lowqsoentry, 50, -1);
		gtk_box_pack_start (GTK_BOX (hbox), lowqsoentry, FALSE, FALSE, 5);
		dash = gtk_label_new (_("to"));
		gtk_box_pack_start (GTK_BOX (hbox), dash, FALSE, FALSE, 5);
		highqsoentry = gtk_entry_new ();
		gtk_widget_set_size_request (highqsoentry, 50, -1);
		gtk_box_pack_start (GTK_BOX (hbox), highqsoentry, FALSE, FALSE, 5);
		
		logwindow = g_list_nth_data (logwindowlist, page);

		temp = g_strdup_printf ("1");
		gtk_entry_set_text (GTK_ENTRY (lowqsoentry), temp);
		temp = g_strdup_printf ("%d", logwindow->qsos);
		gtk_entry_set_text (GTK_ENTRY (highqsoentry), temp);
		g_free (temp);

		gtk_widget_show_all (hbox);

		ok_button = GTK_FILE_SELECTION (saveasdialog)->ok_button;
		gtk_widget_show (ok_button);
		GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
	
		cancel_button = GTK_FILE_SELECTION (saveasdialog)->cancel_button;
		gtk_widget_show (cancel_button);
		GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

		selection = g_strconcat (preferences.savedir, G_DIR_SEPARATOR_S, NULL);
		gtk_file_selection_set_filename (GTK_FILE_SELECTION (saveasdialog), selection);
		g_free (selection);

		saveas_response = gtk_dialog_run (GTK_DIALOG (saveasdialog));
		if (saveas_response == GTK_RESPONSE_OK)
		{
			item = gtk_menu_get_active (GTK_MENU (menu));
			index = g_list_index (GTK_MENU_SHELL (menu)->children, item);

			switch (index)
			{
			case 0:
				type = TYPE_FLOG;
				break;
			case 1:
				type = TYPE_ADIF;
				break;
			case 2:
				type = TYPE_CABRILLO;
				break;
			case 3:
				type = TYPE_EDI;
				break;
			case 4:
				type = TYPE_LABELS;
				break;
			default:
				type = 0;
			}

			logfile = g_strdup (gtk_file_selection_get_filename (GTK_FILE_SELECTION (saveasdialog)));
			stat (logfile, &statdir);
			if (S_ISDIR (statdir.st_mode))
				update_statusbar (_("No filename entered, log not saved"));
			else if (type == 0)
				update_statusbar (_("Unsupported log type, log not saved"));

			else
			{
 				temp = gtk_editable_get_chars (GTK_EDITABLE (lowqsoentry), 0, -1);
				lowqso = atoi (temp);
				temp = gtk_editable_get_chars (GTK_EDITABLE (highqsoentry), 0, -1);
				highqso = atoi (temp);
				logwindow = g_list_nth_data (logwindowlist, gtk_notebook_get_current_page (GTK_NOTEBOOK (mainnotebook)));
				if (lowqso > highqso || highqso > logwindow->qsos)
					update_statusbar(_("Cannot save log: invalid entry for first and/or last QSO"));
				else if (!fileexist (logfile))
				{
					savelog (logwindow, logfile, type, lowqso, highqso);
					temp = g_strdup_printf (_("Log saved to %s"),	logfile);
					update_statusbar (temp);
				}
				else
				{
					savewarningdialog = gtk_dialog_new ();
					gtk_window_set_title (GTK_WINDOW (savewarningdialog), _("xlog - saving"));
					gtk_window_set_position (GTK_WINDOW (savewarningdialog), GTK_WIN_POS_MOUSE);
					savewarningdialog_icon_pixbuf = create_pixbuf ("xlog.png");
					if (savewarningdialog_icon_pixbuf)
					{
						gtk_window_set_icon (GTK_WINDOW (savewarningdialog), savewarningdialog_icon_pixbuf);
						g_object_unref (savewarningdialog_icon_pixbuf);
					}
					dialog_vbox = GTK_DIALOG (savewarningdialog)->vbox;
					gtk_widget_show (dialog_vbox);
					temp = g_strdup_printf (_("%s already exist, do want to overwrite it?"), logfile);
					savewarninglabel = gtk_label_new (temp);
					gtk_widget_show (savewarninglabel);
					gtk_box_pack_start (GTK_BOX (dialog_vbox), savewarninglabel, FALSE, FALSE, 0);
					gtk_label_set_justify (GTK_LABEL (savewarninglabel), GTK_JUSTIFY_CENTER);
					gtk_label_set_line_wrap (GTK_LABEL (savewarninglabel), TRUE);
					gtk_misc_set_padding (GTK_MISC (savewarninglabel), 20, 20);

					dialog_action_area = GTK_DIALOG (savewarningdialog)->action_area;
					gtk_widget_show (dialog_action_area);
					gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_SPREAD);
					savewarningcancelbutton = gtk_button_new_from_stock ("gtk-cancel");
					gtk_widget_show (savewarningcancelbutton);
					gtk_dialog_add_action_widget (GTK_DIALOG (savewarningdialog), savewarningcancelbutton, GTK_RESPONSE_CANCEL);
					GTK_WIDGET_SET_FLAGS (savewarningcancelbutton, GTK_CAN_DEFAULT);
					savewarningokbutton = gtk_button_new_from_stock ("gtk-ok");
					gtk_widget_show (savewarningokbutton);
					gtk_dialog_add_action_widget (GTK_DIALOG (savewarningdialog), savewarningokbutton, GTK_RESPONSE_OK);
					GTK_WIDGET_SET_FLAGS (savewarningokbutton, GTK_CAN_DEFAULT);

 					savewarning_response = gtk_dialog_run (GTK_DIALOG(savewarningdialog));
					if (savewarning_response == GTK_RESPONSE_OK)
					{
						logwindow = g_list_nth_data (logwindowlist, gtk_notebook_get_current_page(GTK_NOTEBOOK (mainnotebook)));
						if (lowqso > highqso || highqso > logwindow->qsos)
	 						update_statusbar (_("Cannot save log: invalid entry for first and/or last QSO"));
						else
						{
							savelog (logwindow, logfile, type, lowqso, highqso);
							temp = g_strdup_printf (_("Log saved to %s"), logfile);
							update_statusbar (temp);
						}
					}
					gtk_widget_destroy (savewarningdialog);
				}
			}
			g_free (temp);
		}
	gtk_widget_destroy (saveasdialog);
	}
}
